/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.config;

import eu.midnightdust.lib.config.MidnightConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.kronoz.odyssey.config.OdysseyConfig;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_6382;

public final class OdysseyConfigScreen
extends class_437 {
    private final class_437 parent;
    private final List<Row> scrollRows = new ArrayList<Row>();
    private int contentStartY;
    private int contentHeight;
    private double scroll;
    private static final int VIEW_TOP_MARGIN = 8;
    private static final int VIEW_BOTTOM_MARGIN = 28;
    private class_4286 enableOverride;
    private class_4286 renderOverlay;

    public OdysseyConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Odyssey \u2014 First-Person Arm Tuning"));
        this.parent = parent;
    }

    protected void method_25426() {
        int y;
        int w = this.field_22789;
        int h = this.field_22790;
        int colW = 160;
        int gap = 12;
        int startX = (w - 332) / 2;
        this.method_37063((class_364)new Label(w / 2 - 100, h / 6 - 18, 200, 10, (class_2561)class_2561.method_43470((String)"First-person arm & item pose").method_27692(class_124.field_1065)));
        int x = startX;
        this.contentStartY = y = h / 6;
        this.enableOverride = class_4286.method_54787((class_2561)class_2561.method_43470((String)"Enable FP override"), (class_327)this.field_22793).method_54789(x, y).method_54794(OdysseyConfig.enableFirstPersonOverride).method_54788();
        this.addScrollable((class_339)this.enableOverride, x, y);
        this.renderOverlay = class_4286.method_54787((class_2561)class_2561.method_43470((String)"Render arm overlay (FP)"), (class_327)this.field_22793).method_54789(x + 160 + 12, y).method_54794(OdysseyConfig.renderArmOverlay).method_54788();
        this.addScrollable((class_339)this.renderOverlay, x + 160 + 12, y);
        y += 26;
        x = startX;
        y = this.addSectionLabel("Base Offsets (Held Item)", x, y);
        y = this.addFloatSlider(x, y, 160, "Base X", -1.5f, 1.5f, OdysseyConfig.heldBaseX, v -> {
            OdysseyConfig.heldBaseX = v.floatValue();
        });
        y = this.addFloatSlider(x, y, 160, "Base Y", -1.5f, 1.0f, OdysseyConfig.heldBaseY, v -> {
            OdysseyConfig.heldBaseY = v.floatValue();
        });
        y = this.addFloatSlider(x, y, 160, "Base Z", -2.0f, -0.1f, OdysseyConfig.heldBaseZ, v -> {
            OdysseyConfig.heldBaseZ = v.floatValue();
        });
        y = this.addFloatSlider(x, y, 160, "Scale", 0.5f, 1.5f, OdysseyConfig.heldScale, v -> {
            OdysseyConfig.heldScale = v.floatValue();
        });
        y = this.addSectionLabel("Follow-Down Curve", x, y + 6);
        y = this.addFloatSlider(x, y, 160, "Drop Y Max", 0.0f, 0.6f, OdysseyConfig.dropYMax, v -> {
            OdysseyConfig.dropYMax = v.floatValue();
        });
        y = this.addFloatSlider(x, y, 160, "Push Z Max", 0.0f, 0.8f, OdysseyConfig.pushZMax, v -> {
            OdysseyConfig.pushZMax = v.floatValue();
        });
        y = this.addFloatSlider(x, y, 160, "Inward X Max", 0.0f, 0.3f, OdysseyConfig.inwardXMax, v -> {
            OdysseyConfig.inwardXMax = v.floatValue();
        });
        int x2 = startX + 160 + 12;
        int y2 = h / 6 + 26;
        y2 = this.addSectionLabel("Swing / Equip Translations (Held)", x2, y2);
        y2 = this.addFloatSlider(x2, y2, 160, "Swing X", -0.3f, 0.3f, OdysseyConfig.swingX, v -> {
            OdysseyConfig.swingX = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Swing Y", -0.3f, 0.3f, OdysseyConfig.swingY, v -> {
            OdysseyConfig.swingY = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Swing Z", -0.5f, 0.3f, OdysseyConfig.swingZ, v -> {
            OdysseyConfig.swingZ = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Equip X", -0.3f, 0.3f, OdysseyConfig.equipX, v -> {
            OdysseyConfig.equipX = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Equip Y", -0.3f, 0.3f, OdysseyConfig.equipY, v -> {
            OdysseyConfig.equipY = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Equip Z", -0.5f, 0.3f, OdysseyConfig.equipZ, v -> {
            OdysseyConfig.equipZ = v.floatValue();
        });
        y2 = this.addSectionLabel("Intensities", x2, y2 + 6);
        y2 = this.addFloatSlider(x2, y2, 160, "Swing Intensity", 0.0f, 3.0f, OdysseyConfig.swingIntensity, v -> {
            OdysseyConfig.swingIntensity = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Equip Intensity", 0.0f, 3.0f, OdysseyConfig.equipIntensity, v -> {
            OdysseyConfig.equipIntensity = v.floatValue();
        });
        y2 = this.addSectionLabel("Rotations (deg)", x2, y2 + 6);
        y2 = this.addFloatSlider(x2, y2, 160, "Base Rot X", -90.0f, 90.0f, OdysseyConfig.heldRotX, v -> {
            OdysseyConfig.heldRotX = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Base Rot Y", -90.0f, 90.0f, OdysseyConfig.heldRotY, v -> {
            OdysseyConfig.heldRotY = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Base Rot Z", -90.0f, 90.0f, OdysseyConfig.heldRotZ, v -> {
            OdysseyConfig.heldRotZ = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Swing Rot X", 0.0f, 120.0f, OdysseyConfig.swingRotXDeg, v -> {
            OdysseyConfig.swingRotXDeg = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Swing Rot Y", 0.0f, 120.0f, OdysseyConfig.swingRotYDeg, v -> {
            OdysseyConfig.swingRotYDeg = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Swing Rot Z", 0.0f, 120.0f, OdysseyConfig.swingRotZDeg, v -> {
            OdysseyConfig.swingRotZDeg = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Equip Roll", 0.0f, 45.0f, OdysseyConfig.equipRollDeg, v -> {
            OdysseyConfig.equipRollDeg = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Pitch X", 0.0f, 90.0f, OdysseyConfig.pitchXDeg, v -> {
            OdysseyConfig.pitchXDeg = v.floatValue();
        });
        y2 = this.addSectionLabel("Arm (FP Overlay) \u2014 Base", x2, y2 + 6);
        y2 = this.addFloatSlider(x2, y2, 160, "Arm Base X", -1.0f, 1.0f, OdysseyConfig.armBaseX, v -> {
            OdysseyConfig.armBaseX = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Arm Base Y", -1.0f, 1.0f, OdysseyConfig.armBaseY, v -> {
            OdysseyConfig.armBaseY = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Arm Base Z", -1.5f, 0.3f, OdysseyConfig.armBaseZ, v -> {
            OdysseyConfig.armBaseZ = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Arm Scale", 0.5f, 1.5f, OdysseyConfig.armScale, v -> {
            OdysseyConfig.armScale = v.floatValue();
        });
        y2 = this.addSectionLabel("Arm (FP Overlay) \u2014 Rotations (deg)", x2, y2 + 6);
        y2 = this.addFloatSlider(x2, y2, 160, "Base Rot X", -90.0f, 90.0f, OdysseyConfig.armRotX, v -> {
            OdysseyConfig.armRotX = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Base Rot Y", -90.0f, 90.0f, OdysseyConfig.armRotY, v -> {
            OdysseyConfig.armRotY = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Base Rot Z", -90.0f, 90.0f, OdysseyConfig.armRotZ, v -> {
            OdysseyConfig.armRotZ = v.floatValue();
        });
        y2 = this.addSectionLabel("Arm (FP Overlay) \u2014 Swing/Equip/Pitch (deg)", x2, y2 + 6);
        y2 = this.addFloatSlider(x2, y2, 160, "Swing Rot X", 0.0f, 120.0f, OdysseyConfig.armSwingRotXDeg, v -> {
            OdysseyConfig.armSwingRotXDeg = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Swing Rot Y", 0.0f, 120.0f, OdysseyConfig.armSwingRotYDeg, v -> {
            OdysseyConfig.armSwingRotYDeg = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Swing Rot Z", 0.0f, 120.0f, OdysseyConfig.armSwingRotZDeg, v -> {
            OdysseyConfig.armSwingRotZDeg = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Equip Roll", 0.0f, 45.0f, OdysseyConfig.armEquipRollDeg, v -> {
            OdysseyConfig.armEquipRollDeg = v.floatValue();
        });
        y2 = this.addFloatSlider(x2, y2, 160, "Pitch X", 0.0f, 90.0f, OdysseyConfig.armPitchXDeg, v -> {
            OdysseyConfig.armPitchXDeg = v.floatValue();
        });
        int bottomY = Math.max(y, y2) + 16;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done").method_27692(class_124.field_1060), b -> this.closeAndSave()).method_46434(w / 2 - 75, Math.min(bottomY, h - 24), 150, 20).method_46431());
        this.contentHeight = Math.max(y, y2) - this.contentStartY;
        this.clampScroll();
        this.applyScrollToWidgets();
    }

    private int addSectionLabel(String title, int x, int y) {
        Label lab = new Label(x, y, 160, 10, (class_2561)class_2561.method_43470((String)title).method_27692(class_124.field_1054));
        this.addScrollable(lab, x, y);
        return y + 12;
    }

    private int addFloatSlider(int x, int y, int width, String label, float min, float max, float current, Consumer<Float> onChange) {
        FloatSlider s = new FloatSlider(x, y, width, 20, (class_2561)class_2561.method_43470((String)label), current, min, max, onChange);
        this.addScrollable((class_339)s, x, y);
        return y + 24;
    }

    private void addScrollable(class_339 w, int baseX, int baseY) {
        this.method_37063((class_364)w);
        this.scrollRows.add(new Row(w, baseX, baseY));
    }

    private void closeAndSave() {
        OdysseyConfig.enableFirstPersonOverride = this.enableOverride.method_20372();
        OdysseyConfig.renderArmOverlay = this.renderOverlay.method_20372();
        MidnightConfig.write((String)"odyssey");
        class_310.method_1551().method_1507(this.parent);
    }

    public void method_25419() {
        this.closeAndSave();
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int viewTop = this.contentStartY - 8;
        int viewBottom = this.field_22790 - 28;
        if (mouseY >= (double)viewTop && mouseY <= (double)viewBottom) {
            this.scroll -= verticalAmount * 16.0;
            this.clampScroll();
            this.applyScrollToWidgets();
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void clampScroll() {
        int viewHeight = this.field_22790 - 28 - (this.contentStartY - 8);
        int max = Math.max(0, this.contentHeight - viewHeight);
        if (this.scroll < 0.0) {
            this.scroll = 0.0;
        }
        if (this.scroll > (double)max) {
            this.scroll = max;
        }
    }

    private void applyScrollToWidgets() {
        int viewTop = this.contentStartY - 8;
        int viewBottom = this.field_22790 - 28;
        for (Row r : this.scrollRows) {
            int newY = (int)Math.round((double)r.baseY - this.scroll);
            r.w.method_46421(r.baseX);
            r.w.method_46419(newY);
            r.w.field_22764 = newY + r.w.method_25364() >= viewTop && newY <= viewBottom;
        }
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.method_25420(ctx, mouseX, mouseY, delta);
        super.method_25394(ctx, mouseX, mouseY, delta);
        ctx.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, this.contentStartY - 18, 0xFFFFFF);
        this.drawScrollbar(ctx);
    }

    private void drawScrollbar(class_332 ctx) {
        int viewBottom = this.field_22790 - 28;
        int viewTop = this.contentStartY - 8;
        int viewHeight = viewBottom - viewTop;
        if (this.contentHeight <= viewHeight) {
            return;
        }
        int barX = this.field_22789 - 6;
        int barW = 3;
        double ratio = (double)viewHeight / (double)this.contentHeight;
        int thumbH = Math.max(16, (int)Math.round((double)viewHeight * ratio));
        int maxScroll = this.contentHeight - viewHeight;
        int thumbY = (int)Math.round((double)viewTop + this.scroll / (double)maxScroll * (double)(viewHeight - thumbH));
        ctx.method_25294(barX, viewTop, barX + barW, viewBottom, 0x55000000);
        ctx.method_25294(barX, thumbY, barX + barW, thumbY + thumbH, -5592406);
    }

    private static final class Label
    extends class_339 {
        private final class_2561 text;

        Label(int x, int y, int w, int h, class_2561 text) {
            super(x, y, w, h, text);
            this.text = text;
            this.field_22763 = false;
            this.field_22764 = true;
        }

        protected void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
            ctx.method_51439(class_310.method_1551().field_1772, this.text, this.method_46426(), this.method_46427(), 0xFFFFFF, false);
        }

        protected void method_47399(class_6382 builder) {
        }
    }

    private static final class FloatSlider
    extends class_357 {
        private final String label;
        private final float min;
        private final float max;
        private float valueF;
        private final Consumer<Float> onChange;

        FloatSlider(int x, int y, int w, int h, class_2561 label, float current, float min, float max, Consumer<Float> onChange) {
            super(x, y, w, h, label, FloatSlider.normalize(current, min, max));
            this.label = label.getString();
            this.min = min;
            this.max = max;
            this.valueF = current;
            this.onChange = onChange;
            this.method_25346();
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43470((String)(this.label + ": " + String.format("%.3f", Float.valueOf(this.valueF)))));
        }

        protected void method_25344() {
            this.valueF = FloatSlider.denormalize(this.field_22753, this.min, this.max);
            this.onChange.accept(Float.valueOf(this.valueF));
            this.method_25346();
        }

        private static double normalize(float v, float min, float max) {
            return Math.max(0.0, Math.min(1.0, (double)((v - min) / (max - min))));
        }

        private static float denormalize(double n, float min, float max) {
            return (float)((double)min + n * (double)(max - min));
        }
    }

    private static final class Row {
        final class_339 w;
        final int baseX;
        final int baseY;

        Row(class_339 w, int baseX, int baseY) {
            this.w = w;
            this.baseX = baseX;
            this.baseY = baseY;
        }
    }
}

