/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.dialogue;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.kronoz.odyssey.dialogue.ServerTickScheduler;
import net.kronoz.odyssey.dialogue.Step;
import net.kronoz.odyssey.dialogue.net.s2c.CaptionClearS2C;
import net.kronoz.odyssey.dialogue.net.s2c.CaptionPlayS2C;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public final class Script {
    private final class_2960 dialogueId;
    private final List<Step> steps = new ArrayList<Step>();

    public Script(class_2960 dialogueId) {
        this.dialogueId = dialogueId;
    }

    public Script say(int atTicks, int durationTicks, String caption) {
        this.steps.add(new Step(atTicks, durationTicks, caption, null));
        return this;
    }

    public Script say(int atTicks, int durationTicks, String caption, class_2960 soundId) {
        this.steps.add(new Step(atTicks, durationTicks, caption, soundId));
        return this;
    }

    void scheduleFor(class_3222 p) {
        this.steps.sort((a, b) -> Integer.compare(a.atTicks(), b.atTicks()));
        for (Step st : this.steps) {
            int start = Math.max(0, st.atTicks());
            int dur = Math.max(1, st.durationTicks());
            ServerTickScheduler.add(new ServerTickScheduler.Task(start, () -> ServerPlayNetworking.send((class_3222)p, (class_8710)new CaptionPlayS2C(st.caption(), Optional.ofNullable(st.soundId()), dur))));
            ServerTickScheduler.add(new ServerTickScheduler.Task(start + dur, () -> ServerPlayNetworking.send((class_3222)p, (class_8710)new CaptionClearS2C())));
        }
    }
}

