/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.entity.sentry;

import net.kronoz.odyssey.entity.sentry.SentryLookGoal;
import net.kronoz.odyssey.entity.sentry.SentryMeleeGoal;
import net.kronoz.odyssey.init.ModItems;
import net.kronoz.odyssey.init.ModParticles;
import net.kronoz.odyssey.init.ModSounds;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class SentryEntity
extends class_1314
implements GeoEntity {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final class_2940<Float> TRACK_HEAD_PITCH = class_2945.method_12791(SentryEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> TRACK_EYE_YAW = class_2945.method_12791(SentryEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> TRACK_EYE_PITCH = class_2945.method_12791(SentryEntity.class, (class_2941)class_2943.field_13320);
    public static final float HEAD_PITCH_MIN = (float)Math.toRadians(-45.0);
    public static final float HEAD_PITCH_MAX = (float)Math.toRadians(45.0);
    public static final float EYE_YAW_MIN = (float)Math.toRadians(-50.0);
    public static final float EYE_YAW_MAX = (float)Math.toRadians(50.0);
    public static final float EYE_PITCH_MIN = (float)Math.toRadians(-30.0);
    public static final float EYE_PITCH_MAX = (float)Math.toRadians(30.0);
    private int ticksSinceHit = 0;
    private boolean wasHitRecently = false;
    private boolean shieldDown = false;
    private static final class_2940<Integer> HIT_COUNT = class_2945.method_12791(SentryEntity.class, (class_2941)class_2943.field_13327);
    private int hitCount = 0;

    public SentryEntity(class_1299<? extends class_1314> type, class_1937 world) {
        super(type, world);
        this.field_6207 = new class_1335((class_1308)this);
        this.field_6194 = 0;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1314.method_26828().method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23719, 0.18).method_26868(class_5134.field_23721, 7.0).method_26868(class_5134.field_23717, 40.0).method_26868(class_5134.field_23724, 6.0).method_26868(class_5134.field_23718, 10.0);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!this.shieldDown) {
            boolean axeHit = false;
            class_1297 attacker = source.method_5529();
            this.method_5783(ModSounds.ENERGY_SHIELD_HIT, 0.7f, 1.0f);
            if (attacker instanceof class_1657) {
                class_1657 player = (class_1657)attacker;
                axeHit = player.method_6047().method_31574(ModItems.SPEAR_DASH);
                double x1 = this.method_23317();
                double y1 = this.method_23318() + (double)this.method_17682() / 2.0;
                double z1 = this.method_23321();
                double x2 = player.method_23317();
                double y2 = player.method_23318() + (double)player.method_17682() / 2.0;
                double z2 = player.method_23321();
                double midX = (x1 + x2) / 2.0;
                double midY = (y1 + y2) / 2.0;
                double midZ = (z1 + z2) / 2.0;
                this.method_37908().method_8406((class_2394)ModParticles.SENTRY_SHIELD_FULL_PARTICLE, midX, midY, midZ, 0.0, 0.0, 0.0);
            }
            if (axeHit) {
                this.wasHitRecently = true;
                this.ticksSinceHit = 0;
                ++this.hitCount;
                if (this.hitCount >= 4) {
                    this.shieldDown = true;
                    this.method_5783(ModSounds.ENERGY_SHIELD_BREAK, 1.0f, 2.0f);
                }
            }
            return false;
        }
        return super.method_5643(source, amount);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("HitCount", this.hitCount);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.hitCount = nbt.method_10550("HitCount");
    }

    public int getHitCount() {
        return this.hitCount;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(ModSounds.SENTRY_STEP, 0.3f, 1.0f);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(TRACK_HEAD_PITCH, (Object)Float.valueOf(0.0f));
        builder.method_56912(TRACK_EYE_YAW, (Object)Float.valueOf(0.0f));
        builder.method_56912(TRACK_EYE_PITCH, (Object)Float.valueOf(0.0f));
        builder.method_56912(HIT_COUNT, (Object)0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new SentryMeleeGoal(this, 1.35, true));
        this.field_6201.method_6277(2, (class_1352)new SentryLookGoal(this));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true, p -> !p.method_7325() && !p.method_56992() && p.method_6059(class_1294.field_5911)));
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1409 nav = new class_1409((class_1308)this, world);
        nav.method_6363(true);
        nav.method_6354(false);
        nav.method_35139(true);
        return nav;
    }

    public void method_5773() {
        super.method_5773();
        this.method_5636(this.method_36454());
        this.method_5847(this.method_36454());
        if (this.wasHitRecently) {
            ++this.ticksSinceHit;
            if (this.ticksSinceHit > 40) {
                this.wasHitRecently = false;
                this.hitCount = 0;
                this.ticksSinceHit = 0;
                class_2487 nbt = new class_2487();
                this.method_5652(nbt);
            }
        }
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    public void setHeadPitch(float pitchRad) {
        this.field_6011.method_12778(TRACK_HEAD_PITCH, (Object)Float.valueOf(class_3532.method_15363((float)pitchRad, (float)HEAD_PITCH_MIN, (float)HEAD_PITCH_MAX)));
    }

    public float getHeadPitch() {
        return ((Float)this.field_6011.method_12789(TRACK_HEAD_PITCH)).floatValue();
    }

    public void setEye(float yawRad, float pitchRad) {
        this.field_6011.method_12778(TRACK_EYE_YAW, (Object)Float.valueOf(class_3532.method_15363((float)yawRad, (float)EYE_YAW_MIN, (float)EYE_YAW_MAX)));
        this.field_6011.method_12778(TRACK_EYE_PITCH, (Object)Float.valueOf(class_3532.method_15363((float)pitchRad, (float)EYE_PITCH_MIN, (float)EYE_PITCH_MAX)));
    }

    public float getEyeYaw() {
        return ((Float)this.field_6011.method_12789(TRACK_EYE_YAW)).floatValue();
    }

    public float getEyePitch() {
        return ((Float)this.field_6011.method_12789(TRACK_EYE_PITCH)).floatValue();
    }

    public boolean method_5810() {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar reg) {
        reg.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private PlayState predicate(AnimationState<SentryEntity> s) {
        if (s.isMoving()) {
            s.getController().setAnimation(RawAnimation.begin().then("animation.sentry.walk", Animation.LoopType.LOOP));
        } else {
            s.getController().setAnimation(RawAnimation.begin().then("animation.sentry.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

