/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.hud.bosshud;

import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_9779;

public final class BossHudClient
implements HudRenderCallback {
    private static final long TIMEOUT_MS = 1500L;
    private static final long SHAKE_MS = 800L;
    private static final class_2960[] TEX_TIER = new class_2960[]{class_2960.method_60655((String)"odyssey", (String)"textures/gui/apostasy/apostasy1.png"), class_2960.method_60655((String)"odyssey", (String)"textures/gui/apostasy/apostasy2.png"), class_2960.method_60655((String)"odyssey", (String)"textures/gui/apostasy/apostasy3.png"), class_2960.method_60655((String)"odyssey", (String)"textures/gui/apostasy/apostasy4.png")};
    private static final class_2960 TEX_FILL = class_2960.method_60655((String)"odyssey", (String)"textures/gui/apostasy/apostasy5.png");
    private static final int SRC_W = 274;
    private static final int SRC_H = 144;
    private static volatile boolean active;
    private static volatile float health;
    private static volatile float maxHealth;
    private static volatile String title;
    private static volatile long lastUpdateMs;
    private static float alpha;
    private static int lastTier;
    private static long shakeUntilMs;

    public static void register() {
        HudRenderCallback.EVENT.register((Object)new BossHudClient());
    }

    public static void put(int entityId, String ignored, float hp, float maxHp) {
        health = hp;
        maxHealth = Math.max(0.001f, maxHp);
        lastUpdateMs = class_156.method_658();
        active = true;
        int tierNow = BossHudClient.tierFor(health / maxHealth);
        if (tierNow != lastTier) {
            lastTier = tierNow;
            shakeUntilMs = lastUpdateMs + 800L;
        }
    }

    public static void clear() {
        active = false;
    }

    private static int tierFor(float pct) {
        if (pct >= 0.75f) {
            return 0;
        }
        if (pct >= 0.5f) {
            return 1;
        }
        if (pct >= 0.25f) {
            return 2;
        }
        return 3;
    }

    public void onHudRender(class_332 ctx, class_9779 tick) {
        if (!active) {
            if ((alpha = Math.max(0.0f, alpha - 0.08f)) <= 0.0f) {
                return;
            }
        } else {
            boolean timedOut;
            boolean bl = timedOut = class_156.method_658() - lastUpdateMs > 1500L;
            if (timedOut) {
                active = false;
            }
            alpha = Math.min(1.0f, alpha + 0.08f);
        }
        int sw = ctx.method_51421();
        int sh = ctx.method_51443();
        float scale = 0.5f;
        int fullW = 274;
        int fullH = 144;
        int dw = Math.round((float)fullW * scale);
        int dh = Math.round((float)fullH * scale);
        int baseX = (sw - dw) / 2;
        int baseY = 0;
        int sx = 0;
        int sy = 0;
        long now = class_156.method_658();
        if (now < shakeUntilMs) {
            float t = (float)(shakeUntilMs - now) / 800.0f;
            float amp = 8.0f * (1.0f - t * t);
            sx = Math.toIntExact(Math.round(Math.sin((double)now * 0.045) * (double)amp));
            sy = Math.toIntExact(Math.round(Math.cos((double)now * 0.057) * (double)amp));
        }
        float pct = class_3532.method_15363((float)(health / maxHealth), (float)0.0f, (float)1.0f);
        int tier = Math.max(0, Math.min(3, BossHudClient.tierFor(pct)));
        int drawX = baseX + sx;
        int drawY = baseY + sy;
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416((float)drawX, (float)drawY, 0.0f);
        ctx.method_51448().method_22905(scale, scale, 1.0f);
        int a = Math.round(alpha * 255.0f);
        ctx.method_51422(1.0f, 1.0f, 1.0f, alpha);
        ctx.method_25290(TEX_TIER[tier], 0, 0, 0.0f, 0.0f, fullW, fullH, 274, 144);
        ctx.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        int fillSrcW = Math.max(0, Math.round(274.0f * pct));
        if (fillSrcW > 0) {
            ctx.method_25290(TEX_FILL, 0, 0, 0.0f, 0.0f, fillSrcW, fullH, 274, 144);
        }
        ctx.method_51448().method_22909();
    }

    static {
        health = 0.0f;
        maxHealth = 1.0f;
        title = "Apostasy";
        alpha = 0.0f;
        lastTier = -1;
        shakeUntilMs = 0L;
    }
}

