/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.item.custom;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.kronoz.odyssey.item.client.renderer.SpearRenderer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5134;
import net.minecraft.class_756;
import net.minecraft.class_9274;
import net.minecraft.class_9279;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.DefaultAnimations;

public class SpearDashItem
extends class_1829
implements GeoItem {
    private static final String KEY_ACTIVE = "Active";
    private static final String KEY_EXPIRE = "Expire";
    private static final String KEY_DASH = "DashTicks";
    private static final int DASH_TICKS = 10;
    private static final double DASH_SPEED = 1.25;
    private static final float DASH_DAMAGE = 8.0f;
    private static final int ACTIVE_TIMEOUT = 200;
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final RawAnimation ANIM_INACTIVE = RawAnimation.begin().thenLoop("inactive_loop");
    private static final RawAnimation ANIM_ACTIVATE = RawAnimation.begin().thenPlay("activate");
    private static final RawAnimation ANIM_ACTIVE = RawAnimation.begin().thenLoop("active_loop");

    public SpearDashItem(class_1832 material, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(material, SpearDashItem.withAttributes(settings, attackDamage, attackSpeed));
    }

    private static class_1792.class_1793 withAttributes(class_1792.class_1793 base, int attackDamage, float attackSpeed) {
        class_9285.class_9286 b = class_9285.method_57480();
        b.method_57487(class_5134.field_23721, new class_1322(class_2960.method_60655((String)"randomstuff", (String)"avogaglaive_damage"), (double)attackDamage, class_1322.class_1323.field_6328), class_9274.field_49217);
        b.method_57487(class_5134.field_23723, new class_1322(class_2960.method_60655((String)"randomstuff", (String)"avogaglaive_speed"), (double)attackSpeed, class_1322.class_1323.field_6328), class_9274.field_49217);
        return base.method_57349(class_9334.field_49636, (Object)b.method_57486());
    }

    private static class_2487 getOrCreate(class_1799 stack) {
        class_9279 comp = (class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)new class_2487()));
        class_2487 tag = comp.method_57461();
        if (tag == null) {
            tag = new class_2487();
        }
        return tag;
    }

    public static boolean isRenderActive(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        class_2487 tag = SpearDashItem.getOrCreate(stack);
        if (!tag.method_10545(KEY_ACTIVE)) {
            return false;
        }
        boolean active = tag.method_10577(KEY_ACTIVE);
        return active;
    }

    private static void save(class_1799 stack, class_2487 tag) {
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
    }

    private static boolean isActive(class_1799 s) {
        return SpearDashItem.getOrCreate(s).method_10577(KEY_ACTIVE);
    }

    private static long now(class_1937 w) {
        return w.method_8510();
    }

    private static void setActive(class_1799 s, class_1937 w, boolean v) {
        class_2487 n = SpearDashItem.getOrCreate(s);
        n.method_10556(KEY_ACTIVE, v);
        if (v) {
            n.method_10544(KEY_EXPIRE, SpearDashItem.now(w) + 200L);
        }
        SpearDashItem.save(s, n);
    }

    private static void bumpExpire(class_1799 s, class_1937 w) {
        class_2487 n = SpearDashItem.getOrCreate(s);
        n.method_10556(KEY_ACTIVE, true);
        n.method_10544(KEY_EXPIRE, SpearDashItem.now(w) + 200L);
        SpearDashItem.save(s, n);
    }

    private static void autoDeactivate(class_1799 s, class_1937 w) {
        class_2487 n = SpearDashItem.getOrCreate(s);
        if (n.method_10577(KEY_ACTIVE) && SpearDashItem.now(w) >= n.method_10537(KEY_EXPIRE)) {
            n.method_10556(KEY_ACTIVE, false);
            SpearDashItem.save(s, n);
        }
    }

    private static void setDash(class_1799 s, int t) {
        class_2487 n = SpearDashItem.getOrCreate(s);
        n.method_10569(KEY_DASH, t);
        SpearDashItem.save(s, n);
    }

    private static int getDash(class_1799 s) {
        return SpearDashItem.getOrCreate(s).method_10550(KEY_DASH);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (!world.field_9236) {
            class_243 look = user.method_5828(1.0f).method_1029();
            class_243 horiz = new class_243(look.field_1352, 0.0, look.field_1350);
            if (horiz.method_1027() > 0.0) {
                horiz = horiz.method_1029();
            }
            user.method_60491(horiz.method_1021(1.25));
            user.field_6037 = true;
            SpearDashItem.setDash(stack, 10);
            user.method_7357().method_7906((class_1792)this, 14);
            world.method_8396(null, user.method_24515(), class_3417.field_14706, class_3419.field_15248, 0.9f, 1.1f);
            user.method_7259(class_3468.field_15372.method_14956((Object)this));
        }
        return class_1271.method_29237((Object)stack, (boolean)world.field_9236);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!attacker.method_37908().field_9236) {
            if (!SpearDashItem.isActive(stack)) {
                SpearDashItem.setActive(stack, attacker.method_37908(), true);
            } else {
                SpearDashItem.bumpExpire(stack, attacker.method_37908());
            }
        }
        return super.method_7873(stack, target, attacker);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        if (!user.method_37908().field_9236) {
            if (!SpearDashItem.isActive(stack)) {
                SpearDashItem.setActive(stack, user.method_37908(), true);
            } else {
                SpearDashItem.bumpExpire(stack, user.method_37908());
            }
        }
        return class_1269.field_5811;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (world.field_9236 || !(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        SpearDashItem.autoDeactivate(stack, world);
        int dt = SpearDashItem.getDash(stack);
        if (dt > 0) {
            SpearDashItem.setDash(stack, dt - 1);
            if (player.field_5976) {
                if (!SpearDashItem.isActive(stack)) {
                    SpearDashItem.setActive(stack, world, true);
                } else {
                    SpearDashItem.bumpExpire(stack, world);
                }
                world.method_8396(null, player.method_24515(), class_3417.field_14785, class_3419.field_15248, 0.5f, 1.8f);
            }
            if (SpearDashItem.isActive(stack)) {
                this.dealDashDamage(world, player, stack);
            } else {
                class_239 hr = player.method_5745(1.5, 0.0f, false);
                if (hr.method_17783() == class_239.class_240.field_1332) {
                    SpearDashItem.setActive(stack, world, true);
                    world.method_8396(null, player.method_24515(), class_3417.field_14808, class_3419.field_15248, 0.6f, 1.3f);
                }
            }
        }
    }

    private void dealDashDamage(class_1937 world, class_1657 player, class_1799 stack) {
        Predicate<class_1297> valid;
        class_243 look;
        class_243 ahead;
        class_243 pos = player.method_19538();
        class_238 box = new class_238(pos, ahead = pos.method_1019((look = player.method_5828(1.0f).method_1029()).method_1021(1.2))).method_1009(0.6, 0.6, 0.6);
        List hits = world.method_8333((class_1297)player, box, valid = e -> e.method_5805() && e != player && e instanceof class_1309 && player.method_6057(e));
        if (!hits.isEmpty()) {
            for (class_1297 e2 : hits) {
                if (!(e2 instanceof class_1309)) continue;
                class_1309 le = (class_1309)e2;
                e2.method_5643(player.method_48923().method_48802(player), 8.0f);
                class_243 kb = look.method_1021(0.5).method_1031(0.0, 0.1, 0.0);
                e2.method_5762(kb.field_1352, kb.field_1351, kb.field_1350);
                e2.field_6037 = true;
            }
            SpearDashItem.bumpExpire(stack, world);
            world.method_8396(null, player.method_24515(), class_3417.field_15016, class_3419.field_15248, 1.0f, 1.2f);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar c) {
        c.add(new AnimationController((GeoAnimatable)this, "spear", 5, state -> {
            class_1799 s = (class_1799)state.getData(DataTickets.ITEMSTACK);
            if (s == null) {
                return state.setAndContinue(DefaultAnimations.IDLE);
            }
            boolean active = SpearDashItem.isActive(s);
            if (active) {
                if (state.getController().getCurrentAnimation() == null) {
                    return state.setAndContinue(ANIM_ACTIVATE);
                }
                if (state.getController().hasAnimationFinished()) {
                    return state.setAndContinue(ANIM_ACTIVE);
                }
                return state.setAndContinue(ANIM_ACTIVE);
            }
            return state.setAndContinue(ANIM_INACTIVE);
        }));
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private SpearRenderer renderer;

            public class_756 getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new SpearRenderer();
                }
                return this.renderer;
            }
        });
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

