/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.net;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.kronoz.odyssey.systems.cinematics.runtime.CutsceneManager;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public final class CineNetworking {
    private CineNetworking() {
    }

    public static void registerCommon() {
        PayloadTypeRegistry.playS2C().register(PlayPayload.ID, PlayPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(StopPayload.ID, StopPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(SpeedPayload.ID, SpeedPayload.CODEC);
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClient() {
        ClientPlayNetworking.registerGlobalReceiver(PlayPayload.ID, (payload, context) -> {
            class_310 client = context.client();
            client.execute(() -> {
                if (CutsceneManager.I.play(payload.sceneId())) {
                    CutsceneManager.I.setSpeed(payload.speed());
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(StopPayload.ID, (payload, context) -> context.client().execute(CutsceneManager.I::stop));
        ClientPlayNetworking.registerGlobalReceiver(SpeedPayload.ID, (payload, context) -> context.client().execute(() -> CutsceneManager.I.setSpeed(payload.speed())));
    }

    public static void playAll(MinecraftServer server, String id, double speed) {
        PlayPayload payload = new PlayPayload(id, speed);
        for (class_3222 p : server.method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)p, (class_8710)payload);
        }
    }

    public static void stopAll(MinecraftServer server) {
        StopPayload payload = new StopPayload();
        for (class_3222 p : server.method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)p, (class_8710)payload);
        }
    }

    public static void speedAll(MinecraftServer server, double speed) {
        SpeedPayload payload = new SpeedPayload(speed);
        for (class_3222 p : server.method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)p, (class_8710)payload);
        }
    }

    public record PlayPayload(String sceneId, double speed) implements class_8710
    {
        public static final class_8710.class_9154<PlayPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"odyssey", (String)"play"));
        public static final class_9139<class_9129, PlayPayload> CODEC = class_9139.method_56435((class_9139)class_9135.field_48554, PlayPayload::sceneId, (class_9139)class_9135.field_48553, PlayPayload::speed, PlayPayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record StopPayload() implements class_8710
    {
        public static final class_8710.class_9154<StopPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"odyssey", (String)"stop"));
        public static final class_9139<class_9129, StopPayload> CODEC = class_9139.method_56438((buf, value) -> {}, buf -> new StopPayload());

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record SpeedPayload(double speed) implements class_8710
    {
        public static final class_8710.class_9154<SpeedPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"odyssey", (String)"speed"));
        public static final class_9139<class_9129, SpeedPayload> CODEC = class_9139.method_56434((class_9139)class_9135.field_48553, SpeedPayload::speed, SpeedPayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }
}

