/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.cinematics.api;

public enum Easing {
    LINEAR,
    IN_QUAD,
    OUT_QUAD,
    IN_OUT_QUAD,
    IN_CUBIC,
    OUT_CUBIC,
    IN_OUT_CUBIC,
    IN_QUART,
    OUT_QUART,
    IN_OUT_QUART,
    IN_QUINT,
    OUT_QUINT,
    IN_OUT_QUINT,
    IN_SINE,
    OUT_SINE,
    IN_OUT_SINE,
    IN_EXPO,
    OUT_EXPO,
    IN_OUT_EXPO,
    IN_CIRC,
    OUT_CIRC,
    IN_OUT_CIRC,
    IN_BACK,
    OUT_BACK,
    IN_OUT_BACK;


    public double apply(double t) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> t;
            case 1 -> t * t;
            case 2 -> 1.0 - (1.0 - t) * (1.0 - t);
            case 3 -> {
                if (t < 0.5) {
                    yield 2.0 * t * t;
                }
                yield 1.0 - Math.pow(-2.0 * t + 2.0, 2.0) / 2.0;
            }
            case 4 -> t * t * t;
            case 5 -> 1.0 - Math.pow(1.0 - t, 3.0);
            case 6 -> {
                if (t < 0.5) {
                    yield 4.0 * t * t * t;
                }
                yield 1.0 - Math.pow(-2.0 * t + 2.0, 3.0) / 2.0;
            }
            case 7 -> Math.pow(t, 4.0);
            case 8 -> 1.0 - Math.pow(1.0 - t, 4.0);
            case 9 -> {
                if (t < 0.5) {
                    yield 8.0 * t * t * t * t;
                }
                yield 1.0 - Math.pow(-2.0 * t + 2.0, 4.0) / 2.0;
            }
            case 10 -> Math.pow(t, 5.0);
            case 11 -> 1.0 - Math.pow(1.0 - t, 5.0);
            case 12 -> {
                if (t < 0.5) {
                    yield 16.0 * t * t * t * t * t;
                }
                yield 1.0 - Math.pow(-2.0 * t + 2.0, 5.0) / 2.0;
            }
            case 13 -> 1.0 - Math.cos(t * Math.PI / 2.0);
            case 14 -> Math.sin(t * Math.PI / 2.0);
            case 15 -> -(Math.cos(Math.PI * t) - 1.0) / 2.0;
            case 16 -> {
                if (t == 0.0) {
                    yield 0.0;
                }
                yield Math.pow(2.0, 10.0 * t - 10.0);
            }
            case 17 -> {
                if (t == 1.0) {
                    yield 1.0;
                }
                yield 1.0 - Math.pow(2.0, -10.0 * t);
            }
            case 18 -> {
                if (t == 0.0) {
                    yield 0.0;
                }
                if (t == 1.0) {
                    yield 1.0;
                }
                if (t < 0.5) {
                    yield Math.pow(2.0, 20.0 * t - 10.0) / 2.0;
                }
                yield (2.0 - Math.pow(2.0, -20.0 * t + 10.0)) / 2.0;
            }
            case 19 -> 1.0 - Math.sqrt(1.0 - t * t);
            case 20 -> Math.sqrt(1.0 - Math.pow(t - 1.0, 2.0));
            case 21 -> {
                if (t < 0.5) {
                    yield (1.0 - Math.sqrt(1.0 - 4.0 * t * t)) / 2.0;
                }
                yield (Math.sqrt(1.0 - Math.pow(-2.0 * t + 2.0, 2.0)) + 1.0) / 2.0;
            }
            case 22 -> 2.70158 * t * t * t - 1.70158 * t * t;
            case 23 -> 1.0 + 2.70158 * Math.pow(t - 1.0, 3.0) + 1.70158 * Math.pow(t - 1.0, 2.0);
            case 24 -> {
                double c1 = 1.70158;
                double c2 = c1 * 1.525;
                if (t < 0.5) {
                    yield Math.pow(2.0 * t, 2.0) * ((c2 + 1.0) * 2.0 * t - c2) / 2.0;
                }
                yield (Math.pow(2.0 * t - 2.0, 2.0) * ((c2 + 1.0) * (t * 2.0 - 2.0) + c2) + 2.0) / 2.0;
            }
        };
    }
}

