/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.cinematics.api;

import java.util.function.BiConsumer;
import net.kronoz.odyssey.systems.cinematics.api.Easing;
import net.minecraft.class_3532;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public final class EasingUtil {
    private EasingUtil() {
    }

    public static float clamp01(float t) {
        if (t <= 0.0f) {
            return 0.0f;
        }
        if (t >= 1.0f) {
            return 1.0f;
        }
        return t;
    }

    public static double clamp01(double t) {
        if (t <= 0.0) {
            return 0.0;
        }
        if (t >= 1.0) {
            return 1.0;
        }
        return t;
    }

    public static float ease(Easing easing, float t) {
        return (float)easing.apply(EasingUtil.clamp01(t));
    }

    public static double ease(Easing easing, double t) {
        return easing.apply(EasingUtil.clamp01(t));
    }

    public static float shortestAngleDeltaDeg(float fromDeg, float toDeg) {
        float delta = class_3532.method_15393((float)(toDeg - fromDeg));
        if (delta > 180.0f) {
            delta -= 360.0f;
        }
        if (delta < -180.0f) {
            delta += 360.0f;
        }
        return delta;
    }

    public static float easeAngleDeg(Easing easing, float startDeg, float endDeg, float t) {
        float eased = EasingUtil.ease(easing, t);
        float delta = EasingUtil.shortestAngleDeltaDeg(startDeg, endDeg);
        return startDeg + delta * eased;
    }

    public static void easeYawPitch(Easing easing, float startYaw, float endYaw, float startPitch, float endPitch, float t, BiConsumer<Float, Float> setter) {
        float yaw = EasingUtil.easeAngleDeg(easing, startYaw, endYaw, t);
        float pitch = EasingUtil.easeAngleDeg(easing, startPitch, endPitch, t);
        setter.accept(Float.valueOf(yaw), Float.valueOf(pitch));
    }

    public static Quaternionf easeQuaternionSlerp(Easing easing, Quaternionf start, Quaternionf end, float t) {
        float k = EasingUtil.ease(easing, t);
        Quaternionf out = new Quaternionf((Quaternionfc)start);
        out.slerp((Quaternionfc)end, k);
        return out;
    }

    public static Vector3f easeVec3(Easing easing, Vector3f a, Vector3f b, float t) {
        float k = EasingUtil.ease(easing, t);
        return new Vector3f(class_3532.method_16439((float)k, (float)a.x, (float)b.x), class_3532.method_16439((float)k, (float)a.y, (float)b.y), class_3532.method_16439((float)k, (float)a.z, (float)b.z));
    }
}

