/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.cinematics.runtime;

import net.kronoz.odyssey.systems.cinematics.runtime.CameraOverrideController;
import net.kronoz.odyssey.systems.cinematics.runtime.Cutscene;
import net.kronoz.odyssey.systems.cinematics.track.CameraPose;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;

public final class CutscenePlayer {
    private final Cutscene cutscene;
    private double t;
    private boolean playing;
    private double speed = 1.0;
    private boolean anchorCaptured = false;
    private class_243 anchorPos = class_243.field_1353;
    private float anchorYaw = 0.0f;
    private float anchorPitch = 0.0f;

    public CutscenePlayer(Cutscene cutscene) {
        this.cutscene = cutscene;
    }

    public void play() {
        this.t = 0.0;
        this.playing = true;
        this.anchorCaptured = false;
    }

    public void stop() {
        this.playing = false;
    }

    public void seek(double timeSec) {
        this.t = Math.max(0.0, timeSec);
    }

    public void setSpeed(double speed) {
        this.speed = Math.max(0.001, speed);
    }

    public double getSpeed() {
        return this.speed;
    }

    private void ensureAnchor() {
        if (this.anchorCaptured) {
            return;
        }
        if (this.cutscene.mode() != Cutscene.CameraMode.ABSOLUTE || !this.cutscene.anchorToStart()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return;
        }
        class_4184 cam = mc.field_1773.method_19418();
        this.anchorPos = cam.method_19326();
        this.anchorYaw = cam.method_19330();
        this.anchorPitch = cam.method_19329();
        this.anchorCaptured = true;
    }

    public void tick(double dtSec) {
        double trackDur;
        if (!this.playing) {
            return;
        }
        this.t += dtSec * this.speed;
        double d = trackDur = this.cutscene.durationSec() > 0.0 ? Math.min(this.cutscene.durationSec(), this.cutscene.camera().duration()) : this.cutscene.camera().duration();
        if (this.t >= trackDur) {
            this.t = trackDur;
            this.playing = false;
        }
        this.ensureAnchor();
        CameraPose pose = this.cutscene.camera().sample(this.t);
        CameraOverrideController ctrl = CameraOverrideController.I;
        ctrl.active = true;
        ctrl.fov = pose.fov();
        ctrl.lockX = pose.lockX();
        ctrl.lockY = pose.lockY();
        ctrl.lockZ = pose.lockZ();
        if (this.cutscene.mode() == Cutscene.CameraMode.ADDITIVE_FOLLOW) {
            ctrl.mode = CameraOverrideController.Mode.ADDITIVE_FOLLOW;
            ctrl.offsetX = pose.position().field_1352;
            ctrl.offsetY = pose.position().field_1351;
            ctrl.offsetZ = pose.position().field_1350;
            ctrl.yawOffset = pose.yaw();
            ctrl.pitchOffset = pose.pitch();
        } else {
            ctrl.mode = CameraOverrideController.Mode.ABSOLUTE;
            class_243 basePos = this.anchorCaptured ? this.anchorPos : class_310.method_1551().field_1773.method_19418().method_19326();
            float baseYaw = this.anchorCaptured ? this.anchorYaw : class_310.method_1551().field_1773.method_19418().method_19330();
            float basePitch = this.anchorCaptured ? this.anchorPitch : class_310.method_1551().field_1773.method_19418().method_19329();
            ctrl.posX = basePos.field_1352 + pose.position().field_1352;
            ctrl.posY = basePos.field_1351 + pose.position().field_1351;
            ctrl.posZ = basePos.field_1350 + pose.position().field_1350;
            ctrl.yaw = baseYaw + pose.yaw();
            ctrl.pitch = basePitch + pose.pitch();
        }
    }

    public boolean isPlaying() {
        return this.playing;
    }
}

