/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.cinematics.track;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.kronoz.odyssey.systems.cinematics.api.Curves;
import net.kronoz.odyssey.systems.cinematics.api.Easing;
import net.kronoz.odyssey.systems.cinematics.track.CameraKeyframe;
import net.kronoz.odyssey.systems.cinematics.track.CameraPose;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;

public final class CameraTrack {
    private final List<CameraKeyframe> keys = new ArrayList<CameraKeyframe>();

    public CameraTrack add(CameraKeyframe k) {
        this.keys.add(k);
        this.keys.sort(Comparator.comparingDouble(CameraKeyframe::timeSec));
        return this;
    }

    public double duration() {
        return this.keys.isEmpty() ? 0.0 : this.keys.getLast().timeSec();
    }

    public CameraPose sample(double t) {
        if (this.keys.isEmpty()) {
            return new CameraPose(class_243.field_1353, 0.0f, 0.0f, 0.0f, 70.0f, false, false, false);
        }
        if (t <= this.keys.getFirst().timeSec()) {
            return this.resolve(this.keys.getFirst());
        }
        if (t >= this.keys.getLast().timeSec()) {
            return this.resolve(this.keys.getLast());
        }
        CameraKeyframe a = null;
        CameraKeyframe b = null;
        for (int i = 0; i < this.keys.size() - 1; ++i) {
            CameraKeyframe k0 = this.keys.get(i);
            CameraKeyframe k1 = this.keys.get(i + 1);
            if (!(t >= k0.timeSec()) || !(t <= k1.timeSec())) continue;
            a = k0;
            b = k1;
            break;
        }
        if (a == null || b == null) {
            return this.resolve(this.keys.getLast());
        }
        double span = b.timeSec() - a.timeSec();
        double lt = (t - a.timeSec()) / (span <= 0.0 ? 1.0 : span);
        double et = (b.easing() != null ? b.easing() : Easing.LINEAR).apply(Math.max(0.0, Math.min(1.0, lt)));
        CameraPose pa = this.resolve(a);
        CameraPose pb = this.resolve(b);
        class_243 p = Curves.lerp(pa.position(), pb.position(), et);
        if (b.pose().lockX()) {
            p = new class_243(pa.position().field_1352, p.field_1351, p.field_1350);
        }
        if (b.pose().lockY()) {
            p = new class_243(p.field_1352, pa.position().field_1351, p.field_1350);
        }
        if (b.pose().lockZ()) {
            p = new class_243(p.field_1352, p.field_1351, pa.position().field_1350);
        }
        float yaw = Curves.lerp(pa.yaw(), pb.yaw(), et);
        float pitch = Curves.lerp(pa.pitch(), pb.pitch(), et);
        float roll = Curves.lerp(pa.roll(), pb.roll(), et);
        float fov = Curves.lerp(pa.fov(), pb.fov(), et);
        return new CameraPose(p, yaw, pitch, roll, fov, b.pose().lockX(), b.pose().lockY(), b.pose().lockZ());
    }

    private CameraPose resolve(CameraKeyframe k) {
        CameraPose base = k.pose();
        if (!k.relativeToPlayer()) {
            return base;
        }
        class_310 mc = class_310.method_1551();
        class_746 p = mc.field_1724;
        if (p == null) {
            return base;
        }
        class_238 box = p.method_5829();
        class_243 dims = new class_243(box.method_17939(), box.method_17940(), box.method_17941());
        double s = Math.max(0.001, k.relFactor());
        class_243 delta = new class_243(base.position().field_1352 * dims.field_1352 * s, base.position().field_1351 * dims.field_1351 * s, base.position().field_1350 * dims.field_1350 * s);
        class_243 pos = p.method_19538().method_1019(delta);
        return new CameraPose(pos, base.yaw(), base.pitch(), base.roll(), base.fov(), base.lockX(), base.lockY(), base.lockZ());
    }
}

