/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.dialogue.server;

import java.util.List;
import java.util.Random;
import net.kronoz.odyssey.cca.DialogueComponent;
import net.kronoz.odyssey.init.ModComponents;
import net.kronoz.odyssey.systems.dialogue.data.DialogueChoice;
import net.kronoz.odyssey.systems.dialogue.data.DialogueLine;
import net.kronoz.odyssey.systems.dialogue.data.DialogueLoader;
import net.kronoz.odyssey.systems.dialogue.data.DialogueNode;
import net.kronoz.odyssey.systems.dialogue.data.DialogueTree;
import net.kronoz.odyssey.systems.dialogue.net.s2c.PlayLineS2C;
import net.kronoz.odyssey.systems.dialogue.net.s2c.ShowChoicesS2C;
import net.kronoz.odyssey.systems.dialogue.server.DialogueScheduler;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public final class DialogueManager {
    private static final Random RNG = new Random();

    public static void start(class_3222 p, class_2960 treeId) {
        DialogueTree t = DialogueLoader.get(treeId);
        if (t == null) {
            return;
        }
        DialogueComponent c = (DialogueComponent)ModComponents.DIALOGUE.get((Object)p);
        c.start(treeId, t.startNode());
        DialogueManager.playNode(p, t, t.startNode());
    }

    public static void selectChoice(class_3222 p, String choiceId) {
        DialogueComponent c = (DialogueComponent)ModComponents.DIALOGUE.get((Object)p);
        if (!c.inConversation()) {
            return;
        }
        DialogueTree t = DialogueLoader.get(c.currentTree());
        if (t == null) {
            c.end();
            return;
        }
        DialogueNode n = t.node(c.currentNode());
        if (n == null) {
            c.end();
            return;
        }
        DialogueChoice chosen = n.choices().stream().filter(ch -> ch.id().equals(choiceId)).findFirst().orElse(null);
        if (chosen == null) {
            return;
        }
        c.setNode(chosen.gotoNode());
        DialogueManager.playNode(p, t, chosen.gotoNode());
    }

    static void playNode(class_3222 p, DialogueTree t, String nodeKey) {
        DialogueNode n = t.node(nodeKey);
        if (n == null) {
            return;
        }
        List<DialogueLine> lines = n.lines();
        if (lines == null || lines.isEmpty()) {
            if (!n.choices().isEmpty()) {
                ShowChoicesS2C.send(p, n.allowMulti(), n.choices());
            } else {
                ((DialogueComponent)ModComponents.DIALOGUE.get((Object)p)).end();
            }
            return;
        }
        boolean hasWeights = lines.stream().anyMatch(l -> l.weight() > 0);
        if (!hasWeights && lines.size() > 1) {
            int acc = 0;
            for (int i = 0; i < lines.size(); ++i) {
                DialogueLine l2 = lines.get(i);
                int dur = Math.max(1, l2.durationMs());
                int delay = acc;
                if (i == 0) {
                    PlayLineS2C.send(p, l2);
                } else {
                    DialogueScheduler.queue(() -> PlayLineS2C.send(p, l2), delay);
                }
                acc += dur;
            }
            DialogueScheduler.queue(() -> {
                if (!n.choices().isEmpty()) {
                    ShowChoicesS2C.send(p, n.allowMulti(), n.choices());
                } else {
                    ((DialogueComponent)ModComponents.DIALOGUE.get((Object)p)).end();
                }
            }, acc);
        } else {
            DialogueLine line = DialogueManager.pickWeighted(lines);
            if (line != null) {
                PlayLineS2C.send(p, line);
                int dur = Math.max(1, line.durationMs());
                DialogueScheduler.queue(() -> DialogueManager.advanceAfterLine(p, t, n), dur);
            } else if (!n.choices().isEmpty()) {
                ShowChoicesS2C.send(p, n.allowMulti(), n.choices());
            } else {
                ((DialogueComponent)ModComponents.DIALOGUE.get((Object)p)).end();
            }
        }
    }

    static void advanceAfterLine(class_3222 p, DialogueTree t, DialogueNode n) {
        if (!n.choices().isEmpty()) {
            ShowChoicesS2C.send(p, n.allowMulti(), n.choices());
        } else {
            ((DialogueComponent)ModComponents.DIALOGUE.get((Object)p)).end();
        }
    }

    private static DialogueLine pickWeighted(List<DialogueLine> lines) {
        if (lines == null || lines.isEmpty()) {
            return null;
        }
        int sum = 0;
        for (DialogueLine l : lines) {
            sum += Math.max(1, l.weight());
        }
        int r = RNG.nextInt(sum) + 1;
        int run = 0;
        for (DialogueLine l : lines) {
            if (r > (run += Math.max(1, l.weight()))) continue;
            return l;
        }
        return lines.get(0);
    }
}

