/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.dialogue.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.server.MinecraftServer;

public final class DialogueScheduler {
    private static final List<Task> TASKS = new ArrayList<Task>();

    public static void init() {
        ServerTickEvents.END_SERVER_TICK.register(DialogueScheduler::tick);
    }

    public static void queue(Runnable r, int ms) {
        TASKS.add(new Task(r, ms));
    }

    private static void tick(MinecraftServer server) {
        Iterator<Task> it = TASKS.iterator();
        while (it.hasNext()) {
            Task tk = it.next();
            if (--tk.ticks > 0) continue;
            tk.run.run();
            it.remove();
        }
    }

    static final class Task {
        final Runnable run;
        int ticks;

        Task(Runnable r, int ms) {
            this.run = r;
            this.ticks = Math.max(1, (ms + 49) / 50);
        }
    }
}

