/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.physics.dust;

import java.util.Random;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class DustField {
    private static final int FULL_BRIGHT = 0xF000F0;
    private static final int OVERLAY = class_4608.field_21444;
    private static final double LIFE_MIN = 20.0;
    private static final double LIFE_MAX = 40.5;
    private static final double SIZE_MIN = 0.01;
    private static final double SIZE_MAX = 0.02;
    private static final class_243 BASE_DIR = new class_243(0.0, -1.0, 0.0);
    private static final double BASE_SPEED = 0.075;
    private static final double SPREAD_MAX = 0.06;
    private static final double SPREAD_GAMMA = 3.0;
    private static final double SPEED_JITTER = 0.4;
    private static final double SPREAD_JITTER = 0.5;
    private static final double ROT_DRAG = 0.995;
    private final Node[] nodes;
    private final Random rng = new Random();
    private final float r;
    private final float g;
    private final float b;
    private final double emitPerSecond;
    private double emitAcc = 0.0;
    private int alive = 0;
    private int nextDead = 0;

    public DustField(int capacity, int r255, int g255, int b255, double emitRatePerSecond) {
        this.r = class_3532.method_15363((float)((float)r255 / 255.0f), (float)0.0f, (float)1.0f);
        this.g = class_3532.method_15363((float)((float)g255 / 255.0f), (float)0.0f, (float)1.0f);
        this.b = class_3532.method_15363((float)((float)b255 / 255.0f), (float)0.0f, (float)1.0f);
        this.emitPerSecond = Math.max(0.0, emitRatePerSecond);
        this.nodes = new Node[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.nodes[i] = Node.dead();
        }
    }

    private void spawn(Node n, class_243 origin) {
        class_243 j = new class_243((this.rng.nextDouble() - 0.5) * 0.35, (this.rng.nextDouble() - 0.5) * 0.35, (this.rng.nextDouble() - 0.5) * 0.35);
        n.p = origin.method_1019(j);
        double ang = this.rng.nextDouble() * Math.PI * 2.0;
        n.radialDirXZ = new class_243(Math.cos(ang), 0.0, Math.sin(ang));
        double downMul = 1.0 + (this.rng.nextDouble() * 2.0 - 1.0) * 0.4;
        double spreadMul = 1.0 + (this.rng.nextDouble() * 2.0 - 1.0) * 0.5;
        n.downSpeed = 0.075 * downMul;
        n.radialMaxSpeed = 0.06 * spreadMul;
        n.life = 20.0 + this.rng.nextDouble() * 20.5;
        n.age = 0.0;
        n.size = 0.01 + this.rng.nextDouble() * 0.01;
        n.yaw = (float)(this.rng.nextDouble() * Math.PI * 2.0);
        n.pitch = (float)((this.rng.nextDouble() - 0.5) * 0.25);
        n.roll = (float)((this.rng.nextDouble() - 0.5) * 0.25);
        n.yawVel = (float)((this.rng.nextDouble() - 0.5) * 0.2);
        n.pitchVel = (float)((this.rng.nextDouble() - 0.5) * 0.2);
        n.rollVel = (float)((this.rng.nextDouble() - 0.5) * 0.2);
        n.alive = true;
    }

    public void update(double dt, class_243 origin, class_1937 world, long worldTime) {
        if (dt <= 0.0) {
            return;
        }
        if (this.alive < this.nodes.length && this.emitPerSecond > 0.0) {
            this.emitAcc += this.emitPerSecond * dt;
            while (this.emitAcc >= 1.0 && this.alive < this.nodes.length) {
                int start = this.nextDead;
                do {
                    Node n = this.nodes[this.nextDead];
                    if (!n.alive) {
                        this.spawn(n, origin);
                        ++this.alive;
                        this.emitAcc -= 1.0;
                        this.nextDead = (this.nextDead + 1) % this.nodes.length;
                        break;
                    }
                    this.nextDead = (this.nextDead + 1) % this.nodes.length;
                } while (this.nextDead != start);
                if (start != this.nextDead) continue;
                break;
            }
        }
        for (Node n : this.nodes) {
            if (!n.alive) continue;
            n.age += dt;
            if (n.age >= n.life) {
                n.alive = false;
                --this.alive;
                continue;
            }
            double t = class_3532.method_15350((double)(n.age / n.life), (double)0.0, (double)1.0);
            double g = t * t * (3.0 - 2.0 * t);
            g = Math.pow(g, 3.0);
            class_243 vDown = BASE_DIR.method_1021(n.downSpeed);
            class_243 vLateral = n.radialDirXZ.method_1021(n.radialMaxSpeed * g);
            class_243 v = vDown.method_1019(vLateral);
            n.p = n.p.method_1019(v.method_1021(dt));
            n.yaw = (float)((double)n.yaw + (double)n.yawVel * dt);
            n.yawVel = (float)((double)n.yawVel * 0.995);
            n.pitch = (float)((double)n.pitch + (double)n.pitchVel * dt);
            n.pitchVel = (float)((double)n.pitchVel * 0.995);
            n.roll = (float)((double)n.roll + (double)n.rollVel * dt);
            n.rollVel = (float)((double)n.rollVel * 0.995);
        }
    }

    public void render(class_4587 ms, class_4588 vc, class_243 cameraBase, float tickDelta, class_1937 world) {
        Matrix4f m4 = ms.method_23760().method_23761();
        for (Node n : this.nodes) {
            if (!n.alive) continue;
            double t = class_3532.method_15350((double)(n.age / n.life), (double)0.0, (double)1.0);
            float fade = (float)(Math.min(1.0, t * 3.0) * Math.pow(1.0 - t, 1.5));
            int lx = world.method_8314(class_1944.field_9282, class_2338.method_49638((class_2374)n.p));
            int ls = world.method_8314(class_1944.field_9284, class_2338.method_49638((class_2374)n.p));
            float lfac = class_3532.method_15363((float)(((float)lx * 0.8f + (float)ls * 0.5f) / 30.0f), (float)0.08f, (float)1.0f);
            float a = class_3532.method_15363((float)(0.06f + 0.22f * fade * lfac), (float)0.0f, (float)0.35f);
            float edge = (float)n.size;
            float hs = edge * 0.5f;
            float cx = (float)(n.p.field_1352 - cameraBase.field_1352);
            float cy = (float)(n.p.field_1351 - cameraBase.field_1351);
            float cz = (float)(n.p.field_1350 - cameraBase.field_1350);
            float cyw = (float)Math.cos(n.yaw);
            float syw = (float)Math.sin(n.yaw);
            float cpi = (float)Math.cos(n.pitch);
            float spi = (float)Math.sin(n.pitch);
            float cro = (float)Math.cos(n.roll);
            float sro = (float)Math.sin(n.roll);
            Vector3f X = new Vector3f(1.0f, 0.0f, 0.0f);
            Vector3f Y = new Vector3f(0.0f, 1.0f, 0.0f);
            Vector3f Z = new Vector3f(0.0f, 0.0f, 1.0f);
            X = new Vector3f(cyw * X.x - syw * X.z, X.y, syw * X.x + cyw * X.z);
            Y = new Vector3f(cyw * Y.x - syw * Y.z, Y.y, syw * Y.x + cyw * Y.z);
            Z = new Vector3f(cyw * Z.x - syw * Z.z, Z.y, syw * Z.x + cyw * Z.z);
            X = new Vector3f(X.x, cpi * X.y - spi * X.z, spi * X.y + cpi * X.z);
            Y = new Vector3f(Y.x, cpi * Y.y - spi * Y.z, spi * Y.y + cpi * Y.z);
            Z = new Vector3f(Z.x, cpi * Z.y - spi * Z.z, spi * Z.y + cpi * Z.z);
            X = new Vector3f(cro * X.x - sro * X.y, sro * X.x + cro * X.y, X.z);
            Y = new Vector3f(cro * Y.x - sro * Y.y, sro * Y.x + cro * Y.y, Y.z);
            Z = new Vector3f(cro * Z.x - sro * Z.y, sro * Z.x + cro * Z.y, Z.z);
            Vector3f RX = new Vector3f((Vector3fc)X).mul(hs);
            Vector3f RY = new Vector3f((Vector3fc)Y).mul(hs);
            Vector3f RZ = new Vector3f((Vector3fc)Z).mul(hs);
            float rr = this.r;
            float gg = this.g;
            float bb = this.b;
            Vector3f C = new Vector3f(cx, cy, cz);
            Vector3f p000 = new Vector3f((Vector3fc)C).sub((Vector3fc)RX).sub((Vector3fc)RY).sub((Vector3fc)RZ);
            Vector3f p100 = new Vector3f((Vector3fc)C).add((Vector3fc)RX).sub((Vector3fc)RY).sub((Vector3fc)RZ);
            Vector3f p110 = new Vector3f((Vector3fc)C).add((Vector3fc)RX).add((Vector3fc)RY).sub((Vector3fc)RZ);
            Vector3f p010 = new Vector3f((Vector3fc)C).sub((Vector3fc)RX).add((Vector3fc)RY).sub((Vector3fc)RZ);
            Vector3f p001 = new Vector3f((Vector3fc)C).sub((Vector3fc)RX).sub((Vector3fc)RY).add((Vector3fc)RZ);
            Vector3f p101 = new Vector3f((Vector3fc)C).add((Vector3fc)RX).sub((Vector3fc)RY).add((Vector3fc)RZ);
            Vector3f p111 = new Vector3f((Vector3fc)C).add((Vector3fc)RX).add((Vector3fc)RY).add((Vector3fc)RZ);
            Vector3f p011 = new Vector3f((Vector3fc)C).sub((Vector3fc)RX).add((Vector3fc)RY).add((Vector3fc)RZ);
            this.putQuad(m4, ms, vc, rr, gg, bb, a, 0.0f, 1.0f, 1.0f, 0.0f, p100, p101, p111, p110, X);
            this.putQuad(m4, ms, vc, rr, gg, bb, a, 0.0f, 1.0f, 1.0f, 0.0f, p000, p010, p011, p001, new Vector3f((Vector3fc)X).negate());
            this.putQuad(m4, ms, vc, rr, gg, bb, a, 0.0f, 1.0f, 1.0f, 0.0f, p010, p110, p111, p011, Y);
            this.putQuad(m4, ms, vc, rr, gg, bb, a, 0.0f, 1.0f, 1.0f, 0.0f, p000, p001, p101, p100, new Vector3f((Vector3fc)Y).negate());
            this.putQuad(m4, ms, vc, rr, gg, bb, a, 0.0f, 1.0f, 1.0f, 0.0f, p101, p001, p011, p111, Z);
            this.putQuad(m4, ms, vc, rr, gg, bb, a, 0.0f, 1.0f, 1.0f, 0.0f, p100, p110, p010, p000, new Vector3f((Vector3fc)Z).negate());
        }
    }

    private void putQuad(Matrix4f m4, class_4587 ms, class_4588 vc, float r, float g, float b, float a, float u0, float v1, float u1, float v0, Vector3f P0, Vector3f P1, Vector3f P2, Vector3f P3, Vector3f N) {
        int nx = (int)Math.signum(N.x());
        int ny = (int)Math.signum(N.y());
        int nz = (int)Math.signum(N.z());
        vc.method_22918(m4, P0.x, P0.y, P0.z).method_22915(r, g, b, a).method_22913(u0, v1).method_22922(OVERLAY).method_60803(0xF000F0).method_60831(ms.method_23760(), (float)nx, (float)ny, (float)nz);
        vc.method_22918(m4, P1.x, P1.y, P1.z).method_22915(r, g, b, a).method_22913(u1, v1).method_22922(OVERLAY).method_60803(0xF000F0).method_60831(ms.method_23760(), (float)nx, (float)ny, (float)nz);
        vc.method_22918(m4, P2.x, P2.y, P2.z).method_22915(r, g, b, a).method_22913(u1, v0).method_22922(OVERLAY).method_60803(0xF000F0).method_60831(ms.method_23760(), (float)nx, (float)ny, (float)nz);
        vc.method_22918(m4, P3.x, P3.y, P3.z).method_22915(r, g, b, a).method_22913(u0, v0).method_22922(OVERLAY).method_60803(0xF000F0).method_60831(ms.method_23760(), (float)nx, (float)ny, (float)nz);
    }

    private static final class Node {
        boolean alive;
        class_243 p;
        class_243 radialDirXZ;
        double downSpeed;
        double radialMaxSpeed;
        float yaw;
        float pitch;
        float roll;
        float yawVel;
        float pitchVel;
        float rollVel;
        double age;
        double life;
        double size;

        private Node() {
        }

        static Node dead() {
            Node n = new Node();
            n.alive = false;
            n.p = class_243.field_1353;
            n.radialDirXZ = class_243.field_1353;
            n.downSpeed = 0.0;
            n.radialMaxSpeed = 0.0;
            n.roll = 0.0f;
            n.pitch = 0.0f;
            n.yaw = 0.0f;
            n.rollVel = 0.0f;
            n.pitchVel = 0.0f;
            n.yawVel = 0.0f;
            n.age = 0.0;
            n.life = 0.0;
            n.size = 0.0;
            return n;
        }
    }
}

