/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.physics.jetpack;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.kronoz.odyssey.systems.physics.jetpack.OdysseySmokeField;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public final class JetpackExhaustManager {
    private static final class_2960 WHITE = class_2960.method_60655((String)"minecraft", (String)"textures/misc/white.png");
    private static final double MAX_FPS = 120.0;
    private static final long MIN_STEP_NS = 8333333L;
    private static final long EMITTER_IDLE_NS = 1000000000L;
    private static final Map<String, Emitter> EMITTERS = new HashMap<String, Emitter>();

    public static void emit(String stableId, class_243 originWS) {
        Emitter e = EMITTERS.computeIfAbsent(stableId, k -> new Emitter());
        e.ping(originWS);
    }

    public static void tick(class_310 mc) {
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        long now = System.nanoTime();
        Iterator<Map.Entry<String, Emitter>> it = EMITTERS.entrySet().iterator();
        while (it.hasNext()) {
            long elapsed;
            Map.Entry<String, Emitter> entry = it.next();
            Emitter e = entry.getValue();
            if (e.lastTickNs == 0L) {
                e.lastTickNs = now;
            }
            if ((elapsed = now - e.lastTickNs) >= 8333333L) {
                double dt = Math.min((double)elapsed / 1.0E9, 0.05);
                if (!e.pingedThisFrame) {
                    e.field.setEmitting(false);
                }
                e.field.update(dt, e.origin, (class_1937)mc.field_1687, mc.field_1687.method_8510());
                e.lastTickNs = now;
                e.pingedThisFrame = false;
            }
            if (now - e.lastPingNs <= 1000000000L || !e.field.isEmpty()) continue;
            it.remove();
        }
    }

    public static void renderAll(class_4587 ms, class_4597 vcp, float tickDelta) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        class_243 cam = mc.field_1773.method_19418().method_19326();
        class_4588 vc = vcp.getBuffer(class_1921.method_23580((class_2960)WHITE));
        for (Emitter e : EMITTERS.values()) {
            ms.method_22903();
            e.field.render(ms, vc, cam, tickDelta);
            ms.method_22909();
        }
    }

    private static final class Emitter {
        final OdysseySmokeField field = new OdysseySmokeField(240, 186, 186, 186);
        class_243 origin = class_243.field_1353;
        long lastTickNs = 0L;
        long lastPingNs = 0L;
        boolean pingedThisFrame = false;

        Emitter() {
            this.field.setEmitting(true);
        }

        void ping(class_243 o) {
            this.origin = o;
            this.pingedThisFrame = true;
            this.lastPingNs = System.nanoTime();
            this.field.setEmitting(true);
        }
    }
}

