/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.physics.jetpack;

import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class OdysseySmokeField {
    private static final double MAX_WORLD_RADIUS = 80.0;
    private static final double DRAG = 0.9;
    private static final double LATERAL_VISC = 0.94;
    private static final double BUOYANCY_BASE = 0.02;
    private static final double BUOYANCY_TEMP = 0.04;
    private static final double GRAVITY_RESIDUAL = 0.004;
    private static final double MIN_UP_SPEED = 0.008;
    private static final double CURL_EPS = 0.22;
    private static final double CURL_FORCE = 0.45;
    private static final double WIND_MAG = 0.01;
    private static final double SAMPLE_STEP = 0.1;
    private static final double WALL_PUSH = 0.65;
    private static final double LIFE_MIN = 2.5;
    private static final double LIFE_MAX = 5.0;
    private static final double SIZE_MIN = 0.02;
    private static final double SIZE_MAX = 0.05;
    private static final double CONE_ANGLE_RAD = Math.toRadians(16.0);
    private static final double AXIS_SPIRAL = 0.55;
    private static final double AXIS_PULL = 0.35;
    private static final double EARLY_SPRING = 16.0;
    private static final double EARLY_SPRING_TIME = 0.12;
    private static final double MAX_SPEED = 0.35;
    private double emitRate = 30.0;
    private double emitAccumulator = 0.0;
    private int aliveCount = 0;
    private int nextDeadIdx = 0;
    private final Node[] nodes;
    private final Random rng = new Random(-7046029254386353131L);
    private float endR = 0.729f;
    private float endG = 0.729f;
    private float endB = 0.729f;
    private float midR = 1.0f;
    private float midG = 0.6f;
    private float midB = 0.0f;
    private float startR = 0.322f;
    private float startG = 0.0f;
    private float startB = 1.0f;
    private class_243 thrustAxis = new class_243(0.0, 1.0, 0.0);
    private boolean emitting = true;

    public OdysseySmokeField(int capacity) {
        this.nodes = new Node[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.nodes[i] = Node.dead();
        }
    }

    public OdysseySmokeField(int capacity, int r, int g, int b) {
        this(capacity);
        this.endR = class_3532.method_15363((float)((float)r / 255.0f), (float)0.0f, (float)1.0f);
        this.endG = class_3532.method_15363((float)((float)g / 255.0f), (float)0.0f, (float)1.0f);
        this.endB = class_3532.method_15363((float)((float)b / 255.0f), (float)0.0f, (float)1.0f);
    }

    public int aliveCount() {
        return this.aliveCount;
    }

    public OdysseySmokeField setEmitting(boolean e) {
        this.emitting = e;
        return this;
    }

    public OdysseySmokeField setAxis(class_243 axisWS) {
        if (axisWS != null && axisWS.method_1027() > 1.0E-9) {
            this.thrustAxis = axisWS.method_1029();
        }
        return this;
    }

    public OdysseySmokeField setJetAxis(class_243 axisWS) {
        return this.setAxis(axisWS);
    }

    public double getAxisSpiral() {
        return 0.55;
    }

    public double getAxisPull() {
        return 0.35;
    }

    public boolean isEmpty() {
        return this.aliveCount == 0;
    }

    public void update(double dt, class_243 originWS, class_1937 world, long worldTime) {
        if (dt <= 0.0) {
            return;
        }
        if (this.emitting && this.aliveCount < this.nodes.length) {
            this.emitAccumulator += this.emitRate * dt;
            while (this.emitAccumulator >= 1.0 && this.aliveCount < this.nodes.length) {
                int start = this.nextDeadIdx;
                do {
                    Node n = this.nodes[this.nextDeadIdx];
                    if (!n.alive) {
                        this.spawnInto(n, originWS);
                        ++this.aliveCount;
                        this.emitAccumulator -= 1.0;
                        this.nextDeadIdx = (this.nextDeadIdx + 1) % this.nodes.length;
                        break;
                    }
                    this.nextDeadIdx = (this.nextDeadIdx + 1) % this.nodes.length;
                } while (this.nextDeadIdx != start);
                if (start != this.nextDeadIdx) continue;
                break;
            }
        }
        this.stepAll(dt, originWS, world, worldTime);
    }

    private void spawnInto(Node n, class_243 origin) {
        class_243 dir = this.sampleConeDir(this.thrustAxis, CONE_ANGLE_RAD);
        n.p = origin;
        n.v = dir.method_1021(0.18 + this.rng.nextDouble() * 0.08).method_1019(this.jitter3(0.01));
        n.life = 2.5 + this.rng.nextDouble() * 2.5;
        n.baseSize = 0.02 + this.rng.nextDouble() * 0.030000000000000002;
        n.temp = 1.0;
        n.age = 0.0;
        n.yaw = (float)(this.rng.nextDouble() * Math.PI * 2.0);
        n.pitch = (float)((this.rng.nextDouble() - 0.5) * Math.toRadians(40.0));
        n.roll = (float)((this.rng.nextDouble() - 0.5) * Math.toRadians(40.0));
        n.yawVel = (float)((this.rng.nextDouble() - 0.5) * 1.5);
        n.pitchVel = (float)((this.rng.nextDouble() - 0.5) * 1.2);
        n.rollVel = (float)((this.rng.nextDouble() - 0.5) * 1.2);
        n.alive = true;
    }

    private void stepAll(double dt, class_243 origin, class_1937 world, long worldTime) {
        for (int i = 0; i < this.nodes.length; ++i) {
            class_243 next;
            class_243 after;
            Node n = this.nodes[i];
            if (!n.alive) continue;
            n.age += dt;
            if (n.age >= n.life || n.p.method_1025(origin) > 6400.0) {
                n.alive = false;
                --this.aliveCount;
                continue;
            }
            if (this.isInsideSolid(n.p, world)) {
                n.alive = false;
                --this.aliveCount;
                continue;
            }
            double t = (double)worldTime * 0.05 + (double)i * 7.31;
            class_243 curl = this.curl3(n.p.field_1352 * 0.55 + t * 0.08, n.p.field_1351 * 0.5 + t * 0.08, n.p.field_1350 * 0.55 + t * 0.08);
            class_243 wind = this.windAt(n.p, worldTime, 0.01);
            double buoy = 0.02 + Math.max(0.0, n.temp) * 0.04;
            class_243 a = new class_243(curl.field_1352 * 0.45 + wind.field_1352, curl.field_1351 * 0.45 + buoy - 0.004 + wind.field_1351 * 0.25, curl.field_1350 * 0.45 + wind.field_1350);
            a = a.method_1019(this.axisField(n, origin, dt));
            n.v = n.v.method_1019(a.method_1021(dt));
            double spd = n.v.method_1033();
            if (spd > 0.35) {
                n.v = n.v.method_1021(0.35 / Math.max(spd, 1.0E-6));
            }
            n.v = new class_243(n.v.field_1352 * 0.94, n.v.field_1351 * 0.9, n.v.field_1350 * 0.94);
            if (n.v.field_1351 < 0.008) {
                n.v = new class_243(n.v.field_1352, 0.008, n.v.field_1350);
            }
            if (this.isInsideSolid(after = this.collideWorld(n.p, next = n.p.method_1019(n.v.method_1021(dt)), world), world)) {
                n.alive = false;
                --this.aliveCount;
                continue;
            }
            n.p = after;
            n.temp *= 0.996;
            n.yaw = (float)((double)n.yaw + (double)n.yawVel * dt);
            n.pitch = (float)((double)n.pitch + (double)n.pitchVel * dt);
            n.roll = (float)((double)n.roll + (double)n.rollVel * dt);
        }
    }

    private class_243 axisField(Node n, class_243 origin, double dt) {
        class_243 a = this.thrustAxis;
        class_243 rel = n.p.method_1020(origin);
        double along = rel.method_1026(a);
        class_243 proj = a.method_1021(along);
        class_243 radial = rel.method_1020(proj);
        double k = class_3532.method_15350((double)radial.method_1033(), (double)0.0, (double)1.0);
        class_243 pull = radial.method_1027() > 1.0E-9 ? radial.method_1029().method_1021(-0.35 * k) : class_243.field_1353;
        class_243 basisU = Math.abs(a.field_1352) < 0.9 ? new class_243(1.0, 0.0, 0.0) : new class_243(0.0, 1.0, 0.0);
        class_243 u = a.method_1036(basisU).method_1029();
        class_243 v = a.method_1036(u).method_1029();
        double spin = 0.55 * (0.5 + 0.5 * Math.sin(along * 10.0));
        class_243 swirl = u.method_1021(-spin).method_1019(v.method_1021(spin));
        if (n.age < 0.12) {
            double w = 1.0 - n.age / 0.12;
            class_243 kick = a.method_1021(16.0 * w);
            return pull.method_1019(swirl).method_1019(kick);
        }
        return pull.method_1019(swirl);
    }

    private boolean isInsideSolid(class_243 p, class_1937 world) {
        class_2338 bp = class_2338.method_49638((class_2374)p);
        class_2680 st = world.method_8320(bp);
        if (st.method_26215()) {
            return false;
        }
        class_265 sh = st.method_26220((class_1922)world, bp);
        if (sh.method_1110()) {
            return false;
        }
        class_238 aabb = sh.method_1107();
        double lx = p.field_1352 - (double)bp.method_10263();
        double ly = p.field_1351 - (double)bp.method_10264();
        double lz = p.field_1350 - (double)bp.method_10260();
        return aabb != null && aabb.method_1008(lx, ly, lz);
    }

    private class_243 collideWorld(class_243 cur, class_243 next, class_1937 world) {
        class_243 delta = next.method_1020(cur);
        int steps = Math.max(1, (int)Math.ceil(delta.method_1033() / 0.1));
        class_243 p = cur;
        for (int i = 1; i <= steps; ++i) {
            class_265 sh;
            double t = (double)i / (double)steps;
            class_243 probe = cur.method_35590(next, t);
            class_2338 bp = class_2338.method_49638((class_2374)probe);
            class_2680 st = world.method_8320(bp);
            if (!st.method_26215() && !(sh = st.method_26220((class_1922)world, bp)).method_1110()) {
                class_243 back = cur.method_35590(next, Math.max(0.0, t - 0.1));
                class_2350 face = OdysseySmokeField.nearestFace(probe, bp);
                class_243 nrm = new class_243((double)face.method_23955().x(), (double)face.method_23955().y(), (double)face.method_23955().z());
                class_243 slide = OdysseySmokeField.projectOntoPlane(next.method_1020(back), nrm).method_1021(0.72);
                p = back.method_1019(slide).method_1019(nrm.method_1021(0.0078000000000000005));
                return p;
            }
            p = probe;
        }
        return p;
    }

    private static class_243 projectOntoPlane(class_243 v, class_243 n) {
        double dot = v.field_1352 * n.field_1352 + v.field_1351 * n.field_1351 + v.field_1350 * n.field_1350;
        return new class_243(v.field_1352 - dot * n.field_1352, v.field_1351 - dot * n.field_1351, v.field_1350 - dot * n.field_1350);
    }

    private static class_2350 nearestFace(class_243 p, class_2338 bp) {
        double cx = (double)bp.method_10263() + 0.5;
        double cy = (double)bp.method_10264() + 0.5;
        double cz = (double)bp.method_10260() + 0.5;
        double dx = p.field_1352 - cx;
        double dy = p.field_1351 - cy;
        double dz = p.field_1350 - cz;
        double ax = Math.abs(dx);
        double ay = Math.abs(dy);
        double az = Math.abs(dz);
        if (ay >= ax && ay >= az) {
            return dy > 0.0 ? class_2350.field_11036 : class_2350.field_11033;
        }
        if (ax >= az) {
            return dx > 0.0 ? class_2350.field_11034 : class_2350.field_11039;
        }
        return dz > 0.0 ? class_2350.field_11035 : class_2350.field_11043;
    }

    private class_243 windAt(class_243 p, long time, double mag) {
        double tt = (double)time * 0.02;
        double nx = this.fbm(p.field_1352 * 0.08 + tt * 0.05, p.field_1351 * 0.05, p.field_1350 * 0.08) - 0.5;
        double nz = this.fbm(p.field_1352 * 0.08, p.field_1351 * 0.05 + tt * 0.05, p.field_1350 * 0.08) - 0.5;
        return new class_243(nx * mag, 0.0, nz * mag);
    }

    private double fbm(double x, double y, double z) {
        double s = 0.0;
        double a = 0.5;
        for (int i = 0; i < 3; ++i) {
            s += this.noise3(x, y, z) * a;
            x *= 2.0;
            y *= 2.0;
            z *= 2.0;
            a *= 0.5;
        }
        return s;
    }

    private class_243 curl3(double x, double y, double z) {
        double ex = 0.22;
        double ey = 0.22;
        double ez = 0.22;
        double Ny_z1 = this.noise3(x, y, z + ez);
        double Ny_z0 = this.noise3(x, y, z - ez);
        double Nz_y1 = this.noise3(x, y + ey, z);
        double Nz_y0 = this.noise3(x, y - ey, z);
        double Nz_x1 = this.noise3(x + ex, y, z);
        double Nz_x0 = this.noise3(x - ex, y, z);
        double Nx_z1 = this.noise3(x, y, z + ez);
        double Nx_z0 = this.noise3(x, y, z - ez);
        double Nx_y1 = this.noise3(x, y + ey, z);
        double Nx_y0 = this.noise3(x, y - ey, z);
        double Ny_x1 = this.noise3(x + ex, y, z);
        double Ny_x0 = this.noise3(x - ex, y, z);
        double cx = Nz_y1 - Nz_y0 - (Ny_z1 - Ny_z0);
        double cy = Nx_z1 - Nx_z0 - (Nz_x1 - Nz_x0);
        double cz = Ny_x1 - Ny_x0 - (Nx_y1 - Nx_y0);
        double len = Math.sqrt(cx * cx + cy * cy + cz * cz) + 1.0E-8;
        return new class_243(cx / len, cy / len, cz / len);
    }

    private double noise3(double x, double y, double z) {
        int xi = OdysseySmokeField.fastFloor(x);
        int yi = OdysseySmokeField.fastFloor(y);
        int zi = OdysseySmokeField.fastFloor(z);
        double xf = x - (double)xi;
        double yf = y - (double)yi;
        double zf = z - (double)zi;
        double u = OdysseySmokeField.smooth(xf);
        double v = OdysseySmokeField.smooth(yf);
        double w = OdysseySmokeField.smooth(zf);
        double n000 = OdysseySmokeField.hash(xi, yi, zi);
        double n100 = OdysseySmokeField.hash(xi + 1, yi, zi);
        double n010 = OdysseySmokeField.hash(xi, yi + 1, zi);
        double n110 = OdysseySmokeField.hash(xi + 1, yi + 1, zi);
        double n001 = OdysseySmokeField.hash(xi, yi, zi + 1);
        double n101 = OdysseySmokeField.hash(xi + 1, yi, zi + 1);
        double n011 = OdysseySmokeField.hash(xi, yi + 1, zi + 1);
        double n111 = OdysseySmokeField.hash(xi + 1, yi + 1, zi + 1);
        double x00 = OdysseySmokeField.lerp(u, n000, n100);
        double x10 = OdysseySmokeField.lerp(u, n010, n110);
        double x01 = OdysseySmokeField.lerp(u, n001, n101);
        double x11 = OdysseySmokeField.lerp(u, n011, n111);
        double y0 = OdysseySmokeField.lerp(v, x00, x10);
        double y1 = OdysseySmokeField.lerp(v, x01, x11);
        return OdysseySmokeField.lerp(w, y0, y1) * 2.0 - 1.0;
    }

    private static int fastFloor(double x) {
        int i = (int)x;
        return x < (double)i ? i - 1 : i;
    }

    private static double smooth(double t) {
        return t * t * (3.0 - 2.0 * t);
    }

    private static double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    private static double hash(int x, int y, int z) {
        long h = (long)x * 374761393L + (long)y * 668265263L + (long)z * 700001L;
        h = (h ^ h >> 13) * 1274126177L;
        h ^= h >> 16;
        return (double)(h & 0xFFFFFFFFL) / 4.294967296E9;
    }

    private class_243 sampleConeDir(class_243 axis, double angRad) {
        class_243 a = axis.method_1029();
        class_243 tmp = Math.abs(a.field_1352) < 0.9 ? new class_243(1.0, 0.0, 0.0) : new class_243(0.0, 1.0, 0.0);
        class_243 u = a.method_1036(tmp).method_1029();
        class_243 v = a.method_1036(u).method_1029();
        double u1 = this.rng.nextDouble();
        double u2 = this.rng.nextDouble();
        double theta = Math.PI * 2 * u1;
        double cosAng = Math.cos(angRad);
        double z = cosAng + (1.0 - cosAng) * u2;
        double s = Math.sqrt(Math.max(0.0, 1.0 - z * z));
        double x = s * Math.cos(theta);
        double y = s * Math.sin(theta);
        return u.method_1021(x).method_1019(v.method_1021(y)).method_1019(a.method_1021(z)).method_1029();
    }

    private class_243 jitter3(double s) {
        return new class_243((Math.random() * 2.0 - 1.0) * s, (Math.random() * 2.0 - 1.0) * s, (Math.random() * 2.0 - 1.0) * s);
    }

    public void render(class_4587 ms, class_4588 vc, class_243 cameraBase, float tickDelta) {
        Matrix4f m4 = ms.method_23760().method_23761();
        int FULL_BRIGHT = 0xF000F0;
        int OVERLAY = class_4608.field_21444;
        for (Node n : this.nodes) {
            float cB;
            float cG;
            float cR;
            if (!n.alive) continue;
            double lifeT = n.age / n.life;
            if (lifeT < 0.45) {
                t = lifeT / 0.45;
                cR = (float)OdysseySmokeField.lerp(t, this.midR, this.startR);
                cG = (float)OdysseySmokeField.lerp(t, this.midG, this.startG);
                cB = (float)OdysseySmokeField.lerp(t, this.midB, this.startB);
            } else {
                t = (lifeT - 0.45) / 0.55;
                cR = (float)OdysseySmokeField.lerp(t, this.startR, this.endR);
                cG = (float)OdysseySmokeField.lerp(t, this.startG, this.endG);
                cB = (float)OdysseySmokeField.lerp(t, this.startB, this.endB);
            }
            float rise = (float)class_3532.method_15350((double)(lifeT * 1.2), (double)0.0, (double)1.0);
            float fall = (float)Math.pow(1.0 - class_3532.method_15350((double)lifeT, (double)0.0, (double)1.0), 1.15);
            float alpha = class_3532.method_15363((float)(0.08f + 0.85f * rise * fall), (float)0.0f, (float)0.9f);
            float edge = (float)(n.baseSize * (0.9 + lifeT * 2.0));
            float hs = edge * 0.5f;
            float cx = (float)(n.p.field_1352 - cameraBase.field_1352);
            float cy = (float)(n.p.field_1351 - cameraBase.field_1351);
            float cz = (float)(n.p.field_1350 - cameraBase.field_1350);
            float cyw = (float)Math.cos(n.yaw);
            float syw = (float)Math.sin(n.yaw);
            float cpi = (float)Math.cos(n.pitch);
            float spi = (float)Math.sin(n.pitch);
            float cro = (float)Math.cos(n.roll);
            float sro = (float)Math.sin(n.roll);
            Vector3f X = new Vector3f(1.0f, 0.0f, 0.0f);
            Vector3f Y = new Vector3f(0.0f, 1.0f, 0.0f);
            Vector3f Z = new Vector3f(0.0f, 0.0f, 1.0f);
            X = new Vector3f(cyw * X.x + 0.0f * X.y + -syw * X.z, X.y, syw * X.x + 0.0f * X.y + cyw * X.z);
            Y = new Vector3f(cyw * Y.x + 0.0f * Y.y + -syw * Y.z, Y.y, syw * Y.x + 0.0f * Y.y + cyw * Y.z);
            Z = new Vector3f(cyw * Z.x + 0.0f * Z.y + -syw * Z.z, Z.y, syw * Z.x + 0.0f * Z.y + cyw * Z.z);
            X = new Vector3f(X.x, cpi * X.y - spi * X.z, spi * X.y + cpi * X.z);
            Y = new Vector3f(Y.x, cpi * Y.y - spi * Y.z, spi * Y.y + cpi * Y.z);
            Z = new Vector3f(Z.x, cpi * Z.y - spi * Z.z, spi * Z.y + cpi * Z.z);
            X = new Vector3f(cro * X.x - sro * X.y, sro * X.x + cro * X.y, X.z);
            Y = new Vector3f(cro * Y.x - sro * Y.y, sro * Y.x + cro * Y.y, Y.z);
            Z = new Vector3f(cro * Z.x - sro * Z.y, sro * Z.x + cro * Z.y, Z.z);
            Vector3f RX = new Vector3f((Vector3fc)X).mul(hs);
            Vector3f RY = new Vector3f((Vector3fc)Y).mul(hs);
            Vector3f RZ = new Vector3f((Vector3fc)Z).mul(hs);
            Vector3f C = new Vector3f(cx, cy, cz);
            Vector3f p000 = new Vector3f((Vector3fc)C).sub((Vector3fc)RX).sub((Vector3fc)RY).sub((Vector3fc)RZ);
            Vector3f p100 = new Vector3f((Vector3fc)C).add((Vector3fc)RX).sub((Vector3fc)RY).sub((Vector3fc)RZ);
            Vector3f p110 = new Vector3f((Vector3fc)C).add((Vector3fc)RX).add((Vector3fc)RY).sub((Vector3fc)RZ);
            Vector3f p010 = new Vector3f((Vector3fc)C).sub((Vector3fc)RX).add((Vector3fc)RY).sub((Vector3fc)RZ);
            Vector3f p001 = new Vector3f((Vector3fc)C).sub((Vector3fc)RX).sub((Vector3fc)RY).add((Vector3fc)RZ);
            Vector3f p101 = new Vector3f((Vector3fc)C).add((Vector3fc)RX).sub((Vector3fc)RY).add((Vector3fc)RZ);
            Vector3f p111 = new Vector3f((Vector3fc)C).add((Vector3fc)RX).add((Vector3fc)RY).add((Vector3fc)RZ);
            Vector3f p011 = new Vector3f((Vector3fc)C).sub((Vector3fc)RX).add((Vector3fc)RY).add((Vector3fc)RZ);
            this.putQuad(m4, ms, vc, cR, cG, cB, alpha, 0.0f, 1.0f, 1.0f, 0.0f, p100, p101, p111, p110, X);
            this.putQuad(m4, ms, vc, cR, cG, cB, alpha, 0.0f, 1.0f, 1.0f, 0.0f, p000, p010, p011, p001, new Vector3f((Vector3fc)X).negate());
            this.putQuad(m4, ms, vc, cR, cG, cB, alpha, 0.0f, 1.0f, 1.0f, 0.0f, p010, p110, p111, p011, Y);
            this.putQuad(m4, ms, vc, cR, cG, cB, alpha, 0.0f, 1.0f, 1.0f, 0.0f, p000, p001, p101, p100, new Vector3f((Vector3fc)Y).negate());
            this.putQuad(m4, ms, vc, cR, cG, cB, alpha, 0.0f, 1.0f, 1.0f, 0.0f, p101, p001, p011, p111, Z);
            this.putQuad(m4, ms, vc, cR, cG, cB, alpha, 0.0f, 1.0f, 1.0f, 0.0f, p100, p110, p010, p000, new Vector3f((Vector3fc)Z).negate());
        }
    }

    private void putQuad(Matrix4f m4, class_4587 ms, class_4588 vc, float r, float g, float b, float a, float u0, float v1, float u1, float v0, Vector3f P0, Vector3f P1, Vector3f P2, Vector3f P3, Vector3f N) {
        int packedLight = 0xF000F0;
        int packedOverlay = class_4608.field_21444;
        int nx = (int)Math.signum(N.x());
        int ny = (int)Math.signum(N.y());
        int nz = (int)Math.signum(N.z());
        vc.method_22918(m4, P0.x, P0.y, P0.z).method_22915(r, g, b, a).method_22913(u0, v1).method_22922(packedOverlay).method_60803(0xF000F0).method_60831(ms.method_23760(), (float)nx, (float)ny, (float)nz);
        vc.method_22918(m4, P1.x, P1.y, P1.z).method_22915(r, g, b, a).method_22913(u1, v1).method_22922(packedOverlay).method_60803(0xF000F0).method_60831(ms.method_23760(), (float)nx, (float)ny, (float)nz);
        vc.method_22918(m4, P2.x, P2.y, P2.z).method_22915(r, g, b, a).method_22913(u1, v0).method_22922(packedOverlay).method_60803(0xF000F0).method_60831(ms.method_23760(), (float)nx, (float)ny, (float)nz);
        vc.method_22918(m4, P3.x, P3.y, P3.z).method_22915(r, g, b, a).method_22913(u0, v0).method_22922(packedOverlay).method_60803(0xF000F0).method_60831(ms.method_23760(), (float)nx, (float)ny, (float)nz);
    }

    private static final class Node {
        boolean alive;
        class_243 p;
        class_243 v;
        double temp;
        double age;
        double life;
        double baseSize;
        float yaw;
        float pitch;
        float roll;
        float yawVel;
        float pitchVel;
        float rollVel;

        private Node() {
        }

        static Node dead() {
            Node n = new Node();
            n.alive = false;
            n.p = class_243.field_1353;
            n.v = class_243.field_1353;
            n.temp = 0.0;
            n.age = 0.0;
            n.life = 0.0;
            n.baseSize = 0.0;
            return n;
        }
    }
}

