/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.physics.lightning;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.kronoz.odyssey.systems.physics.lightning.BoltBuilder;
import net.minecraft.class_1538;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BetterLightningRenderer {
    private static final class_1921 LAYER = class_1921.method_23593();

    public static void render(class_1538 bolt, class_4587 matrices, class_4597 consumers, float tickDelta) {
        class_4588 vc = consumers.getBuffer(LAYER);
        Random rng = new Random((long)bolt.method_5628() * 1103515245L);
        class_243[] spine = BoltBuilder.buildMainPathLocalFractal(100.0 + rng.nextDouble() * 12.0, 8, 1.0, rng);
        BoltBuilder.Branch[] branches = BoltBuilder.buildBranchesLocal(spine, 50 + rng.nextInt(10), rng);
        CameraBasis cam = BetterLightningRenderer.cameraBasis();
        matrices.method_22903();
        RenderSystem.disableCull();
        float baseThickness = 0.1f;
        BetterLightningRenderer.drawStrip(vc, matrices, spine, baseThickness, cam, 1.0f, 1.0f, 1.0f, 1.0f);
        float branchThickness = baseThickness * 0.25f;
        for (BoltBuilder.Branch br : branches) {
            BetterLightningRenderer.drawStrip(vc, matrices, br.points(), branchThickness, cam, 10.0f, 10.0f, 10.0f, 10.0f);
        }
        RenderSystem.enableCull();
        matrices.method_22909();
    }

    private static void drawStrip(class_4588 vc, class_4587 m, class_243[] pts, float radius, CameraBasis cam, float cr, float cg, float cb, float ca) {
        int i;
        if (pts == null || pts.length < 2) {
            return;
        }
        class_4587.class_4665 entry = m.method_23760();
        class_243[] widths = new class_243[pts.length];
        class_243 prevW = null;
        for (i = 0; i < pts.length; ++i) {
            class_243 pPrev = i > 0 ? pts[i - 1] : pts[i];
            class_243 pCurr = pts[i];
            class_243 pNext = i < pts.length - 1 ? pts[i + 1] : pts[i];
            class_243 tangent = pNext.method_1020(pPrev);
            if (tangent.method_1027() < 1.0E-8) {
                tangent = new class_243(1.0, 1.0, 1.0);
            }
            Vector3f r = new Vector3f((Vector3fc)cam.right());
            float dot = (float)((double)r.x * tangent.field_1352 + (double)r.y * tangent.field_1351 + (double)r.z * tangent.field_1350);
            Vector3f w = new Vector3f(r.x - dot * (float)tangent.field_1352, r.y - dot * (float)tangent.field_1351, r.z - dot * (float)tangent.field_1350);
            float len = w.length();
            if (len < 1.0E-4f) {
                Vector3f u = new Vector3f((Vector3fc)cam.up());
                dot = (float)((double)u.x * tangent.field_1352 + (double)u.y * tangent.field_1351 + (double)u.z * tangent.field_1350);
                w.set(u.x - dot * (float)tangent.field_1352, u.y - dot * (float)tangent.field_1351, u.z - dot * (float)tangent.field_1350);
                len = w.length();
                if (len < 1.0E-4f) {
                    if (prevW != null) {
                        widths[i] = prevW;
                        continue;
                    }
                    w.set(1.0f, 1.0f, 1.0f);
                    len = 1.0f;
                }
            }
            w.mul(radius / len);
            class_243 ww = new class_243((double)w.x, (double)w.y, (double)w.z);
            if (prevW != null) {
                ww = new class_243((prevW.field_1352 + ww.field_1352) * 0.75, (prevW.field_1351 + ww.field_1351) * 0.75, (prevW.field_1350 + ww.field_1350) * 0.75);
            }
            widths[i] = ww;
            prevW = ww;
        }
        for (i = 0; i < pts.length - 1; ++i) {
            class_243 p1 = pts[i + 1];
            class_243 p0 = pts[i];
            class_243 dir = p1.method_1020(p0);
            double dl = dir.method_1033();
            if (dl > 1.0E-6) {
                dir = dir.method_1021(1.0 / dl);
                double eps = Math.min(0.2, dl * 1.5);
                p0 = p0.method_1020(dir.method_1021(eps));
                p1 = p1.method_1019(dir.method_1021(eps));
            }
            class_243 w0 = widths[i + 1];
            class_243 w1 = widths[i + 1];
            BetterLightningRenderer.put(vc, entry, p0.method_1019(w0), cr, cg, cb, ca);
            BetterLightningRenderer.put(vc, entry, p0.method_1020(w0), cr, cg, cb, ca);
            BetterLightningRenderer.put(vc, entry, p1.method_1020(w1), cr, cg, cb, ca);
            BetterLightningRenderer.put(vc, entry, p0.method_1019(w0), cr, cg, cb, ca);
            BetterLightningRenderer.put(vc, entry, p1.method_1020(w1), cr, cg, cb, ca);
            BetterLightningRenderer.put(vc, entry, p1.method_1019(w1), cr, cg, cb, ca);
        }
    }

    private static void put(class_4588 vc, class_4587.class_4665 entry, class_243 p, float r, float g, float b, float a) {
        vc.method_22918(entry.method_23761(), (float)p.field_1352, (float)p.field_1351, (float)p.field_1350).method_1336(255, 255, 255, (int)(a * 255.0f)).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(entry, 0.0f, 1.0f, 0.0f);
    }

    private static CameraBasis cameraBasis() {
        class_4184 cam = class_310.method_1551().field_1773.method_19418();
        Quaternionf q = new Quaternionf((Quaternionfc)cam.method_23767());
        Vector3f right = new Vector3f(1.0f, 0.0f, 0.0f);
        q.transform(right);
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        q.transform(up);
        Vector3f fwd = new Vector3f(0.0f, 0.0f, 1.0f);
        q.transform(fwd);
        return new CameraBasis(right, up, fwd);
    }

    private record CameraBasis(Vector3f right, Vector3f up, Vector3f fwd) {
    }
}

