/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.physics.wire;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public final class WireBridge {
    private static final String BASE = "net.kronoz.odyssey.systems.physics.wire";
    private static Class<?> clsWireDef;
    private static Class<?> clsWireToolState;
    private static Class<?> clsWireWorldRenderer;
    private static MethodHandle mhWireDefCtor;
    private static MethodHandle mhEnsureV4;
    private static MethodHandle mhEnsureV6;
    private static MethodHandle mhEnsureVMany;
    private static MethodHandle mhStepV8;
    private static MethodHandle mhStepVMany;
    private static MethodHandle mhInitRenderer;

    public static void initRenderer() {
        try {
            Method m;
            if (clsWireWorldRenderer == null) {
                clsWireWorldRenderer = Class.forName("net.kronoz.odyssey.systems.physics.wire.WireWorldRenderer");
            }
            if (mhInitRenderer == null && (m = WireBridge.findStatic(clsWireWorldRenderer, "init", new Class[0])) != null) {
                mhInitRenderer = MethodHandles.lookup().unreflect(m);
            }
            if (mhInitRenderer != null) {
                mhInitRenderer.invoke();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean ensureAndStep(UUID id, Def def, class_243 a, class_243 b, class_4587 matrices, class_4597 buffers) {
        try {
            Object[] args;
            Object m;
            WireBridge.lazyLoad();
            Object wireDef = WireBridge.newWireDef(def);
            boolean ensured = false;
            if (mhEnsureV4 == null && (m = WireBridge.findStatic(clsWireToolState, "ensure", UUID.class, clsWireDef, class_243.class, class_243.class)) != null) {
                mhEnsureV4 = MethodHandles.lookup().unreflect((Method)m);
            }
            if (mhEnsureV4 != null) {
                mhEnsureV4.invoke(id, wireDef, a, b);
                ensured = true;
            } else {
                if (mhEnsureV6 == null && (m = WireBridge.findStatic(clsWireToolState, "ensure", UUID.class, clsWireDef, class_243.class, Boolean.TYPE, class_243.class, Boolean.TYPE)) != null) {
                    mhEnsureV6 = MethodHandles.lookup().unreflect((Method)m);
                }
                if (mhEnsureV6 != null) {
                    mhEnsureV6.invoke(id, wireDef, a, false, b, true);
                    ensured = true;
                } else {
                    if (mhEnsureVMany == null) {
                        m = clsWireToolState.getDeclaredMethods();
                        int n = ((Method[])m).length;
                        for (int i = 0; i < n; ++i) {
                            Method m2 = m[i];
                            if (!WireBridge.isStatic(m2) || !m2.getName().equals("ensure")) continue;
                            mhEnsureVMany = MethodHandles.lookup().unreflect(m2);
                            break;
                        }
                    }
                    if (mhEnsureVMany != null && (args = WireBridge.synthesizeEnsureArgs(mhEnsureVMany.type().parameterArray(), id, wireDef, a, b)) != null) {
                        mhEnsureVMany.invokeWithArguments(args);
                        ensured = true;
                    }
                }
            }
            if (!ensured) {
                return false;
            }
            if (mhStepV8 == null && (m = WireBridge.findStatic(clsWireToolState, "stepAndRender", UUID.class, class_243.class, Boolean.TYPE, class_243.class, Boolean.TYPE, class_4587.class, class_4597.class, Integer.TYPE)) != null) {
                mhStepV8 = MethodHandles.lookup().unreflect((Method)m);
            }
            if (mhStepV8 != null) {
                int light = 0xF000F0;
                mhStepV8.invoke(id, a, false, b, true, matrices, buffers, light);
                return true;
            }
            if (mhStepVMany == null) {
                for (Method m2 : clsWireToolState.getDeclaredMethods()) {
                    if (!WireBridge.isStatic(m2) || !m2.getName().equals("stepAndRender")) continue;
                    mhStepVMany = MethodHandles.lookup().unreflect(m2);
                    break;
                }
            }
            if (mhStepVMany != null && (args = WireBridge.synthesizeStepArgs(mhStepVMany.type().parameterArray(), id, a, false, b, true, matrices, buffers)) != null) {
                mhStepVMany.invokeWithArguments(args);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static void lazyLoad() throws ClassNotFoundException, IllegalAccessException, NoSuchMethodException {
        if (clsWireToolState == null) {
            clsWireToolState = Class.forName("net.kronoz.odyssey.systems.physics.wire.WireToolState");
        }
        if (clsWireDef == null) {
            clsWireDef = Class.forName("net.kronoz.odyssey.systems.physics.wire.WireDef");
        }
        if (mhWireDefCtor == null) {
            try {
                mhWireDefCtor = MethodHandles.lookup().unreflectConstructor(clsWireDef.getDeclaredConstructor(Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE));
            }
            catch (NoSuchMethodException e) {
                mhWireDefCtor = null;
            }
        }
    }

    private static Object newWireDef(Def def) throws Throwable {
        if (mhWireDefCtor != null) {
            return mhWireDefCtor.invoke(def.segments(), def.thickness(), def.stiffness(), def.damping(), def.gravity(), def.drag(), def.maxStretch());
        }
        Object obj = clsWireDef.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        WireBridge.chain(obj, "segments", def.segments());
        WireBridge.chain(obj, "thickness", Float.valueOf(def.thickness()));
        WireBridge.chain(obj, "stiffness", Float.valueOf(def.stiffness()));
        WireBridge.chain(obj, "damping", Float.valueOf(def.damping()));
        WireBridge.chain(obj, "gravity", Float.valueOf(def.gravity()));
        WireBridge.chain(obj, "drag", Float.valueOf(def.drag()));
        WireBridge.chain(obj, "maxStretch", Float.valueOf(def.maxStretch()));
        return obj;
    }

    private static void chain(Object obj, String methodName, Object arg) {
        try {
            obj.getClass().getMethod(methodName, arg.getClass()).invoke(obj, arg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean isStatic(Method m) {
        return (m.getModifiers() & 8) != 0;
    }

    private static Method findStatic(Class<?> owner, String name, Class<?> ... types) {
        try {
            return owner.getMethod(name, types);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Object[] synthesizeEnsureArgs(Class<?>[] params, UUID id, Object wireDef, class_243 a, class_243 b) {
        Object[] out = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            Class<?> p = params[i];
            out[i] = p == UUID.class ? id : (p.isInstance(wireDef) ? wireDef : (p == class_243.class ? (WireBridge.firstMissing(out, class_243.class) ? a : b) : (p == Boolean.TYPE ? Boolean.valueOf(i % 2 != 0) : (p == Integer.TYPE ? Integer.valueOf(0) : (p == Float.TYPE ? Float.valueOf(0.0f) : (p == Double.TYPE ? Double.valueOf(0.0) : (p == class_2960.class ? class_2960.method_60655((String)"odyssey", (String)"textures/misc/rope.png") : null)))))));
        }
        return out;
    }

    private static Object[] synthesizeStepArgs(Class<?>[] params, UUID id, class_243 a, boolean pinA, class_243 b, boolean pinB, class_4587 matrices, class_4597 buffers) {
        Object[] out = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            Class<?> p = params[i];
            out[i] = p == UUID.class ? id : (p == class_243.class ? (WireBridge.firstMissing(out, class_243.class) ? a : b) : (p == Boolean.TYPE ? Boolean.valueOf(WireBridge.firstMissingBool(out) ? pinA : pinB) : (p == class_4587.class ? matrices : (p == class_4597.class ? buffers : (p == class_2960.class ? class_2960.method_60655((String)"odyssey", (String)"textures/misc/rope.png") : (p == Integer.TYPE ? (Number)0xF000F0 : (Number)(p == Float.TYPE ? (Number)Float.valueOf(0.0f) : (Number)(p == Double.TYPE ? Double.valueOf(0.0) : null))))))));
        }
        return out;
    }

    private static boolean firstMissing(Object[] arr, Class<?> type) {
        for (Object o : arr) {
            if (o == null || !type.isInstance(o)) continue;
            return false;
        }
        return true;
    }

    private static boolean firstMissingBool(Object[] arr) {
        for (Object o : arr) {
            if (!(o instanceof Boolean)) continue;
            return false;
        }
        return true;
    }

    public record Def(int segments, float thickness, float stiffness, float damping, float gravity, float drag, float maxStretch) {
    }
}

