/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.physics.wire;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.kronoz.odyssey.systems.physics.wire.WireManager;
import net.kronoz.odyssey.systems.physics.wire.WireRecord;
import net.kronoz.odyssey.systems.physics.wire.WireStorage;
import net.minecraft.class_1132;
import net.minecraft.class_310;
import net.minecraft.class_3218;

public final class WireClientMirror {
    private static long lastPollMs = 0L;
    private static int lastHash = 0;

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            long now = System.currentTimeMillis();
            if (now - lastPollMs < 1000L) {
                return;
            }
            lastPollMs = now;
            WireClientMirror.pumpFromIntegratedServer();
        });
    }

    private static void pumpFromIntegratedServer() {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        class_1132 srv = mc.method_1576();
        if (srv == null) {
            return;
        }
        ArrayList<WireRecord> all = new ArrayList<WireRecord>();
        for (class_3218 sw : srv.method_3738()) {
            WireStorage st = WireStorage.get(sw);
            all.addAll(st.all());
        }
        int h = WireClientMirror.hashRecords(all);
        if (h == lastHash) {
            return;
        }
        lastHash = h;
        WireManager.clearAllClient();
        for (WireRecord r : all) {
            WireManager.ensureFromRecordClient(r);
        }
    }

    private static int hashRecords(List<WireRecord> list) {
        int h = 1;
        for (WireRecord r : list) {
            h = 31 * h + r.id.hashCode();
            h = 31 * h + r.defId.hashCode();
            h = 31 * h + r.a.pos.hashCode();
            h = 31 * h + r.b.pos.hashCode();
        }
        return h;
    }
}

