/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.physics.wire;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kronoz.odyssey.systems.physics.wire.WireDef;
import net.kronoz.odyssey.systems.physics.wire.WireRecord;
import net.kronoz.odyssey.systems.physics.wire.WireSim;
import net.kronoz.odyssey.systems.physics.wire.WireToolMath;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;

public final class WireManager {
    private static final Map<UUID, WireSim> SIMS = new HashMap<UUID, WireSim>();
    private static final Map<UUID, WireDef> DEFS = new HashMap<UUID, WireDef>();

    private WireManager() {
    }

    public static void ensure(UUID id, WireDef def, class_243 a, class_243 b) {
        if (!SIMS.containsKey(id)) {
            SIMS.put(id, new WireSim(def, a, b, def.halfWidth));
            DEFS.put(id, def);
        }
    }

    public static WireSim get(UUID id) {
        return SIMS.get(id);
    }

    public static WireDef getDef(UUID id) {
        return DEFS.get(id);
    }

    public static void remove(UUID id) {
        SIMS.remove(id);
        DEFS.remove(id);
    }

    public static void clearAllClient() {
        SIMS.clear();
        DEFS.clear();
    }

    public static void ensureFromRecordClient(WireRecord r) {
        WireDef def = WireDef.defaultCable(r.defId);
        class_243 a = WireToolMath.anchorCenter(r.a);
        class_243 b = WireToolMath.anchorCenter(r.b);
        WireManager.ensure(r.id, def, a, b);
        WireSim sim = WireManager.get(r.id);
        if (sim != null) {
            sim.setPinned(r.aPinned, r.bPinned);
        }
    }

    public static void stepAndRender(UUID id, class_243 a, boolean aPinned, class_243 b, boolean bPinned, class_4587 matrices, class_4597 consumers, int light, int overlay) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        WireSim sim = SIMS.get(id);
        WireDef def = DEFS.get(id);
        if (sim == null || def == null) {
            return;
        }
        sim.setPinned(aPinned, bPinned);
        sim.step((class_1937)mc.field_1687, a, b);
        class_243 cam = mc.field_1773.method_19418().method_19326();
        class_4587 ms = new class_4587();
        ms.method_22904(-cam.field_1352, -cam.field_1351, -cam.field_1350);
        class_4587.class_4665 entry = ms.method_23760();
        Matrix4f pm = entry.method_23761();
        class_4588 vc = consumers.getBuffer(class_1921.method_23578((class_2960)def.texture));
        WireManager.renderTubeQuadPanels(def, sim, vc, pm, entry, light, overlay);
    }

    private static void renderTubeQuadPanels(WireDef def, WireSim sim, class_4588 vc, Matrix4f pm, class_4587.class_4665 entry, int light, int overlay) {
        WireSim.Node[] ns = sim.nodes();
        if (ns.length < 2) {
            return;
        }
        int sides = Math.max(3, def.tubeSides);
        float r = def.halfWidth;
        int LIGHT = 0xF000F0;
        class_243[] T = new class_243[ns.length];
        for (int i = 0; i < ns.length; ++i) {
            class_243 t = i == 0 ? ns[1].p.method_1020(ns[0].p) : (i == ns.length - 1 ? ns[i].p.method_1020(ns[i - 1].p) : ns[i + 1].p.method_1020(ns[i - 1].p));
            double L = t.method_1033();
            T[i] = L < 1.0E-9 ? new class_243(0.0, 1.0, 0.0) : t.method_1021(1.0 / L);
        }
        class_243[] N = new class_243[ns.length];
        class_243[] B = new class_243[ns.length];
        class_243 t0 = T[0];
        class_243 helper = Math.abs(t0.field_1351) > 0.92 ? new class_243(1.0, 0.0, 0.0) : new class_243(0.0, 1.0, 0.0);
        class_243 n0 = helper.method_1036(t0);
        double L = n0.method_1033();
        n0 = L < 1.0E-9 ? new class_243(0.0, 0.0, 1.0) : n0.method_1021(1.0 / L);
        class_243 b0 = t0.method_1036(n0);
        N[0] = n0;
        B[0] = b0;
        for (int i = 1; i < ns.length; ++i) {
            class_243 ti = T[i];
            double dot = N[i - 1].method_1026(ti);
            class_243 nProj = N[i - 1].method_1020(ti.method_1021(dot));
            double Ln = nProj.method_1033();
            class_243 ni = Ln < 1.0E-9 ? N[i - 1] : nProj.method_1021(1.0 / Ln);
            class_243 bi = ti.method_1036(ni);
            N[i] = ni;
            B[i] = bi;
        }
        class_243[][] P = new class_243[ns.length][sides];
        for (int i = 0; i < ns.length; ++i) {
            for (int k = 0; k < sides; ++k) {
                double a = Math.PI * 2 * (double)k / (double)sides;
                double ca = Math.cos(a);
                double sa = Math.sin(a);
                class_243 n = N[i].method_1021(ca).method_1019(B[i].method_1021(sa));
                P[i][k] = ns[i].p.method_1019(n.method_1021((double)r));
            }
        }
        float invU = 1.0f / (float)Math.max(1, ns.length - 1);
        float invV = 1.0f / (float)sides;
        for (int i = 0; i < ns.length - 1; ++i) {
            float u0 = (float)i * invU;
            float u1 = (float)(i + 1) * invU;
            for (int k = 0; k < sides; ++k) {
                class_243 e2;
                int k1 = (k + 1) % sides;
                class_243 a = P[i][k];
                class_243 b = P[i][k1];
                class_243 c = P[i + 1][k1];
                class_243 d = P[i + 1][k];
                class_243 e1 = b.method_1020(a);
                class_243 n = e1.method_1036(e2 = d.method_1020(a));
                double Ln = n.method_1033();
                n = Ln < 1.0E-9 ? new class_243(0.0, 1.0, 0.0) : n.method_1021(1.0 / Ln);
                float v0 = (float)k * invV;
                float v1 = (float)(k + 1) * invV;
                WireManager.put(vc, pm, entry, a, u0, v0, n, overlay, 0xF000F0);
                WireManager.put(vc, pm, entry, b, u0, v1, n, overlay, 0xF000F0);
                WireManager.put(vc, pm, entry, c, u1, v1, n, overlay, 0xF000F0);
                WireManager.put(vc, pm, entry, a, u0, v0, n, overlay, 0xF000F0);
                WireManager.put(vc, pm, entry, c, u1, v1, n, overlay, 0xF000F0);
                WireManager.put(vc, pm, entry, d, u1, v0, n, overlay, 0xF000F0);
                WireManager.put(vc, pm, entry, a, u0, v0, n, overlay, 0xF000F0);
                WireManager.put(vc, pm, entry, b, u0, v1, n, overlay, 0xF000F0);
                WireManager.put(vc, pm, entry, d, u1, v0, n, overlay, 0xF000F0);
                WireManager.put(vc, pm, entry, b, u0, v1, n, overlay, 0xF000F0);
                WireManager.put(vc, pm, entry, c, u1, v1, n, overlay, 0xF000F0);
                WireManager.put(vc, pm, entry, d, u1, v0, n, overlay, 0xF000F0);
            }
        }
    }

    private static void put(class_4588 vc, Matrix4f pm, class_4587.class_4665 entry, class_243 p, float u, float v, class_243 n, int overlay, int light) {
        vc.method_22918(pm, (float)p.field_1352, (float)p.field_1351, (float)p.field_1350);
        vc.method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        vc.method_22913(u, v);
        vc.method_22922(overlay);
        vc.method_60803(light);
        vc.method_60831(entry, (float)n.field_1352, (float)n.field_1351, (float)n.field_1350);
    }
}

