/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.world;

import com.mojang.logging.LogUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_26;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3485;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3545;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public final class FixedStructurePlacer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2960[] BASES = new class_2960[]{class_2960.method_60655((String)"odyssey", (String)"facility")};
    private static final class_2338 ORIGIN = new class_2338(0, 12, 0);
    private static final class_5321<class_1937> VOID_DIM = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60655((String)"odyssey", (String)"void"));
    private static final ArrayDeque<Runnable> JOBS = new ArrayDeque();
    private static final int BLOCKS_PER_TICK = 40000;
    private static Phase PHASE = Phase.IDLE;
    private static int CARVES_LEFT = 0;
    private static int PLACES_LEFT = 0;
    private static List<class_3545<class_3499, class_2338>> TILES = List.of();

    private FixedStructurePlacer() {
    }

    public static void onWorldLoaded(class_3218 world) {
        if (!world.method_27983().equals(VOID_DIM)) {
            return;
        }
        class_26 psm = world.method_17983();
        StructuresPlacedState state = (StructuresPlacedState)psm.method_17924(StructuresPlacedState.TYPE, "odyssey_fixed_structures");
        if (state.alreadyPlaced) {
            LOGGER.info("[Odyssey] already placed");
            return;
        }
        FixedStructurePlacer.enqueue(world);
    }

    public static void tick(MinecraftServer server) {
        Runnable r;
        int steps = 64;
        while (steps-- > 0 && (r = JOBS.poll()) != null) {
            r.run();
        }
    }

    private static void enqueue(class_3218 world) {
        if (PHASE != Phase.IDLE) {
            return;
        }
        class_3485 stm = world.method_14183();
        List<class_3545<class_3499, class_2338>> tiles = FixedStructurePlacer.findGrid3D(stm, BASES, ORIGIN);
        if (tiles.isEmpty()) {
            LOGGER.error("[Odyssey] No facility grid tiles found (expected facilityX_Y_Z.nbt or facility_X_Y_Z.nbt)");
            return;
        }
        FixedStructurePlacer.assertUniformTileSize(tiles);
        FixedStructurePlacer.forceChunks(world, tiles);
        TILES = tiles;
        CARVES_LEFT = tiles.size();
        PHASE = Phase.CARVING;
        for (class_3545<class_3499, class_2338> p : tiles) {
            JOBS.add(new CarveTask(world, (class_2338)p.method_15441(), ((class_3499)p.method_15442()).method_15160(), 1));
        }
        LOGGER.info("[Odyssey] queued {} carve jobs", (Object)tiles.size());
    }

    private static void enqueuePlacements(class_3218 world) {
        if (PHASE != Phase.CARVING) {
            return;
        }
        PHASE = Phase.PLACING;
        PLACES_LEFT = TILES.size();
        for (class_3545<class_3499, class_2338> p : TILES) {
            JOBS.add(() -> {
                FixedStructurePlacer.place(world, (class_3499)p.method_15442(), (class_2338)p.method_15441());
                if (--PLACES_LEFT == 0) {
                    PHASE = Phase.DONE;
                    FixedStructurePlacer.markPlaced(world);
                    LOGGER.info("[Odyssey] placement phase done");
                }
            });
        }
        LOGGER.info("[Odyssey] queued {} placement jobs", (Object)TILES.size());
    }

    private static List<class_3545<class_3499, class_2338>> findGrid3D(class_3485 stm, class_2960[] bases, class_2338 origin) {
        for (class_2960 base : bases) {
            List<class_3545<class_3499, class_2338>> grid = FixedStructurePlacer.collectGrid3D(stm, base, origin, false);
            if (!grid.isEmpty()) {
                LOGGER.info("[Odyssey] Using 3D grid w/o underscore for {}", (Object)base);
                return grid;
            }
            grid = FixedStructurePlacer.collectGrid3D(stm, base, origin, true);
            if (grid.isEmpty()) continue;
            LOGGER.info("[Odyssey] Using 3D grid with underscore for {}", (Object)base);
            return grid;
        }
        return List.of();
    }

    private static class_3499 getTemplate(class_3485 stm, class_2960 id) {
        class_3499 t = stm.method_15094(id).orElse(null);
        if (t != null) {
            return t;
        }
        class_2960 s1 = class_2960.method_60655((String)id.method_12836(), (String)("structure/" + id.method_12832()));
        t = stm.method_15094(s1).orElse(null);
        if (t != null) {
            return t;
        }
        class_2960 s2 = class_2960.method_60655((String)id.method_12836(), (String)("structures/" + id.method_12832()));
        return stm.method_15094(s2).orElse(null);
    }

    private static List<class_3545<class_3499, class_2338>> collectGrid3D(class_3485 stm, class_2960 base, class_2338 origin, boolean underscore) {
        ArrayList<class_3545<class_3499, class_2338>> out = new ArrayList<class_3545<class_3499, class_2338>>();
        class_2382 tile = null;
        int MAX = 128;
        for (int gx = 0; gx < 128; ++gx) {
            boolean anyX = false;
            for (int gy = 0; gy < 128; ++gy) {
                boolean anyY = false;
                for (int gz = 0; gz < 128; ++gz) {
                    String name = underscore ? base.method_12832() + "_" + gx + "_" + gy + "_" + gz : base.method_12832() + gx + "_" + gy + "_" + gz;
                    class_2960 id = class_2960.method_60655((String)base.method_12836(), (String)name);
                    class_3499 t = FixedStructurePlacer.getTemplate(stm, id);
                    if (t == null) {
                        if (gz != 0) continue;
                        break;
                    }
                    if (tile == null) {
                        tile = t.method_15160();
                    }
                    class_2338 pos = origin.method_10069(tile.method_10263() * gx, tile.method_10264() * gy, tile.method_10260() * gz);
                    out.add((class_3545<class_3499, class_2338>)new class_3545((Object)t, (Object)pos));
                    anyY = true;
                }
                if (!anyY) break;
                anyX = true;
            }
            if (!anyX) break;
        }
        return out;
    }

    private static void assertUniformTileSize(List<class_3545<class_3499, class_2338>> tiles) {
        if (tiles.isEmpty()) {
            return;
        }
        class_2382 s0 = ((class_3499)tiles.get(0).method_15442()).method_15160();
        for (class_3545<class_3499, class_2338> p : tiles) {
            class_2382 s = ((class_3499)p.method_15442()).method_15160();
            if (s.equals((Object)s0)) continue;
            throw new IllegalStateException("[Odyssey] Tile size mismatch: expected " + String.valueOf(s0) + " but found " + String.valueOf(s) + " at " + String.valueOf(p.method_15441()));
        }
    }

    private static void place(class_3218 world, class_3499 template, class_2338 origin) {
        class_3492 data = new class_3492().method_15123(class_2470.field_11467).method_15125(class_2415.field_11302).method_15133(false).method_16184((class_3491)WaterlogSanitizerProcessor.INSTANCE).method_16184((class_3491)RemoveStructureBlocksProcessor.INSTANCE);
        class_5819 rng = world.method_8409();
        boolean ok = template.method_15172((class_5425)world, origin, origin, data, rng, 2);
        LOGGER.info("[Odyssey] placed {} at {} -> {}", new Object[]{template, origin, ok});
    }

    private static void markPlaced(class_3218 world) {
        class_26 psm = world.method_17983();
        StructuresPlacedState state = (StructuresPlacedState)psm.method_17924(StructuresPlacedState.TYPE, "odyssey_fixed_structures");
        state.alreadyPlaced = true;
        state.method_80();
        psm.method_125();
        LOGGER.info("[Odyssey] marked as placed");
    }

    private static void forceChunks(class_3218 world, List<class_3545<class_3499, class_2338>> tiles) {
        for (class_3545<class_3499, class_2338> p : tiles) {
            class_2382 s = ((class_3499)p.method_15442()).method_15160();
            class_2338 o = (class_2338)p.method_15441();
            int minX = o.method_10263() - 1;
            int minZ = o.method_10260() - 1;
            int maxX = o.method_10263() + s.method_10263();
            int maxZ = o.method_10260() + s.method_10260();
            for (int cx = minX >> 4; cx <= maxX >> 4; ++cx) {
                for (int cz = minZ >> 4; cz <= maxZ >> 4; ++cz) {
                    world.method_14178().method_12121(cx, cz, class_2806.field_12803, true);
                }
            }
        }
    }

    public static final class StructuresPlacedState
    extends class_18 {
        public static final String KEY = "odyssey_fixed_structures";
        public static final class_18.class_8645<StructuresPlacedState> TYPE = new class_18.class_8645(StructuresPlacedState::new, StructuresPlacedState::fromNbt, null);
        public boolean alreadyPlaced = false;

        public static StructuresPlacedState fromNbt(class_2487 nbt, class_7225.class_7874 lookup) {
            StructuresPlacedState s = new StructuresPlacedState();
            s.alreadyPlaced = nbt.method_10577("alreadyPlaced");
            return s;
        }

        public class_2487 method_75(class_2487 nbt, class_7225.class_7874 lookup) {
            nbt.method_10556("alreadyPlaced", this.alreadyPlaced);
            return nbt;
        }
    }

    private static enum Phase {
        IDLE,
        CARVING,
        PLACING,
        DONE;

    }

    private static final class CarveTask
    implements Runnable {
        private final class_3218 world;
        private final int minX;
        private final int minY;
        private final int minZ;
        private final int maxX;
        private final int maxY;
        private final int maxZ;
        private int x;
        private int y;
        private int z;
        private boolean started;

        CarveTask(class_3218 world, class_2338 origin, class_2382 size, int margin) {
            this.world = world;
            this.minX = origin.method_10263() - margin;
            this.minY = origin.method_10264() - margin;
            this.minZ = origin.method_10260() - margin;
            this.maxX = origin.method_10263() + size.method_10263() + margin - 1;
            this.maxY = origin.method_10264() + size.method_10264() + margin - 1;
            this.maxZ = origin.method_10260() + size.method_10260() + margin - 1;
            this.x = this.minX;
            this.y = this.minY;
            this.z = this.minZ;
        }

        @Override
        public void run() {
            if (!this.started) {
                this.started = true;
            }
            int left = 40000;
            while (left-- > 0 && this.y <= this.maxY) {
                class_2338 p = new class_2338(this.x, this.y, this.z);
                if (!this.world.method_22347(p)) {
                    this.world.method_8652(p, class_2246.field_10124.method_9564(), 2);
                }
                ++this.x;
                if (this.x <= this.maxX) continue;
                this.x = this.minX;
                ++this.z;
                if (this.z <= this.maxZ) continue;
                this.z = this.minZ;
                ++this.y;
            }
            if (this.y <= this.maxY) {
                JOBS.add(this);
            } else if (--CARVES_LEFT == 0) {
                FixedStructurePlacer.enqueuePlacements(this.world);
            }
        }
    }

    private static final class WaterlogSanitizerProcessor
    extends class_3491 {
        static final WaterlogSanitizerProcessor INSTANCE = new WaterlogSanitizerProcessor();

        private WaterlogSanitizerProcessor() {
        }

        public class_3499.class_3501 method_15110(class_4538 world, class_2338 pos, class_2338 pivot, class_3499.class_3501 original, class_3499.class_3501 current, class_3492 data) {
            class_2680 st = current.comp_1342();
            if (st.method_28501().contains(class_2741.field_12508)) {
                st = (class_2680)st.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
                return new class_3499.class_3501(current.comp_1341(), st, current.comp_1343());
            }
            return current;
        }

        protected class_3828<?> method_16772() {
            return class_3828.field_16987;
        }
    }

    private static final class RemoveStructureBlocksProcessor
    extends class_3491 {
        static final RemoveStructureBlocksProcessor INSTANCE = new RemoveStructureBlocksProcessor();

        private RemoveStructureBlocksProcessor() {
        }

        public class_3499.class_3501 method_15110(class_4538 world, class_2338 pos, class_2338 pivot, class_3499.class_3501 original, class_3499.class_3501 current, class_3492 data) {
            if (current.comp_1342().method_27852(class_2246.field_10465)) {
                return null;
            }
            return current;
        }

        protected class_3828<?> method_16772() {
            return class_3828.field_16987;
        }
    }
}

