/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.world;

import com.mojang.logging.LogUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1542;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_26;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2806;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3485;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3545;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public final class FixedStructurePlacerOverworld {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2960[] BASES = new class_2960[]{class_2960.method_60655((String)"odyssey", (String)"city")};
    private static final class_2338 ORIGIN = new class_2338(-120, 50, -120);
    private static final class_5321<class_1937> OVERWORLD = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60655((String)"minecraft", (String)"overworld"));
    private static final ArrayDeque<Runnable> JOBS = new ArrayDeque();
    private static final int BLOCKS_PER_TICK = 40000;
    private static Phase PHASE = Phase.IDLE;
    private static int CARVES_LEFT = 0;
    private static int PLACES_LEFT = 0;
    private static List<class_3545<class_3499, class_2338>> TILES = List.of();

    private FixedStructurePlacerOverworld() {
    }

    public static void onWorldLoaded(class_3218 world) {
        if (!world.method_27983().equals(OVERWORLD)) {
            return;
        }
        class_26 psm = world.method_17983();
        StructuresPlacedState state = (StructuresPlacedState)psm.method_17924(StructuresPlacedState.TYPE, "odyssey_fixed_structures");
        if (state.alreadyPlaced) {
            if (state.hasSpawn()) {
                world.method_8554(new class_2338(state.spawnX, state.spawnY, state.spawnZ), 0.0f);
            }
            LOGGER.info("[Odyssey] city already placed");
            return;
        }
        FixedStructurePlacerOverworld.enqueue(world);
    }

    public static void tick(MinecraftServer server) {
        Runnable r;
        int steps = 64;
        while (steps-- > 0 && (r = JOBS.poll()) != null) {
            r.run();
        }
    }

    private static void enqueue(class_3218 world) {
        if (PHASE != Phase.IDLE) {
            return;
        }
        class_3485 stm = world.method_14183();
        List<class_3545<class_3499, class_2338>> tiles = FixedStructurePlacerOverworld.findGrid3D(stm, BASES, ORIGIN);
        if (tiles.isEmpty()) {
            LOGGER.error("[Odyssey] No city grid tiles found (expected cityX_Y_Z.nbt or city_X_Y_Z.nbt)");
            return;
        }
        FixedStructurePlacerOverworld.assertUniformTileSize(tiles);
        FixedStructurePlacerOverworld.forceChunks(world, tiles);
        TILES = tiles;
        CARVES_LEFT = tiles.size();
        PHASE = Phase.CARVING;
        for (class_3545<class_3499, class_2338> p : tiles) {
            JOBS.add(new CarveTask(world, (class_2338)p.method_15441(), ((class_3499)p.method_15442()).method_15160(), 1));
        }
        LOGGER.info("[Odyssey] queued {} carve jobs", (Object)tiles.size());
    }

    private static void enqueueCleanupThenPlacements(class_3218 world) {
        class_238 full = FixedStructurePlacerOverworld.computeTilesAABB(TILES);
        JOBS.add(new CleanupDroppedItemsTask(world, full));
    }

    private static void enqueuePlacements(class_3218 world) {
        if (PHASE != Phase.CARVING) {
            return;
        }
        PHASE = Phase.PLACING;
        PLACES_LEFT = TILES.size();
        for (class_3545<class_3499, class_2338> p : TILES) {
            JOBS.add(() -> {
                FixedStructurePlacerOverworld.place(world, (class_3499)p.method_15442(), (class_2338)p.method_15441());
                if (--PLACES_LEFT == 0) {
                    FixedStructurePlacerOverworld.computeAndStoreCenterSpawn(world);
                    FixedStructurePlacerOverworld.teleportOnlinePlayersUp(world, 10);
                    PHASE = Phase.DONE;
                    FixedStructurePlacerOverworld.markPlaced(world);
                    LOGGER.info("[Odyssey] placement phase done");
                }
            });
        }
        LOGGER.info("[Odyssey] queued {} placement jobs", (Object)TILES.size());
    }

    private static List<class_3545<class_3499, class_2338>> findGrid3D(class_3485 stm, class_2960[] bases, class_2338 origin) {
        for (class_2960 base : bases) {
            List<class_3545<class_3499, class_2338>> grid = FixedStructurePlacerOverworld.collectGrid3D(stm, base, origin, false);
            if (!grid.isEmpty()) {
                LOGGER.info("[Odyssey] Using 3D grid w/o underscore for {}", (Object)base);
                return grid;
            }
            grid = FixedStructurePlacerOverworld.collectGrid3D(stm, base, origin, true);
            if (grid.isEmpty()) continue;
            LOGGER.info("[Odyssey] Using 3D grid with underscore for {}", (Object)base);
            return grid;
        }
        return List.of();
    }

    private static class_3499 getTemplate(class_3485 stm, class_2960 id) {
        class_3499 t = stm.method_15094(id).orElse(null);
        if (t != null) {
            return t;
        }
        class_2960 s1 = class_2960.method_60655((String)id.method_12836(), (String)("structure/" + id.method_12832()));
        t = stm.method_15094(s1).orElse(null);
        if (t != null) {
            return t;
        }
        class_2960 s2 = class_2960.method_60655((String)id.method_12836(), (String)("structures/" + id.method_12832()));
        return stm.method_15094(s2).orElse(null);
    }

    private static List<class_3545<class_3499, class_2338>> collectGrid3D(class_3485 stm, class_2960 base, class_2338 origin, boolean underscore) {
        ArrayList<class_3545<class_3499, class_2338>> out = new ArrayList<class_3545<class_3499, class_2338>>();
        class_2382 tile = null;
        int MAX = 128;
        for (int gx = 0; gx < 128; ++gx) {
            boolean anyX = false;
            for (int gy = 0; gy < 128; ++gy) {
                boolean anyY = false;
                for (int gz = 0; gz < 128; ++gz) {
                    String name = underscore ? base.method_12832() + "_" + gx + "_" + gy + "_" + gz : base.method_12832() + gx + "_" + gy + "_" + gz;
                    class_2960 id = class_2960.method_60655((String)base.method_12836(), (String)name);
                    class_3499 t = FixedStructurePlacerOverworld.getTemplate(stm, id);
                    if (t == null) {
                        if (gz != 0) continue;
                        break;
                    }
                    if (tile == null) {
                        tile = t.method_15160();
                    }
                    class_2338 pos = origin.method_10069(tile.method_10263() * gx, tile.method_10264() * gy, tile.method_10260() * gz);
                    out.add((class_3545<class_3499, class_2338>)new class_3545((Object)t, (Object)pos));
                    anyY = true;
                }
                if (!anyY) break;
                anyX = true;
            }
            if (!anyX) break;
        }
        return out;
    }

    private static void assertUniformTileSize(List<class_3545<class_3499, class_2338>> tiles) {
        if (tiles.isEmpty()) {
            return;
        }
        class_2382 s0 = ((class_3499)tiles.get(0).method_15442()).method_15160();
        for (class_3545<class_3499, class_2338> p : tiles) {
            class_2382 s = ((class_3499)p.method_15442()).method_15160();
            if (s.equals((Object)s0)) continue;
            throw new IllegalStateException("[Odyssey] Tile size mismatch: expected " + String.valueOf(s0) + " but found " + String.valueOf(s) + " at " + String.valueOf(p.method_15441()));
        }
    }

    private static void place(class_3218 world, class_3499 template, class_2338 origin) {
        class_3492 data = new class_3492().method_15123(class_2470.field_11467).method_15125(class_2415.field_11302).method_15133(false).method_16184((class_3491)WaterlogSanitizerProcessor.INSTANCE).method_16184((class_3491)RemoveStructureBlocksProcessor.INSTANCE);
        class_5819 rng = world.method_8409();
        boolean ok = template.method_15172((class_5425)world, origin, origin, data, rng, 2);
        LOGGER.info("[Odyssey] placed {} at {} -> {}", new Object[]{template, origin, ok});
    }

    private static void markPlaced(class_3218 world) {
        class_26 psm = world.method_17983();
        StructuresPlacedState state = (StructuresPlacedState)psm.method_17924(StructuresPlacedState.TYPE, "odyssey_fixed_structures");
        state.alreadyPlaced = true;
        state.method_80();
        psm.method_125();
        LOGGER.info("[Odyssey] marked as placed");
    }

    private static void forceChunks(class_3218 world, List<class_3545<class_3499, class_2338>> tiles) {
        for (class_3545<class_3499, class_2338> p : tiles) {
            class_2382 s = ((class_3499)p.method_15442()).method_15160();
            class_2338 o = (class_2338)p.method_15441();
            int minX = o.method_10263() - 1;
            int minZ = o.method_10260() - 1;
            int maxX = o.method_10263() + s.method_10263();
            int maxZ = o.method_10260() + s.method_10260();
            for (int cx = minX >> 4; cx <= maxX >> 4; ++cx) {
                for (int cz = minZ >> 4; cz <= maxZ >> 4; ++cz) {
                    world.method_14178().method_12121(cx, cz, class_2806.field_12803, true);
                }
            }
        }
    }

    private static class_238 computeTilesAABB(List<class_3545<class_3499, class_2338>> tiles) {
        if (tiles.isEmpty()) {
            return new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (class_3545<class_3499, class_2338> p : tiles) {
            class_2382 s = ((class_3499)p.method_15442()).method_15160();
            class_2338 o = (class_2338)p.method_15441();
            minX = Math.min(minX, o.method_10263());
            minY = Math.min(minY, o.method_10264());
            minZ = Math.min(minZ, o.method_10260());
            maxX = Math.max(maxX, o.method_10263() + s.method_10263() - 1);
            maxY = Math.max(maxY, o.method_10264() + s.method_10264() - 1);
            maxZ = Math.max(maxZ, o.method_10260() + s.method_10260() - 1);
        }
        return new class_238((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
    }

    private static void computeAndStoreCenterSpawn(class_3218 world) {
        int minSafeY;
        int centerZ;
        class_238 aabb = FixedStructurePlacerOverworld.computeTilesAABB(TILES);
        int centerX = (int)Math.floor((aabb.field_1323 + aabb.field_1320) * 0.5);
        int topY = world.method_8624(class_2902.class_2903.field_13203, centerX, centerZ = (int)Math.floor((aabb.field_1321 + aabb.field_1324) * 0.5));
        if (topY < (minSafeY = (int)aabb.field_1322 + 2)) {
            topY = minSafeY;
        }
        class_2338 spawn = new class_2338(centerX, topY, centerZ);
        class_26 psm = world.method_17983();
        StructuresPlacedState state = (StructuresPlacedState)psm.method_17924(StructuresPlacedState.TYPE, "odyssey_fixed_structures");
        state.spawnX = spawn.method_10263();
        state.spawnY = spawn.method_10264();
        state.spawnZ = spawn.method_10260();
        state.method_80();
        psm.method_125();
        world.method_8554(spawn, 0.0f);
        LOGGER.info("[Odyssey] computed center spawn at {}", (Object)spawn);
    }

    private static void teleportOnlinePlayersUp(class_3218 overworld, int dy) {
        class_26 psm = overworld.method_17983();
        StructuresPlacedState state = (StructuresPlacedState)psm.method_17924(StructuresPlacedState.TYPE, "odyssey_fixed_structures");
        if (!state.hasSpawn()) {
            return;
        }
        int sx = state.spawnX;
        int sz = state.spawnZ;
        overworld.method_14178().method_12121(sx >> 4, sz >> 4, class_2806.field_12803, true);
        int baseY = overworld.method_8624(class_2902.class_2903.field_13203, sx, sz);
        int y = Math.max(baseY, state.spawnY) + 5;
        double tx = (double)sx + 10.5;
        double ty = (double)y + 0.1;
        double tz = (double)sz + 10.5;
        MinecraftServer server = overworld.method_8503();
        for (class_3222 player : server.method_3760().method_14571()) {
            if (player.method_37908().method_27983() != OVERWORLD) continue;
            player.field_6017 = 0.0f;
            player.method_14251(overworld, tx, ty, tz, player.method_36454(), player.method_36455());
        }
    }

    public static final class StructuresPlacedState
    extends class_18 {
        public static final String KEY = "odyssey_fixed_structures";
        public static final class_18.class_8645<StructuresPlacedState> TYPE = new class_18.class_8645(StructuresPlacedState::new, StructuresPlacedState::fromNbt, null);
        public boolean alreadyPlaced = false;
        public int spawnX = Integer.MIN_VALUE;
        public int spawnY = Integer.MIN_VALUE;
        public int spawnZ = Integer.MIN_VALUE;

        public boolean hasSpawn() {
            return this.spawnX != Integer.MIN_VALUE;
        }

        public static StructuresPlacedState fromNbt(class_2487 nbt, class_7225.class_7874 lookup) {
            StructuresPlacedState s = new StructuresPlacedState();
            s.alreadyPlaced = nbt.method_10577("alreadyPlaced");
            if (nbt.method_10545("spawnX")) {
                s.spawnX = nbt.method_10550("spawnX");
                s.spawnY = nbt.method_10550("spawnY");
                s.spawnZ = nbt.method_10550("spawnZ");
            }
            return s;
        }

        public class_2487 method_75(class_2487 nbt, class_7225.class_7874 lookup) {
            nbt.method_10556("alreadyPlaced", this.alreadyPlaced);
            if (this.hasSpawn()) {
                nbt.method_10569("spawnX", this.spawnX);
                nbt.method_10569("spawnY", this.spawnY);
                nbt.method_10569("spawnZ", this.spawnZ);
            }
            return nbt;
        }
    }

    private static enum Phase {
        IDLE,
        CARVING,
        PLACING,
        DONE;

    }

    private static final class CarveTask
    implements Runnable {
        private final class_3218 world;
        private final int minX;
        private final int minY;
        private final int minZ;
        private final int maxX;
        private final int maxY;
        private final int maxZ;
        private int x;
        private int y;
        private int z;
        private boolean started;

        CarveTask(class_3218 world, class_2338 origin, class_2382 size, int margin) {
            this.world = world;
            this.minX = origin.method_10263() - margin;
            this.minY = origin.method_10264() - margin;
            this.minZ = origin.method_10260() - margin;
            this.maxX = origin.method_10263() + size.method_10263() + margin - 1;
            this.maxY = origin.method_10264() + size.method_10264() + margin - 1;
            this.maxZ = origin.method_10260() + size.method_10260() + margin - 1;
            this.x = this.minX;
            this.y = this.minY;
            this.z = this.minZ;
        }

        @Override
        public void run() {
            if (!this.started) {
                this.started = true;
            }
            int left = 40000;
            while (left-- > 0 && this.y <= this.maxY) {
                class_2338 p = new class_2338(this.x, this.y, this.z);
                if (!this.world.method_22347(p)) {
                    this.world.method_8652(p, class_2246.field_10124.method_9564(), 2);
                }
                ++this.x;
                if (this.x <= this.maxX) continue;
                this.x = this.minX;
                ++this.z;
                if (this.z <= this.maxZ) continue;
                this.z = this.minZ;
                ++this.y;
            }
            if (this.y <= this.maxY) {
                JOBS.add(this);
            } else if (--CARVES_LEFT == 0) {
                FixedStructurePlacerOverworld.enqueueCleanupThenPlacements(this.world);
            }
        }
    }

    private static final class CleanupDroppedItemsTask
    implements Runnable {
        private final class_3218 world;
        private final class_238 box;
        private boolean done;

        CleanupDroppedItemsTask(class_3218 world, class_238 box) {
            this.world = world;
            this.box = box.method_1014(1.0);
        }

        @Override
        public void run() {
            if (this.done) {
                return;
            }
            List items = this.world.method_8390(class_1542.class, this.box, e -> true);
            int count = 0;
            for (class_1542 it : items) {
                it.method_31472();
                ++count;
            }
            LOGGER.info("[Odyssey] removed {} dropped item entities in {}", (Object)count, (Object)this.box);
            this.done = true;
            FixedStructurePlacerOverworld.enqueuePlacements(this.world);
        }
    }

    private static final class WaterlogSanitizerProcessor
    extends class_3491 {
        static final WaterlogSanitizerProcessor INSTANCE = new WaterlogSanitizerProcessor();

        private WaterlogSanitizerProcessor() {
        }

        public class_3499.class_3501 method_15110(class_4538 world, class_2338 pos, class_2338 pivot, class_3499.class_3501 original, class_3499.class_3501 current, class_3492 data) {
            class_2680 st = current.comp_1342();
            if (st.method_28501().contains(class_2741.field_12508)) {
                st = (class_2680)st.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
                return new class_3499.class_3501(current.comp_1341(), st, current.comp_1343());
            }
            return current;
        }

        protected class_3828<?> method_16772() {
            return class_3828.field_16987;
        }
    }

    private static final class RemoveStructureBlocksProcessor
    extends class_3491 {
        static final RemoveStructureBlocksProcessor INSTANCE = new RemoveStructureBlocksProcessor();

        private RemoveStructureBlocksProcessor() {
        }

        public class_3499.class_3501 method_15110(class_4538 world, class_2338 pos, class_2338 pivot, class_3499.class_3501 original, class_3499.class_3501 current, class_3492 data) {
            if (current.comp_1342().method_27852(class_2246.field_10465)) {
                return null;
            }
            return current;
        }

        protected class_3828<?> method_16772() {
            return class_3828.field_16987;
        }
    }
}

