/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui;

import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import red.jackf.chesttracker.api.ClientBlockSource;
import red.jackf.chesttracker.api.memory.MemoryKey;
import red.jackf.chesttracker.api.providers.InteractionTracker;
import red.jackf.chesttracker.api.providers.ProviderUtils;
import red.jackf.chesttracker.api.providers.ServerProvider;
import red.jackf.chesttracker.impl.config.ChestTrackerConfig;
import red.jackf.chesttracker.impl.memory.MemoryBankAccessImpl;
import red.jackf.chesttracker.impl.providers.ProviderHandler;
import red.jackf.jackfredlib.client.api.gps.Coordinate;

@Environment(value=EnvType.CLIENT)
public class DeveloperOverlay {
    public static void setup() {
        HudRenderCallback.EVENT.register((graphics, delta) -> {
            ServerProvider provider = ProviderHandler.INSTANCE.getCurrentProvider().orElse(null);
            if (!((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).debug.showDevHud) {
                return;
            }
            ArrayList<Object> lines = new ArrayList<Object>();
            lines.add("Chest Tracker Debug");
            lines.add("");
            lines.add("Coordinate: " + String.valueOf(Coordinate.getCurrent().orElse(null)));
            lines.add("");
            lines.add("Provider: " + String.valueOf(provider != null ? provider.id() : "<none>"));
            lines.add("");
            if (provider != null) {
                MemoryBankAccessImpl.INSTANCE.getLoadedInternal().ifPresentOrElse(bank -> {
                    Optional<class_2960> currentKey = ProviderUtils.getPlayersCurrentKey();
                    lines.add("Storage Backend: " + ((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).storage.storageBackend.toString());
                    String loadedStr = "Loaded: " + bank.getId();
                    if (bank.getMetadata().getName() != null) {
                        loadedStr = loadedStr + " (" + bank.getMetadata().getName() + ")";
                    }
                    lines.add(loadedStr);
                    lines.add("Keys: " + bank.getKeys().size());
                    lines.add("Current key: " + String.valueOf(currentKey));
                    if (currentKey.isPresent()) {
                        Optional<MemoryKey> currentMemoryKey = bank.getKey(currentKey.get());
                        if (currentMemoryKey.isPresent()) {
                            lines.add("Memories in current key: " + currentMemoryKey.get().getMemories().size());
                        } else {
                            lines.add("No memories in current key");
                        }
                    }
                    lines.add("");
                    provider.addDebugInformation(lines::add);
                    lines.add("");
                    Optional<ClientBlockSource> source = InteractionTracker.INSTANCE.getLastBlockSource();
                    String sourceStr = source.map(blockSource -> blockSource.pos().method_23854() + "@" + String.valueOf(blockSource.level().method_27983().method_29177())).orElse("<none>");
                    lines.add("Location: " + sourceStr);
                }, () -> lines.add("No memory bank loaded"));
            }
            for (int i = 0; i < lines.size(); ++i) {
                String line = (String)lines.get(i);
                graphics.method_25303(class_310.method_1551().field_1772, line, 10, 10 + 9 * i, -1);
            }
        });
    }
}

