/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui.invbutton;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_465;
import org.apache.commons.io.FileUtils;
import red.jackf.chesttracker.impl.ChestTracker;
import red.jackf.chesttracker.impl.gui.invbutton.ButtonPositionMap;
import red.jackf.chesttracker.impl.gui.invbutton.data.ButtonPositionDataFile;
import red.jackf.chesttracker.impl.gui.invbutton.position.ButtonPosition;
import red.jackf.chesttracker.impl.util.Constants;
import red.jackf.jackfredlib.client.api.toasts.ToastBuilder;
import red.jackf.jackfredlib.client.api.toasts.ToastFormat;
import red.jackf.jackfredlib.client.api.toasts.ToastIcon;
import red.jackf.jackfredlib.client.api.toasts.Toasts;

@Environment(value=EnvType.CLIENT)
public class PositionExporter {
    public static Path getExportPath() {
        return Constants.STORAGE_DIR.resolve("export");
    }

    public static void export(class_465<?> screen, ButtonPosition toExport) {
        String className = ButtonPositionMap.getClassString(screen);
        ButtonPositionDataFile file = new ButtonPositionDataFile(List.of(className), toExport);
        Optional json = ButtonPositionDataFile.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)file).resultOrPartial(class_156.method_29188((String)"Could not export button position", PositionExporter::onFail));
        String[] split = className.split("\\.");
        Path path = PositionExporter.getExportPath().resolve(split[split.length - 1] + ".json");
        if (json.isPresent()) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                FileUtils.write((File)path.toFile(), (CharSequence)((JsonElement)json.get()).toString(), (Charset)StandardCharsets.UTF_8);
                Toasts.INSTANCE.send(ToastBuilder.builder((ToastFormat)ToastFormat.DARK, (class_2561)class_2561.method_43471((String)"chesttracker.title")).withIcon(ToastIcon.modIcon((String)"chesttracker")).addMessage((class_2561)class_2561.method_43469((String)"chesttracker.inventoryButton.export.toast", (Object[])new Object[]{class_2561.method_43470((String)path.toString()).method_27692(class_124.field_1065)})).progressShowsVisibleTime().build());
            }
            catch (IOException | NullPointerException ex) {
                PositionExporter.onFail(ex);
            }
        }
    }

    private static void sendErrorToast() {
        Toasts.INSTANCE.send(ToastBuilder.builder((ToastFormat)ToastFormat.DARK, (class_2561)class_2561.method_43471((String)"chesttracker.title")).withIcon(ToastIcon.modIcon((String)"chesttracker")).addMessage((class_2561)class_2561.method_43471((String)"chesttracker.inventoryButton.export.errorToast").method_27692(class_124.field_1061)).progressShowsVisibleTime().build());
    }

    private static void onFail(Exception ex) {
        PositionExporter.sendErrorToast();
        ChestTracker.LOGGER.error("Error exporting button position", (Throwable)ex);
    }

    private static void onFail(String message) {
        PositionExporter.sendErrorToast();
        ChestTracker.LOGGER.error(message);
    }
}

