/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui.screen;

import com.mojang.datafixers.util.Pair;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.impl.config.ChestTrackerConfig;
import red.jackf.chesttracker.impl.gui.screen.BaseUtilScreen;
import red.jackf.chesttracker.impl.gui.screen.CreateMemoryBankScreen;
import red.jackf.chesttracker.impl.gui.screen.EditMemoryBankScreen;
import red.jackf.chesttracker.impl.gui.util.TextColours;
import red.jackf.chesttracker.impl.gui.widget.CustomEditBox;
import red.jackf.chesttracker.impl.gui.widget.StringSelectorWidget;
import red.jackf.chesttracker.impl.gui.widget.TextWidget;
import red.jackf.chesttracker.impl.memory.MemoryBankAccessImpl;
import red.jackf.chesttracker.impl.memory.MemoryBankImpl;
import red.jackf.chesttracker.impl.memory.metadata.Metadata;
import red.jackf.chesttracker.impl.storage.Storage;
import red.jackf.chesttracker.impl.util.GuiUtil;

@Environment(value=EnvType.CLIENT)
public class MemoryBankManagerScreen
extends BaseUtilScreen {
    private static final int BUTTON_SIZE = 12;
    private static final int SEARCH_TOP = 19;
    private static final int SEARCH_HEIGHT = 12;
    private static final int LIST_TOP = 36;
    private final Runnable onRemoveScreen;
    private final Runnable afterBankLoaded;
    private class_342 search = null;
    private StringSelectorWidget<String> memoryBankList;
    private Map<String, Metadata> memoryBanks;

    public MemoryBankManagerScreen(Runnable onRemoveScreen, Runnable afterBankLoaded) {
        super((class_2561)class_2561.method_43471((String)"chesttracker.gui.memoryManager"));
        this.onRemoveScreen = onRemoveScreen;
        this.afterBankLoaded = afterBankLoaded;
    }

    public MemoryBankManagerScreen(Supplier<@Nullable class_437> onRemoveScreen, Runnable afterBankLoaded) {
        this(() -> class_310.method_1551().method_1507((class_437)onRemoveScreen.get()), afterBankLoaded);
    }

    public MemoryBankManagerScreen(@Nullable class_437 parent, Runnable afterBankLoaded) {
        this(() -> parent, afterBankLoaded);
    }

    @Override
    protected void method_25426() {
        boolean inGame;
        super.method_25426();
        this.memoryBanks = Storage.getAllIds().stream().sorted().map(id -> Pair.of((Object)id, Storage.loadMetadata(id))).filter(pair -> ((Optional)pair.getSecond()).isPresent()).collect(Collectors.toMap(Pair::getFirst, p -> (Metadata)((Optional)p.getSecond()).get(), (a, b) -> a, LinkedHashMap::new));
        this.method_37060(new TextWidget(this.left + 8, this.top + 8, this.menuWidth - 8 - 10 - 12, (class_2561)class_2561.method_43469((String)"chesttracker.gui.memoryManager.selectedBackend", (Object[])new Object[]{((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).storage.storageBackend.name()}), TextColours.getLabelColour(), TextWidget.Alignment.RIGHT));
        this.method_37063((class_364)GuiUtil.close(this.left + this.menuWidth - 12 - 5, this.top + 5, b -> this.method_25419()));
        boolean bl = inGame = class_310.method_1551().field_1687 != null;
        if (inGame) {
            ((class_344)this.method_37063((class_364)new class_344(this.left + this.menuWidth - 12 - 5, this.top + 19, 12, 12, GuiUtil.twoSprite("new_memory_bank/button"), b -> this.openCreateScreen(this.afterBankLoaded)))).method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.gui.memoryManager.newMemoryBank")));
        }
        this.search = (class_342)this.method_37063((class_364)new CustomEditBox(class_310.method_1551().field_1772, this.left + 8, this.top + 19, this.menuWidth - 16 - (inGame ? 12 : 0), 12, this.search, (class_2561)class_2561.method_43471((String)"chesttracker.gui.memoryManager.search")));
        this.search.method_1868(TextColours.getTextColour());
        this.search.method_47404((class_2561)class_2561.method_43471((String)"chesttracker.gui.memoryManager.search"));
        this.search.method_1863(term -> this.memoryBankList.setOptions(this.memoryBanks.entrySet().stream().filter(entry -> {
            String name = ((Metadata)entry.getValue()).getName();
            if (name == null) {
                name = (String)entry.getKey();
            }
            return name.toLowerCase().contains(term.toLowerCase());
        }).collect(Collectors.toMap(Map.Entry::getKey, e -> {
            if (((Metadata)e.getValue()).getName() != null) {
                return class_2561.method_43470((String)((Metadata)e.getValue()).getName());
            }
            class_5250 id = class_2561.method_43470((String)((String)e.getKey()));
            if (((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).gui.hideMemoryIds) {
                id.method_10862(class_2583.field_24360.method_36141(Boolean.valueOf(true)));
            }
            return id;
        }, (a, b) -> a, LinkedHashMap::new))));
        this.memoryBankList = (StringSelectorWidget)this.method_37063((class_364)new StringSelectorWidget<String>(this.left + 8, this.top + 36, this.menuWidth - 16, this.menuHeight - 36 - 8, class_5244.field_39003, id -> this.openEditScreen(this.afterBankLoaded, (String)id)));
        this.memoryBankList.setHighlight(MemoryBankAccessImpl.INSTANCE.getLoadedInternal().map(MemoryBankImpl::getId).orElse(null));
        this.search.method_1852("");
    }

    private void openCreateScreen(Runnable afterBankLoaded) {
        class_310.method_1551().method_1507((class_437)new CreateMemoryBankScreen(this, afterBankLoaded));
    }

    private void openEditScreen(Runnable afterBankLoaded, @NotNull String bankId) {
        class_310.method_1551().method_1507((class_437)new EditMemoryBankScreen(this, afterBankLoaded, bankId));
    }

    public void method_25419() {
        this.onRemoveScreen.run();
    }
}

