/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_7225;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.impl.ChestTracker;
import red.jackf.chesttracker.impl.config.ChestTrackerConfig;

@Environment(value=EnvType.CLIENT)
public class FileUtil {
    public static final Logger LOGGER = ChestTracker.getLogger("FileUtil");
    private static final Gson GSON_COMPACT = new GsonBuilder().create();
    private static final Gson GSON = GSON_COMPACT.newBuilder().setPrettyPrinting().create();

    public static <T> boolean saveToNbt(T object, Codec<T> codec, Path path, @Nullable class_7225.class_7874 registries) {
        try {
            Object t;
            class_2509 ops = registries == null ? class_2509.field_11560 : registries.method_57093((DynamicOps)class_2509.field_11560);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            DataResult tag = codec.encodeStart((DynamicOps)ops, object);
            if (tag.isError()) {
                throw new IOException("Error encoding to NBT %s".formatted(tag.error().get()));
            }
            if (tag.isSuccess() && (t = tag.result().get()) instanceof class_2487) {
                class_2487 compound = (class_2487)t;
                class_2507.method_30614((class_2487)compound, (Path)path);
                return true;
            }
            throw new IOException("Error encoding to NBT: not a compound tag: %s".formatted(tag.result().get()));
        }
        catch (IOException ex) {
            LOGGER.error("Error saving object", (Throwable)ex);
            return false;
        }
    }

    public static <T> Optional<T> loadFromNbt(Codec<T> codec, Path path, @Nullable class_7225.class_7874 registries) {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try {
                class_2509 ops = registries == null ? class_2509.field_11560 : registries.method_57093((DynamicOps)class_2509.field_11560);
                class_2487 tag = class_2507.method_30613((Path)path, (class_2505)class_2505.method_53898());
                DataResult loaded = codec.decode((DynamicOps)ops, (Object)tag);
                if (loaded.isError()) {
                    throw new IOException("Invalid NBT: %s".formatted(((DataResult.Error)loaded.error().get()).message()));
                }
                return loaded.result().map(Pair::getFirst);
            }
            catch (IOException ex) {
                LOGGER.error("Error loading object at {}", (Object)path, (Object)ex);
                FileUtil.tryMove(path, path.resolveSibling(String.valueOf(path.getFileName()) + ".corrupt"), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return Optional.empty();
    }

    public static void tryMove(Path from, Path to, CopyOption ... options) {
        try {
            Files.move(from, to, options);
        }
        catch (IOException e) {
            LOGGER.error("Error moving %s to %s".formatted(from, to), (Throwable)e);
        }
    }

    public static Gson gson() {
        return ((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).storage.readableJsonMemories ? GSON : GSON_COMPACT;
    }
}

