/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.noiilive.jojowor.network.JojoworModVariables;

public class StandArmRenderer {
    public static void renderArm(PlayerRenderer playerRenderer, AbstractClientPlayer player, PoseStack poseStack, MultiBufferSource buffer, int light, HandType handType) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null) {
            return;
        }
        JojoworModVariables.PlayerVariables vars = (JojoworModVariables.PlayerVariables)player.getData(JojoworModVariables.PLAYER_VARIABLES);
        if (vars == null || !vars.StandPiloting) {
            return;
        }
        if (!"Hierophant Green".equals(vars.PlayerStand)) {
            return;
        }
        String skin = vars.StandSkin != null ? vars.StandSkin.toLowerCase() : "01";
        boolean slim = true;
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)("textures/entities/hand_hierophantgreen_" + skin + ".png"));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        EntityModelSet modelSet = mc.getEntityModels();
        PlayerModel model = new PlayerModel(modelSet.bakeLayer(ModelLayers.PLAYER_SLIM), true);
        PlayerModel base = (PlayerModel)playerRenderer.getModel();
        model.attackTime = base.attackTime;
        model.crouching = base.crouching;
        model.swimAmount = base.swimAmount;
        model.prepareMobModel((LivingEntity)player, 0.0f, 0.0f, 0.0f);
        model.setupAnim((LivingEntity)player, 0.0f, 0.0f, 0.0f, player.getYHeadRot(), player.getXRot());
        if (handType == HandType.RIGHT) {
            model.rightArm.render(poseStack, buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)texture)), light, OverlayTexture.NO_OVERLAY);
            model.rightSleeve.render(poseStack, buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)texture)), light, OverlayTexture.NO_OVERLAY);
        } else {
            model.leftArm.render(poseStack, buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)texture)), light, OverlayTexture.NO_OVERLAY);
            model.leftSleeve.render(poseStack, buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)texture)), light, OverlayTexture.NO_OVERLAY);
        }
    }

    public static enum HandType {
        LEFT,
        RIGHT;

    }
}

