/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.client.renderer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.noiilive.jojowor.entity.HierophantGreenEntity;
import net.noiilive.jojowor.entity.model.HierophantGreenModel;
import net.noiilive.jojowor.network.JojoworModVariables;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.Color;

public class HierophantGreenRenderer
extends GeoEntityRenderer<HierophantGreenEntity> {
    public HierophantGreenRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new HierophantGreenModel());
        this.shadowRadius = 0.0f;
    }

    public ResourceLocation getTextureLocation(HierophantGreenEntity entity) {
        if (entity.overrideTexture != null) {
            return entity.overrideTexture;
        }
        String textureString = entity.getTexture();
        return ResourceLocation.parse((String)("jojowor:textures/entities/" + textureString + ".png"));
    }

    public RenderType getRenderType(HierophantGreenEntity entity, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && entity.getOwnerUUID() != null && entity.getOwnerUUID().equals(player.getUUID()) && Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            boolean piloting;
            JojoworModVariables.PlayerVariables vars = (JojoworModVariables.PlayerVariables)player.getData(JojoworModVariables.PLAYER_VARIABLES);
            boolean bl = piloting = vars != null && vars.StandPiloting;
            if (piloting) {
                return null;
            }
            return RenderType.entityNoOutline((ResourceLocation)this.getTextureLocation(entity));
        }
        return RenderType.entityTranslucentCull((ResourceLocation)this.getTextureLocation(entity));
    }

    public Color getRenderColor(HierophantGreenEntity animatable, float partialTick, int packedLight) {
        float alpha;
        boolean isGuiPreview;
        boolean bl = isGuiPreview = animatable.tickCount == 0 && (animatable.level() == null || animatable.level().getEntity(animatable.getId()) == null);
        if (isGuiPreview) {
            alpha = 1.0f;
        } else {
            LocalPlayer localPlayer = Minecraft.getInstance().player;
            if (localPlayer != null && animatable.getOwnerUUID() != null && animatable.getOwnerUUID().equals(localPlayer.getUUID()) && Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
                JojoworModVariables.PlayerVariables vars = (JojoworModVariables.PlayerVariables)localPlayer.getData(JojoworModVariables.PLAYER_VARIABLES);
                boolean piloting = vars != null && vars.StandPiloting;
                alpha = piloting ? 0.0f : 0.2f;
            } else {
                Player owner;
                LivingEntity ownerEntity = animatable.getOwner();
                Player player = owner = ownerEntity instanceof Player ? (Player)ownerEntity : null;
                if (owner != null) {
                    JojoworModVariables.PlayerVariables vars = (JojoworModVariables.PlayerVariables)owner.getData(JojoworModVariables.PLAYER_VARIABLES);
                    if (vars != null && vars.StandPiloting) {
                        double maxRadius;
                        double dz;
                        double dy;
                        double dx = animatable.getX() - vars.PilotX;
                        double distance = Math.sqrt(dx * dx + (dy = animatable.getY() - vars.PilotY) * dy + (dz = animatable.getZ() - vars.PilotZ) * dz);
                        if (distance <= (maxRadius = 25.0 + vars.StandPrecision * 0.75) * 0.5) {
                            alpha = 1.0f;
                        } else if (distance >= maxRadius) {
                            alpha = 0.1f;
                        } else {
                            double factor = (distance - maxRadius * 0.5) / (maxRadius * 0.5);
                            alpha = (float)(1.0 - factor * 0.9);
                        }
                    } else {
                        alpha = animatable.getFadeAlpha();
                    }
                } else {
                    alpha = animatable.getFadeAlpha();
                }
            }
        }
        int alphaInt = (int)(alpha * 255.0f);
        int argb = alphaInt << 24 | 0xFF0000 | 0xFF00 | 0xFF;
        return new Color(argb);
    }

    public boolean shouldRender(HierophantGreenEntity entity, Frustum frustum, double x, double y, double z) {
        JojoworModVariables.PlayerVariables vars;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && (vars = (JojoworModVariables.PlayerVariables)player.getData(JojoworModVariables.PLAYER_VARIABLES)) != null) {
            boolean piloting;
            boolean bl = piloting = vars.StandPiloting && entity.getOwnerUUID() != null && entity.getOwnerUUID().equals(player.getUUID());
            if (piloting && Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
                return false;
            }
            if ("None".equals(vars.PlayerStand)) {
                return false;
            }
        }
        return super.shouldRender((Entity)entity, frustum, x, y, z);
    }
}

