/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.noiilive.jojowor.potion.BleedMobEffect;
import net.noiilive.jojowor.potion.GreatestHighMobEffect;
import net.noiilive.jojowor.potion.NoFallMobEffect;
import net.noiilive.jojowor.potion.StunMobEffect;
import net.noiilive.jojowor.potion.TimestopMovementMobEffect;
import net.noiilive.jojowor.procedures.TimestopMovementEndProcedure;

@EventBusSubscriber
public class JojoworModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"jojowor");
    public static final DeferredHolder<MobEffect, MobEffect> STUN = REGISTRY.register("stun", () -> new StunMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BLEED = REGISTRY.register("bleed", () -> new BleedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> NO_FALL = REGISTRY.register("no_fall", () -> new NoFallMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> GREATEST_HIGH = REGISTRY.register("greatest_high", () -> new GreatestHighMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> TIMESTOP_MOVEMENT = REGISTRY.register("timestop_movement", () -> new TimestopMovementMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            JojoworModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            JojoworModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(TIMESTOP_MOVEMENT)) {
            TimestopMovementEndProcedure.execute(entity);
        }
    }
}

