/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.noiilive.jojowor.JojoworMod;
import net.noiilive.jojowor.procedures.UseEmote1Procedure;
import net.noiilive.jojowor.procedures.UseEmote2Procedure;
import net.noiilive.jojowor.procedures.UseEmote3Procedure;
import net.noiilive.jojowor.procedures.UseEmote4Procedure;
import net.noiilive.jojowor.procedures.UseEmote5Procedure;
import net.noiilive.jojowor.procedures.UseEmote6Procedure;
import net.noiilive.jojowor.procedures.UseEmote7Procedure;
import net.noiilive.jojowor.procedures.UseEmote8Procedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record EmoteWheelButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EmoteWheelButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)"emote_wheel_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, EmoteWheelButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new EmoteWheelButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<EmoteWheelButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(EmoteWheelButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> EmoteWheelButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            UseEmote1Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            UseEmote2Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            UseEmote3Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            UseEmote4Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            UseEmote5Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 5) {
            UseEmote6Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            UseEmote7Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 7) {
            UseEmote8Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        JojoworMod.addNetworkMessage(TYPE, STREAM_CODEC, EmoteWheelButtonMessage::handleData);
    }
}

