/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.api.items;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.yfrostyf.toxony.api.tox.ToxData;
import xyz.yfrostyf.toxony.items.weapons.WitchingBladeItem;
import xyz.yfrostyf.toxony.network.SyncToxPacket;
import xyz.yfrostyf.toxony.registries.DataAttachmentRegistry;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;

public class ToxFueledItem
extends Item {
    protected int tickrate;
    protected int cooldown;
    protected SoundEvent sound;

    public ToxFueledItem(Item.Properties properties, int tickrate, int cooldown, SoundEvent sound) {
        super(properties.stacksTo(1).component((DataComponentType)DataComponentsRegistry.ACTIVE.get(), (Object)false));
        this.cooldown = cooldown;
        this.tickrate = tickrate;
        this.sound = sound;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer svplayer = (ServerPlayer)entity;
        if (!stack.has(DataComponentsRegistry.ACTIVE)) {
            return;
        }
        if (level.getServer().getTickCount() % this.tickrate != 0) {
            return;
        }
        ToxData plyToxData = (ToxData)entity.getData(DataAttachmentRegistry.TOX_DATA);
        if (plyToxData.getTox() > 0.0f && ToxFueledItem.isActive(stack) && !plyToxData.getDeathState()) {
            plyToxData.addTox(-1.0f);
            PacketDistributor.sendToPlayer((ServerPlayer)svplayer, (CustomPacketPayload)SyncToxPacket.create(plyToxData.getTox()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            stack.set(DataComponentsRegistry.ACTIVE, (Object)false);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        ToxData plyToxData = (ToxData)player.getData(DataAttachmentRegistry.TOX_DATA);
        if (!player.getCooldowns().isOnCooldown((Item)this)) {
            if (!ToxFueledItem.isActive(itemstack) && plyToxData.getTox() > 10.0f) {
                player.playSound(this.sound, 1.0f, 1.0f);
                itemstack.set(DataComponentsRegistry.ACTIVE, (Object)true);
            } else {
                itemstack.set(DataComponentsRegistry.ACTIVE, (Object)false);
            }
            player.getCooldowns().addCooldown((Item)this, this.cooldown);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    public static boolean isActive(ItemStack itemStack) {
        return itemStack.has(DataComponentsRegistry.ACTIVE) && (Boolean)itemStack.get(DataComponentsRegistry.ACTIVE) != false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected Item.Properties properties = new Item.Properties();
        protected int tickrate = 40;
        protected int cooldown = 60;
        protected SoundEvent sound = SoundEvents.BREWING_STAND_BREW;

        public Builder properties(Item.Properties properties) {
            this.properties = properties;
            return this;
        }

        public Builder tickrate(int tickrate) {
            this.tickrate = tickrate;
            return this;
        }

        public Builder cooldown(int cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder sound(SoundEvent sound) {
            this.sound = sound;
            return this;
        }

        public ToxFueledItem build() {
            return new WitchingBladeItem(this.properties, this.tickrate, this.cooldown, this.sound);
        }
    }
}

