/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.api.items;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import xyz.yfrostyf.toxony.api.affinity.Affinity;
import xyz.yfrostyf.toxony.api.tox.ToxData;
import xyz.yfrostyf.toxony.api.util.AffinityUtil;
import xyz.yfrostyf.toxony.api.util.ToxUtil;
import xyz.yfrostyf.toxony.registries.DataAttachmentRegistry;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;

public class ToxGiverBlockItem
extends BlockItem {
    protected final float tox;
    protected final float tolerance;
    protected final float tier;
    protected final Supplier<ItemStack> returnItem;
    protected final List<MobEffectInstance> mobEffectInstances;
    protected static final int EAT_DURATION = 32;

    public ToxGiverBlockItem(Block block, Item.Properties properties, float tox, float tolerance, int tier, Supplier<ItemStack> returnItem, List<MobEffectInstance> mobEffectInstances) {
        super(block, properties);
        this.tox = tox;
        this.tolerance = tolerance;
        this.tier = tier;
        this.returnItem = returnItem;
        this.mobEffectInstances = mobEffectInstances;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        ToxData plyToxData = (ToxData)player.getData(DataAttachmentRegistry.TOX_DATA);
        if (stack.has(DataComponentsRegistry.POSSIBLE_AFFINITIES)) {
            Affinity affinity = AffinityUtil.readAffinityFromIngredientMap(stack, level);
            AffinityUtil.addAffinityByItem(plyToxData, stack, affinity, 1);
        }
        plyToxData.addTox(this.tox);
        ToxUtil.addToleranceWithTier(player, plyToxData, this.tolerance, this.tier, level);
        if (level instanceof ServerLevel) {
            ServerLevel svlevel = (ServerLevel)level;
            this.mobEffectInstances.forEach(mobEffectInstance -> {
                Holder effect = mobEffectInstance.getEffect();
                int oldDuration = 0;
                if (player.hasEffect(effect) && !((MobEffect)effect.value()).isInstantenous()) {
                    oldDuration = player.getEffect(effect).getDuration();
                }
                if (((MobEffect)effect.value()).isInstantenous()) {
                    ((MobEffect)mobEffectInstance.getEffect().value()).applyInstantenousEffect((Entity)player, (Entity)player, entity, mobEffectInstance.getAmplifier(), 1.0);
                } else {
                    player.addEffect(new MobEffectInstance(effect, mobEffectInstance.getDuration() + oldDuration, mobEffectInstance.getAmplifier()));
                }
            });
        }
        return ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)this.returnItem.get());
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    public SoundEvent getEatingSound() {
        return SoundEvents.GENERIC_EAT;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected Block block = Blocks.AIR;
        protected Item.Properties properties = new Item.Properties();
        protected int tox = 0;
        protected int tolerance = 0;
        protected int tier = 0;
        protected Supplier<ItemStack> returnItem = () -> new ItemStack((ItemLike)Items.AIR);
        protected List<MobEffectInstance> mobEffectInstances = new ArrayList<MobEffectInstance>();

        public Builder block(Holder<Block> block) {
            this.block = (Block)block.value();
            return this;
        }

        public Builder properties(Item.Properties properties) {
            this.properties = properties;
            return this;
        }

        public Builder tox(int tox) {
            this.tox = tox;
            return this;
        }

        public Builder tolerance(int tolerance) {
            this.tolerance = tolerance;
            return this;
        }

        public Builder tier(int tier) {
            this.tier = tier;
            return this;
        }

        public Builder effect(MobEffectInstance mobEffectInstance) {
            this.mobEffectInstances.add(mobEffectInstance);
            return this;
        }

        public Builder effects(List<MobEffectInstance> mobEffectInstances) {
            this.mobEffectInstances.addAll(mobEffectInstances);
            return this;
        }

        public Builder returnItem(Supplier<ItemStack> returnItem) {
            this.returnItem = returnItem;
            return this;
        }

        public ToxGiverBlockItem build() {
            return new ToxGiverBlockItem(this.block, this.properties, this.tox, this.tolerance, this.tier, this.returnItem, this.mobEffectInstances);
        }
    }
}

