/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.api.mutagens;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class MutagenData {
    Map<String, Boolean> booleanMap = new HashMap<String, Boolean>();
    Map<String, Integer> integerMap = new HashMap<String, Integer>();

    public MutagenData() {
    }

    public MutagenData(Map<String, Boolean> booleanMap, Map<String, Integer> integerMap) {
        this.booleanMap = booleanMap;
        this.integerMap = integerMap;
    }

    public Map<String, Boolean> getBooleanMap() {
        return this.booleanMap;
    }

    public Map<String, Integer> getIntegerMap() {
        return this.integerMap;
    }

    public boolean addBool(String name, boolean value) {
        if (this.booleanMap.containsKey(name)) {
            this.booleanMap.replace(name, value);
            return false;
        }
        this.booleanMap.put(name, value);
        return true;
    }

    public boolean addInt(String name, int value) {
        if (this.integerMap.containsKey(name)) {
            this.integerMap.replace(name, value);
            return false;
        }
        this.integerMap.put(name, value);
        return true;
    }

    public boolean remove(String name) {
        if (this.booleanMap.containsKey(name)) {
            this.booleanMap.remove(name);
            return true;
        }
        if (this.integerMap.containsKey(name)) {
            this.integerMap.remove(name);
            return true;
        }
        return false;
    }

    public boolean getBool(String name) {
        if (this.booleanMap.containsKey(name)) {
            return this.booleanMap.get(name);
        }
        return false;
    }

    public int getInt(String name) {
        if (this.integerMap.containsKey(name)) {
            return this.integerMap.get(name);
        }
        return -1;
    }

    public void saveNBTData(CompoundTag compound, HolderLookup.Provider provider) {
        ListTag boolKeyList = new ListTag();
        ListTag boolValueList = new ListTag();
        ListTag intKeyList = new ListTag();
        ListTag intValueList = new ListTag();
        for (Map.Entry<String, Boolean> entry : this.booleanMap.entrySet()) {
            boolKeyList.add((Object)StringTag.valueOf((String)entry.getKey()));
            boolValueList.add((Object)ByteTag.valueOf((boolean)entry.getValue()));
        }
        for (Map.Entry<String, Comparable<Boolean>> entry : this.integerMap.entrySet()) {
            intKeyList.add((Object)StringTag.valueOf((String)entry.getKey()));
            intValueList.add((Object)IntTag.valueOf((int)((Integer)entry.getValue())));
        }
        compound.put("mutagen_bool_key_list", (Tag)boolKeyList);
        compound.put("mutagen_bool_value_list", (Tag)boolValueList);
        compound.put("mutagen_int_key_list", (Tag)intKeyList);
        compound.put("mutagen_int_value_list", (Tag)intValueList);
    }

    public void loadNBTData(CompoundTag compound, HolderLookup.Provider provider) {
        int i;
        ListTag boolKeyList = compound.getList("mutagen_bool_key_list", 8);
        ListTag boolValueList = compound.getList("mutagen_bool_value_list", 1);
        ListTag intKeyList = compound.getList("mutagen_int_key_list", 8);
        ListTag intValueList = compound.getList("mutagen_int_value_list", 3);
        this.booleanMap = new HashMap<String, Boolean>();
        for (i = 0; i < boolKeyList.size(); ++i) {
            this.booleanMap.put(boolKeyList.getString(i), boolValueList.getInt(i) != 0);
        }
        this.integerMap = new HashMap<String, Integer>();
        for (i = 0; i < intKeyList.size(); ++i) {
            this.integerMap.put(intKeyList.getString(i), intValueList.getInt(i));
        }
    }
}

