/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.api.oils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import xyz.yfrostyf.toxony.ToxonyConfig;
import xyz.yfrostyf.toxony.api.oils.Oil;
import xyz.yfrostyf.toxony.api.registries.ToxonyRegistries;
import xyz.yfrostyf.toxony.registries.OilsRegistry;

public record ItemOil(Holder<Oil> oil, int duration, int amplifier, int maxUses, boolean showInTooltip) implements TooltipProvider
{
    public static final ItemOil EMPTY = new ItemOil(null, 0, 0, 0, false);
    public static final Codec<ItemOil> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ToxonyRegistries.OIL_REGISTRY.holderByNameCodec().fieldOf("oil").forGetter(ItemOil::oil), (App)Codec.INT.fieldOf("duration").forGetter(ItemOil::duration), (App)Codec.INT.fieldOf("amplifier").forGetter(ItemOil::amplifier), (App)Codec.INT.fieldOf("max_uses").forGetter(ItemOil::maxUses), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(ItemOil::showInTooltip)).apply((Applicative)instance, ItemOil::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemOil> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holder((ResourceKey)OilsRegistry.OILS.getRegistryKey(), Oil.STREAM_CODEC), ItemOil::oil, (StreamCodec)ByteBufCodecs.INT, ItemOil::duration, (StreamCodec)ByteBufCodecs.VAR_INT, ItemOil::amplifier, (StreamCodec)ByteBufCodecs.INT, ItemOil::maxUses, (StreamCodec)ByteBufCodecs.BOOL, ItemOil::showInTooltip, ItemOil::new);

    public static ItemOil createItemOil(Holder<Oil> oil, int duration, int amplifier, int maxUses, boolean showInTooltip) {
        return new ItemOil(oil, duration, amplifier, maxUses, showInTooltip);
    }

    public static ItemOil createItemOil(Holder<Oil> oil, int duration, int amplifier, int maxUses) {
        return new ItemOil(oil, duration, amplifier, maxUses, false);
    }

    public static ItemOil createItemOil(Holder<Oil> oil, int duration, int amplifier) {
        return new ItemOil(oil, duration, amplifier, -1, false);
    }

    public int getMaxUses() {
        return Mth.floor((double)((double)this.maxUses * (Double)ToxonyConfig.OIL_DURABILITY_MULT.get()));
    }

    public Oil getOil() {
        return (Oil)this.oil.value();
    }

    public boolean isEmpty() {
        return this.oil == null;
    }

    public ItemOil copy() {
        return new ItemOil(this.oil, this.duration, this.amplifier, this.maxUses, this.showInTooltip);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.oil, this.showInTooltip);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ItemOil)) return false;
        ItemOil compare = (ItemOil)obj;
        if (!this.oil.equals(compare.oil)) return false;
        return true;
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
    }
}

