/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.api.oils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import xyz.yfrostyf.toxony.api.oils.ItemOil;

public class Oil {
    public static final Oil EMPTY = new Oil((Component)Component.empty(), (HolderSet<Item>)HolderSet.empty(), List.of());
    public static final Codec<Oil> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.fieldOf("description").forGetter(Oil::getDescription), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM).fieldOf("supported_items").forGetter(Oil::getSupportedItems), (App)MobEffect.CODEC.listOf().fieldOf("effects").forGetter(Oil::getEffects)).apply((Applicative)instance, Oil::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Oil> STREAM_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.STREAM_CODEC, Oil::getDescription, (StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.ITEM), Oil::getSupportedItems, (StreamCodec)MobEffect.STREAM_CODEC.apply(ByteBufCodecs.list()), Oil::getEffects, Oil::new);
    protected Component description;
    protected HolderSet<Item> supportedItems;
    protected List<Holder<MobEffect>> effects;

    public Oil(Component description, HolderSet<Item> supportedItems, List<Holder<MobEffect>> effects) {
        this.description = description;
        this.supportedItems = supportedItems;
        this.effects = effects;
    }

    public Component getDescription() {
        return this.description;
    }

    public HolderSet<Item> getSupportedItems() {
        return this.supportedItems;
    }

    public List<Holder<MobEffect>> getEffects() {
        return this.effects;
    }

    public boolean canOil(ItemStack stack) {
        return this.supportedItems.contains(stack.getItemHolder());
    }

    public void applyOil(ItemOil itemOil, LivingEntity attacker, LivingEntity victim, Level level) {
        for (Holder<MobEffect> effect : this.effects) {
            if (((MobEffect)effect.value()).isInstantenous()) {
                ((MobEffect)effect.value()).applyInstantenousEffect((Entity)attacker, (Entity)attacker, victim, itemOil.amplifier(), 1.0);
                continue;
            }
            if (victim.hasEffect(effect)) continue;
            MobEffectInstance effectInstance = new MobEffectInstance(effect, itemOil.duration(), itemOil.amplifier());
            victim.addEffect(effectInstance, (Entity)attacker);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Oil)) return false;
        Oil oil = (Oil)obj;
        if (this.getDescription() != oil.getDescription()) return false;
        return true;
    }
}

