/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.api.tox;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import xyz.yfrostyf.toxony.ToxonyConfig;
import xyz.yfrostyf.toxony.api.affinity.Affinity;
import xyz.yfrostyf.toxony.api.events.ChangeThresholdEvent;
import xyz.yfrostyf.toxony.api.events.ChangeToleranceEvent;
import xyz.yfrostyf.toxony.api.events.ChangeToxEvent;
import xyz.yfrostyf.toxony.api.mutagens.MutagenEffect;
import xyz.yfrostyf.toxony.api.registries.ToxonyRegistries;
import xyz.yfrostyf.toxony.api.util.ToxUtil;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

public class ToxData {
    public static final StreamCodec<RegistryFriendlyByteBuf, ToxData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ToxData>(){

        public ToxData decode(RegistryFriendlyByteBuf buf) {
            Float t1 = (Float)ByteBufCodecs.FLOAT.decode((Object)buf);
            Float t2 = (Float)ByteBufCodecs.FLOAT.decode((Object)buf);
            int t3 = (Integer)ByteBufCodecs.INT.decode((Object)buf);
            Map t4 = (Map)ByteBufCodecs.map(HashMap::new, Affinity.STREAM_CODEC, (StreamCodec)ByteBufCodecs.INT).decode((Object)buf);
            List t5 = (List)MobEffect.STREAM_CODEC.apply(ByteBufCodecs.list()).decode((Object)buf);
            Map t6 = (Map)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)ByteBufCodecs.INT).decode((Object)buf);
            boolean t7 = (Boolean)ByteBufCodecs.BOOL.decode((Object)buf);
            return new ToxData(t1.floatValue(), t2.floatValue(), t3, t4, t5, t6, t7);
        }

        public void encode(RegistryFriendlyByteBuf buf, ToxData toxData) {
            ByteBufCodecs.FLOAT.encode((Object)buf, (Object)Float.valueOf(toxData.getTox()));
            ByteBufCodecs.FLOAT.encode((Object)buf, (Object)Float.valueOf(toxData.getTolerance()));
            ByteBufCodecs.INT.encode((Object)buf, (Object)toxData.getThreshold());
            ByteBufCodecs.map(HashMap::new, Affinity.STREAM_CODEC, (StreamCodec)ByteBufCodecs.INT).encode((Object)buf, (Object)((HashMap)toxData.getAffinities()));
            MobEffect.STREAM_CODEC.apply(ByteBufCodecs.list()).encode((Object)buf, toxData.getMutagens());
            ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)ByteBufCodecs.INT).encode((Object)buf, (Object)((HashMap)toxData.getKnownIngredients()));
            ByteBufCodecs.BOOL.encode((Object)buf, (Object)toxData.getDeathState());
        }
    };
    public static final int MAX_TOLERANCE = 999;
    public static final int MAX_MUTAGENS = 3;
    public static final int MIN_TOLERANCE = 10;
    public static final int DEFAULT_TOLERANCE = 30;
    public static final int THRESHOLD_MULTIPLIER = 100;
    public static int MINIMUM_KNOW = 20;
    @Nullable
    private Player player;
    private float tox = 0.0f;
    private float tolerance = 30.0f;
    private int threshold = 0;
    private Map<Affinity, Integer> affinities = new HashMap<Affinity, Integer>(20);
    private List<Holder<MobEffect>> mutagens = new ArrayList<Holder<MobEffect>>(3);
    private Map<ResourceLocation, Integer> knownIngredients = new HashMap<ResourceLocation, Integer>(30);
    private boolean deathState = false;
    private float thresholdTolGoal = 100.0f;

    public ToxData(Player player) {
        this.player = player;
    }

    private ToxData(float tox, float tolerance, int threshold, Map<Affinity, Integer> affinities, List<Holder<MobEffect>> mutagens, Map<ResourceLocation, Integer> knownIngredients, boolean deathState) {
        this.tox = tox;
        this.tolerance = tolerance;
        this.threshold = threshold;
        this.affinities = affinities;
        this.mutagens = mutagens;
        this.knownIngredients = knownIngredients;
        this.deathState = deathState;
        MINIMUM_KNOW = (Integer)ToxonyConfig.MIN_KNOWLEDGE_REQ.get();
        knownIngredients.put(ItemRegistry.COLD_SUBSTANCE.getId(), MINIMUM_KNOW);
        knownIngredients.put(ItemRegistry.HEAT_SUBSTANCE.getId(), MINIMUM_KNOW);
        knownIngredients.put(ItemRegistry.DECAY_SUBSTANCE.getId(), MINIMUM_KNOW);
        knownIngredients.put(ItemRegistry.FOREST_SUBSTANCE.getId(), MINIMUM_KNOW);
        knownIngredients.put(ItemRegistry.OCEAN_SUBSTANCE.getId(), MINIMUM_KNOW);
        knownIngredients.put(ItemRegistry.NETHER_SUBSTANCE.getId(), MINIMUM_KNOW);
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleSyncedToxData(float tox, float tolerance, int threshold, Map<Affinity, Integer> affinities, List<Holder<MobEffect>> mutagens, Map<ResourceLocation, Integer> knownIngredients, boolean deathState) {
        this.setToxSynced(tox);
        this.setToleranceSynced(tolerance);
        this.setThresholdSynced(threshold);
        this.setAffinities(affinities);
        this.setMutagens(mutagens);
        this.knownIngredients = knownIngredients;
        this.setDeathState(deathState);
    }

    public float getTox() {
        return this.tox;
    }

    public void setToxSynced(float inTox) {
        if (inTox > this.tolerance) {
            this.tox = this.tolerance;
            this.setDeathState(true);
        } else if (inTox <= 0.0f) {
            this.tox = 0.0f;
            this.resetThreshold();
            this.clearMutagens();
        } else {
            this.tox = inTox;
        }
        while (this.tox > this.thresholdTolGoal) {
            this.setThresholdSynced(this.threshold + 1);
        }
    }

    public void setTox(float inTox) {
        ChangeToxEvent event = new ChangeToxEvent((LivingEntity)this.player, this, this.tox, inTox);
        if (((ChangeToxEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            return;
        }
        if (event.getNewTox() > this.tolerance) {
            event.setNewTox(this.tolerance);
            this.setDeathState(true);
        } else if (event.getNewTox() <= 0.0f) {
            event.setNewTox(0.0f);
            this.resetThreshold();
        }
        this.tox = event.getNewTox();
        while (this.tox > this.thresholdTolGoal) {
            this.setThreshold(this.threshold + 1);
        }
    }

    public void addTox(float inTox) {
        this.setTox(this.tox + inTox);
    }

    public float getTolerance() {
        return this.tolerance;
    }

    private void setToleranceSynced(float inTolerance) {
        this.tolerance = inTolerance > 999.0f ? 999.0f : (inTolerance < 10.0f ? 10.0f : inTolerance);
    }

    public void setTolerance(float inTolerance) {
        ChangeToleranceEvent event = new ChangeToleranceEvent((LivingEntity)this.player, this, this.tox, inTolerance);
        if (((ChangeToleranceEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            return;
        }
        if (event.getNewTolerance() > 999.0f) {
            event.setNewTolerance(999.0f);
        }
        if (event.getNewTolerance() < 10.0f) {
            event.setNewTolerance(10.0f);
        }
        this.tolerance = event.getNewTolerance();
    }

    public void addTolerance(float inTolerance) {
        this.setTolerance(this.tolerance + inTolerance);
    }

    public int getThreshold() {
        return this.threshold;
    }

    public float getThresholdTolGoal() {
        return this.thresholdTolGoal;
    }

    private void setThresholdSynced(int inThreshold) {
        this.threshold = inThreshold;
        this.thresholdTolGoal = ToxUtil.TriangularNumbersMult(this.threshold, 100.0f);
    }

    public void setThreshold(int inThreshold) {
        ChangeThresholdEvent event = new ChangeThresholdEvent((LivingEntity)this.player, this, this.threshold, inThreshold);
        if (((ChangeThresholdEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            return;
        }
        this.threshold = event.getNewThreshold();
        this.thresholdTolGoal = ToxUtil.TriangularNumbersMult(this.threshold, 100.0f);
    }

    public void resetThreshold() {
        this.threshold = 0;
        this.thresholdTolGoal = 100.0f;
    }

    public void setDeathState(boolean setState) {
        this.deathState = setState;
    }

    public boolean getDeathState() {
        return this.deathState;
    }

    public List<Holder<MobEffect>> getMutagens() {
        return this.mutagens;
    }

    public void addMutagen(Holder<MobEffect> effect) {
        if (this.mutagens.size() == 3) {
            this.mutagens.remove(0);
        }
        this.mutagens.add(effect);
    }

    public void setMutagens(List<Holder<MobEffect>> mutagens) {
        this.mutagens = mutagens;
        this.applyMutagens();
    }

    public void applyMutagens() {
        ArrayList activeEffects = new ArrayList(this.player.getActiveEffects());
        for (MobEffectInstance mobEffectInstance : activeEffects) {
            Object object = mobEffectInstance.getEffect().value();
            if (!(object instanceof MutagenEffect)) continue;
            MutagenEffect effect = (MutagenEffect)((Object)object);
            effect.removeModifiers((LivingEntity)this.player);
            this.player.removeEffect(mobEffectInstance.getEffect());
        }
        for (Holder holder : this.mutagens) {
            ToxUtil.applyMutagenEffect((LivingEntity)this.player, (Holder<MobEffect>)BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)holder.value())));
        }
    }

    public void addAndApplyMutagens(Iterable<Holder<MobEffect>> effects) {
        for (Holder<MobEffect> effect : effects) {
            this.addMutagen(effect);
        }
        this.applyMutagens();
    }

    public void clearMutagens() {
        this.mutagens.clear();
        this.applyMutagens();
    }

    public Map<Affinity, Integer> getAffinities() {
        return this.affinities;
    }

    public void setAffinities(Map<Affinity, Integer> affinities) {
        this.affinities = affinities;
    }

    public Integer getAffinityAmount(Affinity affinity) {
        if (!this.haveAffinity(affinity)) {
            return -1;
        }
        return this.affinities.get(affinity);
    }

    public void setAffinity(Affinity affinity, int value) {
        if (!this.haveAffinity(affinity)) {
            this.affinities.put(affinity, value);
            return;
        }
        this.affinities.replace(affinity, value);
    }

    public void addAffinity(Affinity affinity, int value) {
        if (!this.haveAffinity(affinity)) {
            this.affinities.put(affinity, value);
            return;
        }
        this.setAffinity(affinity, this.affinities.get(affinity) + value);
    }

    public void clearAffinities() {
        this.affinities.clear();
    }

    public boolean haveAffinity(Affinity affinity) {
        return this.affinities.containsKey(affinity);
    }

    public void addKnownIngredients(ItemStack itemstack) {
        this.addKnownIngredients(itemstack, 1);
    }

    public void addKnownIngredients(ItemStack itemstack, int amount) {
        ResourceLocation resourceLocation = itemstack.getItemHolder().getKey().location();
        this.knownIngredients.merge(resourceLocation, amount, (oldV, newV) -> {
            if (oldV <= MINIMUM_KNOW) {
                return oldV + newV;
            }
            return oldV;
        });
    }

    public Map<ResourceLocation, Integer> getKnownIngredients() {
        return this.knownIngredients;
    }

    public int getIngredientProgress(ItemStack itemstack) {
        ResourceLocation location = itemstack.getItemHolder().getKey().location();
        return this.knownIngredients.getOrDefault(location, 0);
    }

    private boolean hasKnownIngredient(ItemStack itemstack) {
        return this.knownIngredients.containsKey(itemstack.getItemHolder().getKey().location());
    }

    public void clearKnownIngredients() {
        this.knownIngredients.clear();
    }

    public boolean knowsIngredient(ItemStack itemstack) {
        if (!this.hasKnownIngredient(itemstack)) {
            return false;
        }
        return this.knownIngredients.get(itemstack.getItemHolder().getKey().location()) >= MINIMUM_KNOW;
    }

    public boolean knowsIngredient(Holder<Item> holder) {
        if (!this.hasKnownIngredient(new ItemStack(holder))) {
            return false;
        }
        return this.knownIngredients.get(holder.getKey().location()) >= MINIMUM_KNOW;
    }

    public void saveNBTData(CompoundTag compound, HolderLookup.Provider provider) {
        compound.putInt("tox", (int)this.tox);
        compound.putInt("tolerance", (int)this.tolerance);
        compound.putInt("threshold", this.threshold);
        ListTag affinityStringsList = new ListTag();
        ArrayList<Integer> affinityValuesList = new ArrayList<Integer>();
        for (Affinity affinity : this.affinities.keySet()) {
            affinityStringsList.add((Object)StringTag.valueOf((String)ToxonyRegistries.AFFINITY_REGISTRY.holders().filter(ref -> ((Affinity)ref.value()).equals(affinity)).findFirst().get().getKey().location().toString()));
            affinityValuesList.add(this.affinities.get(affinity));
        }
        ListTag mutagenStringList = new ListTag();
        for (Holder<MobEffect> holder : this.mutagens) {
            mutagenStringList.add((Object)StringTag.valueOf((String)BuiltInRegistries.MOB_EFFECT.holders().filter(ref -> Objects.equals(ref.value(), effect.value())).findFirst().get().getKey().location().toString()));
        }
        ListTag listTag = new ListTag();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (ResourceLocation resourceLocation : this.knownIngredients.keySet()) {
            listTag.add((Object)StringTag.valueOf((String)resourceLocation.toString()));
            arrayList.add(this.knownIngredients.get(resourceLocation));
        }
        compound.put("affinities", (Tag)affinityStringsList);
        compound.putIntArray("affinity_values", affinityValuesList);
        compound.put("mutagens", (Tag)mutagenStringList);
        compound.put("known_ingredients", (Tag)listTag);
        compound.putIntArray("known_ingredients_values", arrayList);
        compound.putBoolean("deathState", this.deathState);
    }

    public void loadNBTData(CompoundTag compound, HolderLookup.Provider provider) {
        this.tox = compound.getInt("tox");
        this.tolerance = compound.getInt("tolerance");
        this.threshold = compound.getInt("threshold");
        this.thresholdTolGoal = ToxUtil.TriangularNumbersMult(this.threshold, 100.0f);
        ListTag affinityStringsList = compound.getList("affinities", 8);
        int[] affinityValues = compound.getIntArray("affinity_values");
        ListTag mutagenStringList = compound.getList("mutagens", 8);
        ListTag ingredientsStringsList = compound.getList("known_ingredients", 8);
        int[] ingredientsValuesList = compound.getIntArray("known_ingredients_values");
        HashMap<Affinity, Integer> readAffinityMap = new HashMap<Affinity, Integer>();
        for (int i = 0; i < affinityStringsList.size(); ++i) {
            Affinity in = (Affinity)ToxonyRegistries.AFFINITY_REGISTRY.get(ResourceLocation.parse((String)affinityStringsList.getString(i)));
            assert (in != null);
            readAffinityMap.put(in, affinityValues[i]);
        }
        ArrayList<Holder<MobEffect>> mutagensList = new ArrayList<Holder<MobEffect>>();
        for (int i = 0; i < mutagenStringList.size(); ++i) {
            Holder in = (Holder)BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)mutagenStringList.getString(i))).get();
            mutagensList.add(in);
        }
        HashMap<ResourceLocation, Integer> readIngredientsMap = new HashMap<ResourceLocation, Integer>();
        for (int i = 0; i < ingredientsStringsList.size(); ++i) {
            readIngredientsMap.put(ResourceLocation.parse((String)ingredientsStringsList.getString(i)), ingredientsValuesList[i]);
        }
        this.affinities = readAffinityMap;
        this.mutagens = mutagensList;
        this.knownIngredients = readIngredientsMap;
        this.deathState = compound.getBoolean("deathState");
    }

    public String toString() {
        return "tox: " + this.tox + "\ntolerance: " + this.tolerance + "\nthreshold: " + this.threshold + "\naffinities: " + String.valueOf(this.affinities) + "\nknownIngredients: " + String.valueOf(this.knownIngredients) + "\ndeathstate: " + this.deathState + "\n";
    }
}

