/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.api.util;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;

public class CompatibilityUtil {
    public static final String VAMPIRISM = "vampirism";
    public static final TagKey<EntityType<?>> VAMPIRE = CompatibilityUtil.entityTag("vampirism", "vampire");
    public static final String WEREWOLVES = "werewolves";
    public static final TagKey<EntityType<?>> WEREWOLF = CompatibilityUtil.entityTag("werewolves", "werewolf");
    public static final String IRON_SPELLS = "irons_spellbooks";

    public static boolean isModLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    public static float modifyDamageFromSilver(Entity entity, float damage) {
        float modifiedDamage = damage;
        if (entity.getType().is(VAMPIRE) || entity.getType().is(WEREWOLF)) {
            modifiedDamage *= 1.5f;
        }
        return modifiedDamage;
    }

    public static Optional<Holder.Reference<Attribute>> getModAttribute(Level level, String modid, String path) {
        if (ModList.get().isLoaded(modid)) {
            return level.registryAccess().registryOrThrow(Registries.ATTRIBUTE).getHolder(ResourceLocation.fromNamespaceAndPath((String)modid, (String)path));
        }
        return Optional.empty();
    }

    public static TagKey<EntityType<?>> entityTag(String id, String name) {
        return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)id, (String)name));
    }
}

