/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.api.util;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import xyz.yfrostyf.toxony.api.oils.ItemOil;
import xyz.yfrostyf.toxony.items.BoltItem;
import xyz.yfrostyf.toxony.items.OilPotItem;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;

public class OilUtil {
    public static void useOil(Level level, ItemStack stack, int amount) {
        if (!OilUtil.hasOil(stack) || level == null) {
            return;
        }
        int curOilUses = (Integer)stack.getOrDefault(DataComponentsRegistry.OIL_USES, (Object)0);
        int maxOilUses = ((ItemOil)stack.get(DataComponentsRegistry.OIL)).getMaxUses();
        if ((Integer)stack.set(DataComponentsRegistry.OIL_USES, (Object)(curOilUses + amount)) >= maxOilUses) {
            if (!level.isClientSide()) {
                OilUtil.removeOil(stack);
            } else {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.toxony.oil.empty"), false);
            }
        }
    }

    public static ItemOil updateOil(ItemStack stack, ItemOil oil) {
        ItemOil itemoil = (ItemOil)stack.getOrDefault(DataComponentsRegistry.OIL, (Object)ItemOil.EMPTY);
        if (itemoil.isEmpty()) {
            return OilUtil.setOil(stack, oil);
        }
        ItemOil newItemOil = oil.copy();
        stack.set(DataComponentsRegistry.OIL, (Object)newItemOil);
        stack.set(DataComponentsRegistry.OIL_USES, (Object)0);
        return newItemOil;
    }

    public static ItemOil setOil(ItemStack stack, ItemOil oil) {
        stack.set(DataComponentsRegistry.OIL, (Object)oil);
        stack.set(DataComponentsRegistry.OIL_USES, (Object)0);
        return oil;
    }

    public static ItemOil removeOil(ItemStack stack) {
        if (!stack.has(DataComponentsRegistry.OIL)) {
            return ItemOil.EMPTY;
        }
        ItemOil itemOil = (ItemOil)stack.get(DataComponentsRegistry.OIL);
        stack.remove(DataComponentsRegistry.OIL);
        stack.remove(DataComponentsRegistry.OIL_USES);
        return itemOil;
    }

    public static boolean hasOil(ItemStack stack) {
        return !((ItemOil)stack.getOrDefault(DataComponentsRegistry.OIL, (Object)ItemOil.EMPTY)).isEmpty() || (Integer)stack.getOrDefault(DataComponentsRegistry.OIL_USES, (Object)-1) == -1;
    }

    public static Optional<Holder.Reference<Item>> getBoltByOilItem(ItemOil itemOil, Level level) {
        return level.registryAccess().lookupOrThrow(Registries.ITEM).filterElements(item -> item instanceof BoltItem && item.components().has((DataComponentType)DataComponentsRegistry.OIL.get()) && itemOil.getOil().equals(((ItemOil)item.components().get((DataComponentType)DataComponentsRegistry.OIL.get())).getOil())).listElements().findAny();
    }

    public static Optional<Holder.Reference<Item>> getOilPotByOilItem(ItemOil itemOil, Level level) {
        return level.registryAccess().lookupOrThrow(Registries.ITEM).filterElements(item -> {
            ItemOil itemOil1;
            OilPotItem oilPotItem;
            Object patt0$temp;
            return item instanceof OilPotItem && (patt0$temp = (oilPotItem = (OilPotItem)((Object)item)).components().get((DataComponentType)DataComponentsRegistry.OIL.get())) instanceof ItemOil && itemOil.equals(itemOil1 = (ItemOil)patt0$temp);
        }).listElements().findAny();
    }
}

