/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.api.util;

import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.yfrostyf.toxony.api.tox.ToxData;
import xyz.yfrostyf.toxony.network.SyncMobToxDataPacket;
import xyz.yfrostyf.toxony.registries.DataAttachmentRegistry;
import xyz.yfrostyf.toxony.registries.MobEffectRegistry;
import xyz.yfrostyf.toxony.registries.SoundEventRegistry;

public class ToxUtil {
    public static float TriangularNumbersMult(float x, float multiplier) {
        return (x + 1.0f) * (x + 2.0f) / 2.0f * multiplier;
    }

    public static double TriangularNumbersMultReverse(float y, float divider) {
        double x = y / divider;
        return (Math.sqrt(1.0 + 8.0 * x) - 3.0) / 2.0;
    }

    public static void addToleranceWithTier(Player player, ToxData toxData, float tolerance, float tier, Level level) {
        if (!toxData.getDeathState()) {
            double toleranceToTriangular = ToxUtil.TriangularNumbersMultReverse(toxData.getTolerance(), 100.0f);
            if ((double)tier >= toleranceToTriangular) {
                toxData.addTolerance(tolerance);
            } else if (level.isClientSide()) {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.toxony.tolerance.weak_tier_warning"), false);
            }
            player.setData(DataAttachmentRegistry.TOX_DATA, (Object)toxData);
        }
    }

    public static void applyMutagenEffect(LivingEntity entity, Holder<MobEffect> effect) {
        if (!entity.hasEffect(effect)) {
            entity.addEffect(new MobEffectInstance(effect, -1, 0, false, false, false));
            return;
        }
        int effectAmp = entity.getEffect(effect).getAmplifier();
        entity.addEffect(new MobEffectInstance(effect, -1, effectAmp + 1, false, false, false));
    }

    public static void setMobToxin(LivingEntity victimEntity, float amount) {
        Level level = victimEntity.level();
        float maxHealth = victimEntity.getMaxHealth();
        if (level instanceof ServerLevel) {
            ServerLevel svlevel = (ServerLevel)level;
            if (amount > 0.0f) {
                if (amount > maxHealth && !victimEntity.hasEffect(MobEffectRegistry.MOB_MUTAGEN)) {
                    victimEntity.addEffect(new MobEffectInstance(MobEffectRegistry.MOB_MUTAGEN, -1, 0, false, false, false));
                    victimEntity.playSound((SoundEvent)SoundEventRegistry.MUTAGEN_TRANSFORM.get(), 0.8f, 1.0f);
                    svlevel.sendParticles((ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, victimEntity.getX(), victimEntity.getEyeY() + 0.55, victimEntity.getZ(), 15, 0.75, 0.3, 0.75, 0.0);
                }
                victimEntity.setData(DataAttachmentRegistry.MOB_TOXIN, (Object)Float.valueOf(amount));
                PacketDistributor.sendToPlayersTrackingEntity((Entity)victimEntity, (CustomPacketPayload)SyncMobToxDataPacket.create(victimEntity.getId(), amount), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

