/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.items.ItemStackHandler;
import xyz.yfrostyf.toxony.blocks.entities.AlchemicalForgeBlockEntity;
import xyz.yfrostyf.toxony.registries.BlockRegistry;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

public class AlchemicalForgeBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<AlchemicalForgeBlock> CODEC = AlchemicalForgeBlock.simpleCodec(AlchemicalForgeBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final EnumProperty<ChestType> PART = BlockStateProperties.CHEST_TYPE;

    public AlchemicalForgeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)ChestType.LEFT)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        Direction directionToBody;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AlchemicalForgeBlockEntity)) {
            return InteractionResult.FAIL;
        }
        AlchemicalForgeBlockEntity blockEntity2 = (AlchemicalForgeBlockEntity)blockEntity;
        player.playSound(SoundEvents.SMITHING_TABLE_USE, 1.0f, 0.8f);
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if (state.getValue(PART) == ChestType.RIGHT) {
                directionToBody = AlchemicalForgeBlock.getNeighbourDirection((ChestType)state.getValue(PART), (Direction)state.getValue((Property)FACING));
                BlockEntity blockEntity3 = level.getBlockEntity(pos.relative(directionToBody));
                if (blockEntity3 instanceof AlchemicalForgeBlockEntity) {
                    AlchemicalForgeBlockEntity neighbourBlockEntity = (AlchemicalForgeBlockEntity)blockEntity3;
                    Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.toxony.alchemical_forge.active", (Object[])new Object[]{Math.round(neighbourBlockEntity.getProgress() * 100.0f) + "%"}), false);
                }
            } else {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.toxony.alchemical_forge.active", (Object[])new Object[]{Math.round(blockEntity2.getProgress() * 100.0f) + "%"}), false);
            }
        }
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        level.sendBlockUpdated(pos, state, state, 2);
        if (state.getValue(PART) == ChestType.RIGHT) {
            directionToBody = AlchemicalForgeBlock.getNeighbourDirection((ChestType)state.getValue(PART), (Direction)state.getValue((Property)FACING));
            BlockPos neighbourBlockPos = pos.relative(directionToBody);
            BlockEntity blockEntity4 = level.getBlockEntity(neighbourBlockPos);
            if (blockEntity4 instanceof AlchemicalForgeBlockEntity) {
                AlchemicalForgeBlockEntity neighbourBlockEntity = (AlchemicalForgeBlockEntity)blockEntity4;
                if (!neighbourBlockEntity.isForging) {
                    player.openMenu((MenuProvider)neighbourBlockEntity, neighbourBlockPos);
                    return InteractionResult.CONSUME;
                }
            }
        } else if (!blockEntity2.isForging) {
            player.openMenu((MenuProvider)blockEntity2, pos);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        BlockPos blockpos = context.getClickedPos();
        BlockPos blockposRight = blockpos.relative(direction.getClockWise());
        Level level = context.getLevel();
        return level.getBlockState(blockposRight).canBeReplaced(context) && level.getWorldBorder().isWithinBounds(blockposRight) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AlchemicalForgeBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT, PART});
    }

    public static Direction getNeighbourDirection(ChestType part, Direction direction) {
        return part == ChestType.LEFT ? direction.getClockWise() : direction.getCounterClockWise();
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == AlchemicalForgeBlock.getNeighbourDirection((ChestType)state.getValue(PART), (Direction)state.getValue((Property)FACING))) {
            if (!facingState.is((Block)this) || facingState.getValue(PART) == state.getValue(PART)) {
                level.setBlock(currentPos, ((Block)BlockRegistry.ALCHEMICAL_FORGE_PART.get()).defaultBlockState(), 35);
                return ((Block)BlockRegistry.ALCHEMICAL_FORGE_PART.get()).defaultBlockState();
            }
            return state;
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (level.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AlchemicalForgeBlockEntity)) {
            return;
        }
        AlchemicalForgeBlockEntity blockEntity2 = (AlchemicalForgeBlockEntity)blockEntity;
        if (state.is(newState.getBlock())) {
            return;
        }
        ItemStackHandler inventory = blockEntity2.getItemContainer();
        for (int i = 0; i < 3; ++i) {
            AlchemicalForgeBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)inventory.getStackInSlot(i).copy());
        }
        level.updateNeighbourForOutputSignal(pos, (Block)this);
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == BlockRegistry.ALCHEMICAL_FORGE_ENTITY.get() ? AlchemicalForgeBlockEntity::tick : null;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AlchemicalForgeBlockEntity)) {
            return;
        }
        AlchemicalForgeBlockEntity blockEntity2 = (AlchemicalForgeBlockEntity)blockEntity;
        if (!blockEntity2.isForging) {
            return;
        }
        double d0 = (double)pos.getX() + 0.4 + (double)random.nextFloat() * 0.2;
        double d1 = (double)pos.getY() + 0.6 + (double)random.nextFloat() * 0.3;
        double d2 = (double)pos.getZ() + 0.4 + (double)random.nextFloat() * 0.2;
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public MapCodec<AlchemicalForgeBlock> codec() {
        return CODEC;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return ((Item)ItemRegistry.ALCHEMICAL_FORGE_PART.get()).getDefaultInstance();
    }
}

