/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import xyz.yfrostyf.toxony.blocks.AlchemicalForgeBlock;
import xyz.yfrostyf.toxony.registries.BlockRegistry;

public class AlchemicalForgePartBlock
extends Block {
    public static final MapCodec<AlchemicalForgePartBlock> CODEC = AlchemicalForgePartBlock.simpleCodec(AlchemicalForgePartBlock::new);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public AlchemicalForgePartBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        Direction horizontalDirection = context.getHorizontalDirection();
        if (player == null || player.level().isClientSide()) {
            return this.defaultBlockState();
        }
        if (AlchemicalForgePartBlock.hasTooManyNeighbours(pos, level)) {
            return this.defaultBlockState();
        }
        BlockPos posToRight = pos.relative(horizontalDirection.getClockWise());
        if (level.getBlockState(posToRight).is(BlockRegistry.ALCHEMICAL_FORGE_PART)) {
            if (AlchemicalForgePartBlock.hasTooManyNeighbours(posToRight, level)) {
                return this.defaultBlockState();
            }
            return (BlockState)((BlockState)((BlockState)((Block)BlockRegistry.ALCHEMICAL_FORGE.get()).defaultBlockState().setValue(AlchemicalForgeBlock.PART, (Comparable)ChestType.LEFT)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)AlchemicalForgeBlock.FACING, (Comparable)player.getDirection());
        }
        BlockPos posToLeft = pos.relative(horizontalDirection.getCounterClockWise());
        if (level.getBlockState(posToLeft).is(BlockRegistry.ALCHEMICAL_FORGE_PART)) {
            if (AlchemicalForgePartBlock.hasTooManyNeighbours(posToLeft, level)) {
                return this.defaultBlockState();
            }
            return (BlockState)((BlockState)((BlockState)((Block)BlockRegistry.ALCHEMICAL_FORGE.get()).defaultBlockState().setValue(AlchemicalForgeBlock.PART, (Comparable)ChestType.RIGHT)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)AlchemicalForgeBlock.FACING, (Comparable)player.getDirection());
        }
        BlockPos posToForward = pos.relative(player.getDirection());
        if (level.getBlockState(posToForward).is(BlockRegistry.ALCHEMICAL_FORGE_PART)) {
            if (AlchemicalForgePartBlock.hasTooManyNeighbours(posToForward, level)) {
                return this.defaultBlockState();
            }
            return (BlockState)((BlockState)((BlockState)((Block)BlockRegistry.ALCHEMICAL_FORGE.get()).defaultBlockState().setValue(AlchemicalForgeBlock.PART, (Comparable)ChestType.RIGHT)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)AlchemicalForgeBlock.FACING, (Comparable)player.getDirection().getClockWise());
        }
        BlockPos posToBack = pos.relative(player.getDirection().getOpposite());
        if (level.getBlockState(posToBack).is(BlockRegistry.ALCHEMICAL_FORGE_PART)) {
            if (AlchemicalForgePartBlock.hasTooManyNeighbours(posToBack, level)) {
                return this.defaultBlockState();
            }
            return (BlockState)((BlockState)((BlockState)((Block)BlockRegistry.ALCHEMICAL_FORGE.get()).defaultBlockState().setValue(AlchemicalForgeBlock.PART, (Comparable)ChestType.LEFT)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)AlchemicalForgeBlock.FACING, (Comparable)player.getDirection().getClockWise());
        }
        return super.getStateForPlacement(context);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        BlockState neighborState = level.getBlockState(neighborPos);
        if (neighborState.is(BlockRegistry.ALCHEMICAL_FORGE)) {
            ChestType type = (ChestType)neighborState.getValue((Property)BlockStateProperties.CHEST_TYPE);
            Direction direction = (Direction)neighborState.getValue((Property)HorizontalDirectionalBlock.FACING);
            level.setBlock(pos, (BlockState)((BlockState)((Block)BlockRegistry.ALCHEMICAL_FORGE.get()).defaultBlockState().setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)(type == ChestType.LEFT ? ChestType.RIGHT : ChestType.LEFT))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction), 3);
            return;
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    private static boolean hasTooManyNeighbours(BlockPos pos, Level level) {
        int i = 0;
        AABB area = new AABB(pos).inflate(0.5);
        List blocksInArea = level.getBlockStates(area).toList();
        for (BlockState selState : blocksInArea) {
            if (!selState.is(BlockRegistry.ALCHEMICAL_FORGE) && !selState.is(BlockRegistry.ALCHEMICAL_FORGE_PART) || ++i <= 1) continue;
            return true;
        }
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }

    private static Direction getNeighbourDirection(ChestType part, Direction direction) {
        return part == ChestType.LEFT ? direction.getClockWise() : direction.getCounterClockWise();
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public MapCodec<AlchemicalForgePartBlock> codec() {
        return CODEC;
    }
}

