/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemStackHandler;
import xyz.yfrostyf.toxony.blocks.entities.AlembicBlockEntity;
import xyz.yfrostyf.toxony.registries.BlockRegistry;

public class AlembicBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<AlembicBlock> CODEC = AlembicBlock.simpleCodec(AlembicBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final EnumProperty<ChestType> PART = BlockStateProperties.CHEST_TYPE;
    protected static final VoxelShape SHAPE_BASE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    protected static final VoxelShape SHAPE_ROD = Block.box((double)7.0, (double)10.0, (double)7.0, (double)9.0, (double)20.0, (double)9.0);
    protected static final VoxelShape SHAPE_BOTTLE_N = Block.box((double)3.0, (double)0.0, (double)5.0, (double)9.0, (double)8.0, (double)11.0);
    protected static final VoxelShape SHAPE_BOTTLE_E = Block.box((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)8.0, (double)9.0);
    protected static final VoxelShape SHAPE_BOTTLE_S = Block.box((double)7.0, (double)0.0, (double)5.0, (double)13.0, (double)8.0, (double)11.0);
    protected static final VoxelShape SHAPE_BOTTLE_W = Block.box((double)5.0, (double)0.0, (double)7.0, (double)11.0, (double)8.0, (double)13.0);
    public static final VoxelShape SHAPE = Shapes.or((VoxelShape)SHAPE_BASE, (VoxelShape)SHAPE_ROD);

    public AlembicBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)ChestType.LEFT)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AlembicBlockEntity)) {
            return InteractionResult.FAIL;
        }
        AlembicBlockEntity blockEntity2 = (AlembicBlockEntity)blockEntity;
        player.playSound(SoundEvents.AMETHYST_BLOCK_BREAK);
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        level.sendBlockUpdated(pos, state, state, 2);
        if (state.getValue(PART) == ChestType.RIGHT) {
            Direction directionToBody = AlembicBlock.getNeighbourDirection((ChestType)state.getValue(PART), (Direction)state.getValue((Property)FACING));
            BlockPos neighbourBlockPos = pos.relative(directionToBody);
            BlockEntity blockEntity3 = level.getBlockEntity(neighbourBlockPos);
            if (blockEntity3 instanceof AlembicBlockEntity) {
                AlembicBlockEntity neighbourBlockEntity = (AlembicBlockEntity)blockEntity3;
                player.openMenu((MenuProvider)neighbourBlockEntity, neighbourBlockPos);
                return InteractionResult.CONSUME;
            }
        } else {
            player.openMenu((MenuProvider)blockEntity2, pos);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        BlockPos blockpos = context.getClickedPos();
        BlockPos blockposRight = blockpos.relative(direction.getClockWise());
        Level level = context.getLevel();
        return level.getBlockState(blockposRight).canBeReplaced(context) && level.getWorldBorder().isWithinBounds(blockposRight) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AlembicBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT, PART});
    }

    private static Direction getNeighbourDirection(ChestType part, Direction direction) {
        return part == ChestType.LEFT ? direction.getClockWise() : direction.getCounterClockWise();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.getValue(PART) == ChestType.LEFT) {
            return SHAPE;
        }
        Direction direction = (Direction)state.getValue((Property)FACING);
        return switch (direction) {
            case Direction.SOUTH -> SHAPE_BOTTLE_S;
            case Direction.EAST -> SHAPE_BOTTLE_E;
            case Direction.WEST -> SHAPE_BOTTLE_W;
            default -> SHAPE_BOTTLE_N;
        };
    }

    public RenderShape getRenderShape(BlockState blockState) {
        if (((ChestType)blockState.getValue(PART)).equals((Object)ChestType.LEFT)) {
            return RenderShape.MODEL;
        }
        return RenderShape.INVISIBLE;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == AlembicBlock.getNeighbourDirection((ChestType)state.getValue(PART), (Direction)state.getValue((Property)FACING))) {
            if (!facingState.is((Block)this) || facingState.getValue(PART) == state.getValue(PART)) {
                level.setBlock(currentPos, Blocks.AIR.defaultBlockState(), 35);
                level.levelEvent(null, 2001, currentPos, Block.getId((BlockState)Blocks.AIR.defaultBlockState()));
                return Blocks.AIR.defaultBlockState();
            }
            return state;
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide) {
            level.setBlock(pos, (BlockState)state.setValue(PART, (Comparable)ChestType.LEFT), 3);
            BlockPos blockpos = pos.relative(AlembicBlock.getNeighbourDirection((ChestType)state.getValue(PART), (Direction)state.getValue((Property)FACING)));
            level.setBlock(blockpos, (BlockState)state.setValue(PART, (Comparable)ChestType.RIGHT), 3);
            level.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (level.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AlembicBlockEntity)) {
            return;
        }
        AlembicBlockEntity blockEntity2 = (AlembicBlockEntity)blockEntity;
        if (state.is(newState.getBlock())) {
            return;
        }
        ItemStackHandler inventory = blockEntity2.getItemContainer();
        for (int i = 0; i < 3; ++i) {
            AlembicBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)inventory.getStackInSlot(i).copy());
        }
        level.updateNeighbourForOutputSignal(pos, (Block)this);
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (state.getValue(PART) == ChestType.RIGHT) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AlembicBlockEntity)) {
            return;
        }
        AlembicBlockEntity entity = (AlembicBlockEntity)blockEntity;
        if (!entity.hasFuel()) {
            return;
        }
        double d0 = (double)pos.getX() + 0.4 + (double)random.nextFloat() * 0.2;
        double d1 = (double)pos.getY() + 1.2 + (double)random.nextFloat() * 0.3;
        double d2 = (double)pos.getZ() + 0.4 + (double)random.nextFloat() * 0.2;
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == BlockRegistry.ALEMBIC_ENTITY.get() ? AlembicBlockEntity::tick : null;
    }

    public MapCodec<AlembicBlock> codec() {
        return CODEC;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

