/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks;

import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import xyz.yfrostyf.toxony.blocks.OilPotBlock;
import xyz.yfrostyf.toxony.blocks.entities.OilPotBlockEntity;
import xyz.yfrostyf.toxony.registries.ItemRegistry;
import xyz.yfrostyf.toxony.registries.TagRegistry;

public class MendingOilPotBlock
extends OilPotBlock {
    public MendingOilPotBlock(BlockBehaviour.Properties properties, Supplier<Holder<Item>> oilPotItem) {
        super(properties, oilPotItem);
    }

    public MendingOilPotBlock(BlockBehaviour.Properties properties, Holder<Item> oilPotItem) {
        super(properties, oilPotItem);
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int maxDamage;
        OilPotBlockEntity blockEntity;
        block9: {
            block8: {
                BlockEntity blockEntity2 = level.getBlockEntity(pos);
                if (!(blockEntity2 instanceof OilPotBlockEntity)) break block8;
                blockEntity = (OilPotBlockEntity)blockEntity2;
                blockEntity2 = state.getBlock();
                if (!(blockEntity2 instanceof MendingOilPotBlock)) break block8;
                MendingOilPotBlock oilPotBlock = (MendingOilPotBlock)blockEntity2;
                if (!stack.isEmpty()) break block9;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        int damage = blockEntity.getDamage();
        boolean hasNoOil = damage >= (maxDamage = blockEntity.getMaxDamage());
        boolean isItemDamageable = stack.isDamaged() && stack.is(TagRegistry.OIL_REPAIRABLE) && !hasNoOil;
        boolean canAddOilBase = stack.is(TagRegistry.CAN_REFILL_OIL) && damage > 0;
        ItemInteractionResult interactionResult = ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        if (level.isClientSide() && hasNoOil && !stack.is(TagRegistry.CAN_REFILL_OIL)) {
            Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.toxony.oilpot.empty").withStyle(ChatFormatting.WHITE), false);
            return ItemInteractionResult.FAIL;
        }
        if (isItemDamageable) {
            stack.setDamageValue(Math.max(0, stack.getDamageValue() - 100));
            BlockState newBlockState = (BlockState)state.setValue((Property)OIL_LEFT, (Comparable)Integer.valueOf(MendingOilPotBlock.getBlockDamage(maxDamage, damage + 1)));
            level.setBlock(pos, newBlockState, 11);
            blockEntity.setDamage(damage + 1);
            level.playSound(player, pos, SoundEvents.HONEY_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
            interactionResult = ItemInteractionResult.SUCCESS;
        } else if (canAddOilBase) {
            blockEntity.setDamage(0);
            stack.consume(1, (LivingEntity)player);
            BlockState newBlockState = (BlockState)state.setValue((Property)OIL_LEFT, (Comparable)Integer.valueOf(3));
            level.setBlock(pos, newBlockState, 11);
            level.playSound(player, pos, SoundEvents.HONEY_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
            interactionResult = ItemInteractionResult.SUCCESS;
        }
        if (interactionResult.consumesAction()) {
            level.sendBlockUpdated(pos, blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
            blockEntity.setChanged();
        }
        return interactionResult;
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return ((Item)ItemRegistry.MENDING_OIL_POT.get()).getDefaultInstance();
    }
}

