/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import xyz.yfrostyf.toxony.blocks.entities.MortarPestleBlockEntity;
import xyz.yfrostyf.toxony.registries.BlockRegistry;

public class MortarPestleBlock
extends Block
implements EntityBlock {
    public static final int PESTLE_TOTAL_TICK = 20;
    public static final int PESTLE_TOTAL_COUNT = 3;
    public static final MapCodec<MortarPestleBlock> CODEC = MortarPestleBlock.simpleCodec(MortarPestleBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final IntegerProperty INGREDIENTS = IntegerProperty.create((String)"ingredients", (int)0, (int)5);
    protected static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0);

    public MortarPestleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)INGREDIENTS, (Comparable)Integer.valueOf(0)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof MortarPestleBlockEntity)) {
            return InteractionResult.FAIL;
        }
        MortarPestleBlockEntity blockEntity2 = (MortarPestleBlockEntity)blockEntity;
        if (!blockEntity2.isPestling) {
            player.openMenu((MenuProvider)blockEntity2, pos);
            return InteractionResult.CONSUME;
        }
        if (blockEntity2.pestleCount >= 3 && blockEntity2.pestleTick <= 0) {
            blockEntity2.finishPestling(player, level);
            return InteractionResult.SUCCESS;
        }
        if (blockEntity2.pestleTick <= 0) {
            blockEntity2.pestleTick = 20;
            ++blockEntity2.pestleCount;
            player.playSound(SoundEvents.GRINDSTONE_USE);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return super.getStateForPlacement(context);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MortarPestleBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, INGREDIENTS});
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (level.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof MortarPestleBlockEntity)) {
            return;
        }
        MortarPestleBlockEntity blockEntity2 = (MortarPestleBlockEntity)blockEntity;
        if (state.is(newState.getBlock())) {
            return;
        }
        ItemStackHandler inventory = blockEntity2.getItemContainer();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = new ItemStack(inventory.getStackInSlot(i).getItemHolder(), inventory.getStackInSlot(i).getCount());
            MortarPestleBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)itemstack);
        }
        level.updateNeighbourForOutputSignal(pos, (Block)this);
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == BlockRegistry.MORTAR_PESTLE_ENTITY.get() ? MortarPestleBlockEntity::tick : null;
    }

    public MapCodec<MortarPestleBlock> codec() {
        return CODEC;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

