/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xyz.yfrostyf.toxony.api.oils.ItemOil;
import xyz.yfrostyf.toxony.api.util.OilUtil;
import xyz.yfrostyf.toxony.blocks.entities.OilPotBlockEntity;
import xyz.yfrostyf.toxony.items.OilPotItem;
import xyz.yfrostyf.toxony.registries.BlockRegistry;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;
import xyz.yfrostyf.toxony.registries.ItemRegistry;
import xyz.yfrostyf.toxony.registries.TagRegistry;

public class OilPotBlock
extends Block
implements EntityBlock {
    public static final MapCodec<OilPotBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)OilPotBlock.propertiesCodec(), (App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("oilpot_item").forGetter(OilPotBlock::getOilPotItem)).apply((Applicative)instance, OilPotBlock::new));
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    public static final IntegerProperty OIL_LEFT = IntegerProperty.create((String)"oil", (int)0, (int)3);
    protected final Supplier<Holder<Item>> oilPotItem;

    public OilPotBlock(BlockBehaviour.Properties properties, Supplier<Holder<Item>> oilPotItem) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)OIL_LEFT, (Comparable)Integer.valueOf(0)));
        this.oilPotItem = oilPotItem;
    }

    public OilPotBlock(BlockBehaviour.Properties properties, Holder<Item> oilPotItem) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)OIL_LEFT, (Comparable)Integer.valueOf(0)));
        this.oilPotItem = () -> oilPotItem;
    }

    public MapCodec<OilPotBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{OIL_LEFT});
    }

    public Holder<Item> getOilPotItem() {
        return this.oilPotItem.get();
    }

    public ItemOil getOil() {
        Object object = this.getOilPotItem().value();
        if (object instanceof OilPotItem) {
            OilPotItem item = (OilPotItem)((Object)object);
            return item.getItemOil();
        }
        return ItemOil.EMPTY;
    }

    public static int getBlockDamage(int max, int value) {
        return Mth.ceil((float)(3.0f * Math.min((float)(max - value) / (float)max, 1.0f)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int maxDamage;
        OilPotBlock oilPotBlock;
        OilPotBlockEntity blockEntity;
        block14: {
            block13: {
                BlockEntity blockEntity2 = level.getBlockEntity(pos);
                if (!(blockEntity2 instanceof OilPotBlockEntity)) break block13;
                blockEntity = (OilPotBlockEntity)blockEntity2;
                blockEntity2 = state.getBlock();
                if (!(blockEntity2 instanceof OilPotBlock)) break block13;
                oilPotBlock = (OilPotBlock)blockEntity2;
                if (!stack.isEmpty()) break block14;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        int damage = blockEntity.getDamage();
        boolean hasNoOil = damage >= (maxDamage = blockEntity.getMaxDamage());
        ItemOil itemOil = oilPotBlock.getOil();
        boolean itemHasFullOil = itemOil != null && stack.has(DataComponentsRegistry.OIL_USES) && (Integer)stack.getOrDefault(DataComponentsRegistry.OIL_USES, (Object)0) <= 0;
        boolean canAddOilTool = !itemOil.isEmpty() && stack.is(itemOil.getOil().getSupportedItems()) && !hasNoOil && !itemHasFullOil;
        boolean canAddOilBolt = !itemOil.isEmpty() && stack.is(ItemRegistry.BOLT) && !hasNoOil;
        boolean canAddOilBase = stack.is(TagRegistry.CAN_REFILL_OIL) && damage > 0;
        ItemInteractionResult interactionResult = ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        if (level.isClientSide()) {
            if (hasNoOil && !stack.is(TagRegistry.CAN_REFILL_OIL)) {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.toxony.oilpot.empty").withStyle(ChatFormatting.WHITE), false);
                return ItemInteractionResult.FAIL;
            }
            if (!canAddOilTool && stack.is(itemOil.getOil().getSupportedItems())) {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.toxony.oilpot.already_oiled").withStyle(ChatFormatting.WHITE), false);
                return ItemInteractionResult.FAIL;
            }
        }
        if (canAddOilTool) {
            OilUtil.updateOil(stack, itemOil);
            BlockState newBlockState = (BlockState)state.setValue((Property)OIL_LEFT, (Comparable)Integer.valueOf(OilPotBlock.getBlockDamage(maxDamage, damage + 1)));
            level.setBlock(pos, newBlockState, 11);
            blockEntity.setDamage(damage + 1);
            level.playSound(player, pos, SoundEvents.HONEY_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
            interactionResult = ItemInteractionResult.SUCCESS;
        } else if (canAddOilBolt) {
            Optional<Holder.Reference<Item>> optionalHolder = OilUtil.getBoltByOilItem(oilPotBlock.getOil(), level);
            if (optionalHolder.isPresent()) {
                ItemStack boltStack = new ItemStack((Holder)optionalHolder.get(), stack.getCount());
                player.setItemInHand(hand, boltStack);
                level.playSound(player, pos, SoundEvents.HONEY_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
            }
            interactionResult = ItemInteractionResult.SUCCESS;
        } else if (canAddOilBase) {
            blockEntity.setDamage(0);
            stack.consume(1, (LivingEntity)player);
            BlockState newBlockState = (BlockState)state.setValue((Property)OIL_LEFT, (Comparable)Integer.valueOf(3));
            level.setBlock(pos, newBlockState, 11);
            level.playSound(player, pos, SoundEvents.HONEY_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
            interactionResult = ItemInteractionResult.SUCCESS;
        }
        if (interactionResult.consumesAction()) {
            level.sendBlockUpdated(pos, blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
            blockEntity.setChanged();
        }
        return interactionResult;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (level.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof OilPotBlockEntity)) {
            return;
        }
        OilPotBlockEntity blockEntity2 = (OilPotBlockEntity)blockEntity;
        Block block = state.getBlock();
        if (!(block instanceof OilPotBlock)) {
            return;
        }
        OilPotBlock block2 = (OilPotBlock)block;
        if (state.is(newState.getBlock())) {
            return;
        }
        ItemStack stack = new ItemStack(block2.getOilPotItem());
        stack.setDamageValue(blockEntity2.getDamage());
        OilPotBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new OilPotBlockEntity(pos, state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (state.is(BlockRegistry.FIRE_RESISTANCE_OIL_POT)) {
            return ((Item)ItemRegistry.FIRE_RESISTANCE_OIL_POT.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.GLOWING_OIL_POT)) {
            return ((Item)ItemRegistry.GLOWING_OIL_POT.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.FATIGUE_OIL_POT)) {
            return ((Item)ItemRegistry.FATIGUE_OIL_POT.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.POISON_OIL_POT)) {
            return ((Item)ItemRegistry.POISON_OIL_POT.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.SMOKE_TOX_POT)) {
            return ((Item)ItemRegistry.SMOKE_TOX_POT.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.REGENERATION_TOX_POT)) {
            return ((Item)ItemRegistry.REGENERATION_TOX_POT.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.WITCHFIRE_TOX_POT)) {
            return ((Item)ItemRegistry.WITCHFIRE_TOX_POT.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.TOXIN_TOX_POT)) {
            return ((Item)ItemRegistry.TOXIN_TOX_POT.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.ACID_OIL_POT)) {
            return ((Item)ItemRegistry.ACID_OIL_POT.get()).getDefaultInstance();
        }
        return ((Item)ItemRegistry.EMPTY_OIL_POT.get()).getDefaultInstance();
    }
}

