/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks;

import com.mojang.serialization.MapCodec;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.FarmlandWaterManager;
import net.neoforged.neoforge.common.util.TriState;
import xyz.yfrostyf.toxony.registries.TagRegistry;

public class PoisonFarmBlock
extends Block {
    public static final MapCodec<PoisonFarmBlock> CODEC = PoisonFarmBlock.simpleCodec(PoisonFarmBlock::new);
    public static final IntegerProperty MOISTURE = BlockStateProperties.MOISTURE;
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final int MAX_MOISTURE = 7;

    public PoisonFarmBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !state.canSurvive((LevelReader)level, currentPos)) {
            level.scheduleTick(currentPos, (Block)this, 1);
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos.above());
        return !blockstate.isSolid() || blockstate.getBlock() instanceof FenceGateBlock || blockstate.getBlock() instanceof MovingPistonBlock;
    }

    public TriState canSustainPlant(BlockState state, BlockGetter level, BlockPos soilPosition, Direction facing, BlockState plant) {
        return plant.is(TagRegistry.POISONOUS_PLANTS_BLOCK) ? TriState.DEFAULT : TriState.FALSE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return !this.defaultBlockState().canSurvive((LevelReader)context.getLevel(), context.getClickedPos()) ? Blocks.COARSE_DIRT.defaultBlockState() : super.getStateForPlacement(context);
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            PoisonFarmBlock.turnToDirt(null, state, (Level)level, pos);
        }
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i = (Integer)state.getValue((Property)MOISTURE);
        if (!PoisonFarmBlock.isNearWater((LevelReader)level, pos) && !level.isRainingAt(pos.above())) {
            if (i > 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!PoisonFarmBlock.shouldMaintainFarmland((BlockGetter)level, pos)) {
                PoisonFarmBlock.turnToDirt(null, state, (Level)level, pos);
            }
        } else if (i < 7) {
            level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
        PoisonFarmBlock.infectNeighbours(null, state, (Level)level, pos);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!level.isClientSide && CommonHooks.onFarmlandTrample((Level)level, (BlockPos)pos, (BlockState)Blocks.COARSE_DIRT.defaultBlockState(), (float)fallDistance, (Entity)entity)) {
            PoisonFarmBlock.turnToDirt(entity, state, level, pos);
        }
        super.fallOn(level, state, pos, entity, fallDistance);
    }

    public static void infectNeighbours(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        for (BlockPos blockPos : Set.of(pos.north(), pos.east(), pos.south(), pos.west())) {
            BlockState curBlockState = level.getBlockState(blockPos);
            if (curBlockState.is(Blocks.FARMLAND) || curBlockState.is(BlockTags.DIRT) && !curBlockState.is(Blocks.COARSE_DIRT)) {
                level.setBlock(blockPos, Blocks.COARSE_DIRT.defaultBlockState(), 3);
            }
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)curBlockState));
        }
    }

    public static void turnToDirt(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        BlockState blockstate = PoisonFarmBlock.pushEntitiesUp((BlockState)state, (BlockState)Blocks.COARSE_DIRT.defaultBlockState(), (LevelAccessor)level, (BlockPos)pos);
        level.setBlockAndUpdate(pos, blockstate);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockstate));
    }

    private static boolean shouldMaintainFarmland(BlockGetter level, BlockPos pos) {
        return level.getBlockState(pos.above()).is(BlockTags.MAINTAINS_FARMLAND);
    }

    private static boolean isNearWater(LevelReader level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-4, 0, -4), (BlockPos)pos.offset(4, 1, 4))) {
            if (!state.canBeHydrated((BlockGetter)level, pos, level.getFluidState(blockpos), blockpos)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)level, (BlockPos)pos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MOISTURE});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

