/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import xyz.yfrostyf.toxony.blocks.entities.RedstoneMortarBlockEntity;
import xyz.yfrostyf.toxony.registries.BlockRegistry;

public class RedstoneMortarBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final int PESTLE_TOTAL_TICK = 30;
    public static final int PESTLE_TOTAL_COUNT = 5;
    public static final MapCodec<RedstoneMortarBlock> CODEC = RedstoneMortarBlock.simpleCodec(RedstoneMortarBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;
    public static final IntegerProperty INGREDIENTS = IntegerProperty.create((String)"ingredients", (int)0, (int)5);

    public RedstoneMortarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)INGREDIENTS, (Comparable)Integer.valueOf(0))).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof RedstoneMortarBlockEntity)) {
            return InteractionResult.FAIL;
        }
        RedstoneMortarBlockEntity blockEntity2 = (RedstoneMortarBlockEntity)blockEntity;
        player.openMenu((MenuProvider)blockEntity2, pos);
        player.playSound(SoundEvents.COPPER_HIT);
        return InteractionResult.CONSUME;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return super.getStateForPlacement(context);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RedstoneMortarBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, INGREDIENTS, TRIGGERED});
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (level.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof RedstoneMortarBlockEntity)) {
            return;
        }
        RedstoneMortarBlockEntity blockEntity2 = (RedstoneMortarBlockEntity)blockEntity;
        if (state.is(newState.getBlock())) {
            return;
        }
        ItemStackHandler inventory = blockEntity2.getItemContainer();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = new ItemStack(inventory.getStackInSlot(i).getItemHolder(), inventory.getStackInSlot(i).getCount());
            RedstoneMortarBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)itemstack);
        }
        level.updateNeighbourForOutputSignal(pos, (Block)this);
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof RedstoneMortarBlockEntity)) {
            return;
        }
        RedstoneMortarBlockEntity blockEntity2 = (RedstoneMortarBlockEntity)blockEntity;
        if (level.hasNeighborSignal(pos) && !((Boolean)state.getValue((Property)TRIGGERED)).booleanValue()) {
            if (!blockEntity2.isPestling) {
                blockEntity2.startPestling();
            }
            if (blockEntity2.pestleCount < 5 && blockEntity2.pestleTick <= 0 && blockEntity2.isPestling) {
                blockEntity2.pestleTick = 30;
                ++blockEntity2.pestleCount;
                level.playSound(null, pos, SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 0.8f, 1.1f);
            } else if (blockEntity2.pestleCount >= 5 && blockEntity2.pestleTick <= 0 && blockEntity2.isPestling) {
                blockEntity2.finishPestling(level);
                level.playSound(null, pos, SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 0.8f, 1.1f);
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 3);
        } else if (!level.hasNeighborSignal(pos) && ((Boolean)state.getValue((Property)TRIGGERED)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof RedstoneMortarBlockEntity)) {
            return 0;
        }
        RedstoneMortarBlockEntity blockEntity2 = (RedstoneMortarBlockEntity)blockEntity;
        return blockEntity2.pestleCount;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == BlockRegistry.REDSTONE_MORTAR_ENTITY.get() ? RedstoneMortarBlockEntity::tick : null;
    }

    public MapCodec<RedstoneMortarBlock> codec() {
        return CODEC;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return true;
    }
}

