/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xyz.yfrostyf.toxony.blocks.CandleToxicCakeBlock;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

public class ToxicCakeBlock
extends Block {
    public static final MapCodec<ToxicCakeBlock> CODEC = ToxicCakeBlock.simpleCodec(ToxicCakeBlock::new);
    public static final IntegerProperty BITES = IntegerProperty.create((String)"bites", (int)0, (int)5);
    public static final int FULL_CAKE_SIGNAL = ToxicCakeBlock.getOutputSignal(0);
    public static final VoxelShape SHAPE_TOP = Block.box((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0);
    public static final VoxelShape SHAPE_TOP_HALF = Block.box((double)5.0, (double)11.0, (double)5.0, (double)8.0, (double)15.0, (double)11.0);
    public static final VoxelShape SHAPE_MID = Block.box((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0);
    public static final VoxelShape SHAPE_MID_HALF = Block.box((double)3.0, (double)6.0, (double)3.0, (double)8.0, (double)11.0, (double)13.0);
    public static final VoxelShape SHAPE_BOTTOM = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
    public static final VoxelShape SHAPE_BOTTOM_HALF = Block.box((double)1.0, (double)0.0, (double)1.0, (double)8.0, (double)6.0, (double)15.0);
    public static final VoxelShape[] SHAPE_BY_BITE = new VoxelShape[]{Shapes.or((VoxelShape)SHAPE_TOP, (VoxelShape[])new VoxelShape[]{SHAPE_MID, SHAPE_BOTTOM}), Shapes.or((VoxelShape)SHAPE_TOP_HALF, (VoxelShape[])new VoxelShape[]{SHAPE_MID, SHAPE_BOTTOM}), Shapes.or((VoxelShape)SHAPE_MID, (VoxelShape)SHAPE_BOTTOM), Shapes.or((VoxelShape)SHAPE_MID_HALF, (VoxelShape)SHAPE_BOTTOM), SHAPE_BOTTOM, SHAPE_BOTTOM_HALF};

    public ToxicCakeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Block block;
        Item item = stack.getItem();
        if (stack.is(ItemTags.CANDLES) && (Integer)state.getValue((Property)BITES) == 0 && (block = Block.byItem((Item)item)) instanceof CandleBlock) {
            CandleBlock candleblock = (CandleBlock)block;
            stack.consume(1, (LivingEntity)player);
            level.playSound(null, pos, SoundEvents.CAKE_ADD_CANDLE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlockAndUpdate(pos, CandleToxicCakeBlock.byCandle(candleblock));
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        InteractionResult result = ToxicCakeBlock.take(level, pos, state, player);
        return result;
    }

    public static InteractionResult take(Level level, BlockPos pos, BlockState state, Player player) {
        int i = (Integer)state.getValue((Property)BITES);
        player.addItem(new ItemStack(ItemRegistry.TOXIC_CAKE_SLICE, 1));
        level.playSound(null, pos, SoundEvents.SLIME_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (i < 5) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            level.removeBlock(pos, false);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BITES, (Comparable)Integer.valueOf(0));
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_BITE[(Integer)state.getValue((Property)BITES)];
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    public MapCodec<ToxicCakeBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BITES});
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return ((Item)ItemRegistry.TOXIC_CAKE.get()).getDefaultInstance();
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return ToxicCakeBlock.getOutputSignal((Integer)blockState.getValue((Property)BITES));
    }

    public static int getOutputSignal(int eaten) {
        return (7 - eaten) * 2;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

