/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

public class ValentinesBoxBlock
extends HorizontalDirectionalBlock {
    private static final Random RANDOM = new Random();
    public static final MapCodec<ValentinesBoxBlock> CODEC = ValentinesBoxBlock.simpleCodec(ValentinesBoxBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final IntegerProperty CHOCOLATE_COUNT = IntegerProperty.create((String)"chocolates", (int)0, (int)6);
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);

    public ValentinesBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)CHOCOLATE_COUNT, (Comparable)Integer.valueOf(6))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.isCrouching()) {
            if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)), 3);
            } else {
                level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true)), 3);
            }
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            if ((Integer)state.getValue((Property)CHOCOLATE_COUNT) > 0) {
                player.playSound(SoundEvents.WOOL_PLACE);
                List<Item> chocolates = List.of((Item)ItemRegistry.MILK_CHOCOLATE.get(), (Item)ItemRegistry.MINT_CHOCOLATE.get(), (Item)ItemRegistry.DARK_CHOCOLATE.get());
                level.setBlock(pos, (BlockState)state.setValue((Property)CHOCOLATE_COUNT, (Comparable)Integer.valueOf((Integer)state.getValue((Property)CHOCOLATE_COUNT) - 1)), 3);
                player.addItem(new ItemStack((ItemLike)chocolates.get(RANDOM.nextInt(chocolates.size()))));
            } else {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.toxony.valetines_box.empty"), false);
            }
            return InteractionResult.SUCCESS;
        }
        if (level.isClientSide()) {
            Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.toxony.valetines_box.warning"), false);
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, CHOCOLATE_COUNT, OPEN});
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public MapCodec<ValentinesBoxBlock> codec() {
        return CODEC;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return true;
    }
}

