/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

public class VialRackBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<VialRackBlock> CODEC = VialRackBlock.simpleCodec(VialRackBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final IntegerProperty COUNT = IntegerProperty.create((String)"count", (int)0, (int)6);
    protected static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)7.0, (double)12.0);
    protected static final VoxelShape SHAPE_SIDEWAYS = Block.box((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)13.0);

    public VialRackBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)COUNT, (Comparable)Integer.valueOf(0)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!state.is((Block)this)) {
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        int count = (Integer)state.getValue((Property)COUNT);
        if (stack.is(ItemRegistry.GLASS_VIAL) && count < 6) {
            stack.consume(1, (LivingEntity)player);
            level.setBlock(pos, (BlockState)state.setValue((Property)COUNT, (Comparable)Integer.valueOf(count + 1)), 3);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!state.is((Block)this)) {
            return super.useWithoutItem(state, level, pos, player, hitResult);
        }
        int count = (Integer)state.getValue((Property)COUNT);
        if (count > 0) {
            player.getInventory().add(new ItemStack(ItemRegistry.GLASS_VIAL, 1));
            level.setBlock(pos, (BlockState)state.setValue((Property)COUNT, (Comparable)Integer.valueOf(count - 1)), 3);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)COUNT, (Comparable)Integer.valueOf(0));
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST, Direction.WEST -> SHAPE_SIDEWAYS;
            default -> SHAPE;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, COUNT});
    }

    public MapCodec<VialRackBlock> codec() {
        return CODEC;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (level.isClientSide()) {
            return;
        }
        if (state.is(newState.getBlock())) {
            return;
        }
        int count = (Integer)state.getValue((Property)COUNT);
        if (count > 0) {
            VialRackBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack(ItemRegistry.GLASS_VIAL, count));
        }
        level.updateNeighbourForOutputSignal(pos, (Block)this);
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return true;
    }
}

