/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks.entities;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import xyz.yfrostyf.toxony.blocks.AlchemicalForgeBlock;
import xyz.yfrostyf.toxony.client.gui.block.AlchemicalForgeMenu;
import xyz.yfrostyf.toxony.recipes.AlchemicalForgeRecipe;
import xyz.yfrostyf.toxony.recipes.inputs.AlchemicalForgeRecipeInput;
import xyz.yfrostyf.toxony.registries.BlockRegistry;
import xyz.yfrostyf.toxony.registries.ItemRegistry;
import xyz.yfrostyf.toxony.registries.RecipeRegistry;

public class AlchemicalForgeBlockEntity
extends BlockEntity
implements IItemHandler,
MenuProvider {
    public static final int FORGE_TOTAL_TIME = 3000;
    public static final int MAX_FUEL = 400;
    public static final int REQUIRED_FUEL = 400;
    private static final int CONTAINER_SIZE = 7;
    public int fuel = 0;
    public int forgeProgress = 0;
    public ItemStackHandler itemContainer;
    public boolean isForging = false;
    private RecipeType<AlchemicalForgeRecipe> recipeType;
    protected final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> AlchemicalForgeBlockEntity.this.fuel;
                case 1 -> AlchemicalForgeBlockEntity.this.forgeProgress;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    AlchemicalForgeBlockEntity.this.fuel = value;
                    break;
                }
                case 1: {
                    AlchemicalForgeBlockEntity.this.forgeProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public AlchemicalForgeBlockEntity(final BlockPos pos, BlockState state) {
        super(BlockRegistry.ALCHEMICAL_FORGE_ENTITY.get(), pos, state);
        this.itemContainer = new ItemStackHandler(7){

            public int getSlotLimit(int slot) {
                if (slot == 3 || slot == 4 || slot == 5) {
                    return 1;
                }
                return 64;
            }

            protected void onContentsChanged(int slot) {
                if (AlchemicalForgeBlockEntity.this.level != null) {
                    AlchemicalForgeBlockEntity.this.level.sendBlockUpdated(pos, AlchemicalForgeBlockEntity.this.getBlockState(), AlchemicalForgeBlockEntity.this.getBlockState(), 3);
                    AlchemicalForgeBlockEntity.this.setChanged();
                }
            }
        };
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity entity) {
        Direction directionToBody;
        BlockPos neighbourBlockPos;
        BlockEntity blockEntity;
        if (!(entity instanceof AlchemicalForgeBlockEntity)) {
            return;
        }
        AlchemicalForgeBlockEntity blockEntity2 = (AlchemicalForgeBlockEntity)entity;
        if (state.getValue(AlchemicalForgeBlock.PART) == ChestType.RIGHT && (blockEntity = level.getBlockEntity(neighbourBlockPos = pos.relative(directionToBody = AlchemicalForgeBlock.getNeighbourDirection((ChestType)state.getValue(AlchemicalForgeBlock.PART), (Direction)state.getValue((Property)AlchemicalForgeBlock.FACING))))) instanceof AlchemicalForgeBlockEntity) {
            AlchemicalForgeBlockEntity neighbourBlockEntity = (AlchemicalForgeBlockEntity)blockEntity;
            state = neighbourBlockEntity.isForging ? (BlockState)state.setValue((Property)AlchemicalForgeBlock.LIT, (Comparable)Boolean.valueOf(true)) : (BlockState)state.setValue((Property)AlchemicalForgeBlock.LIT, (Comparable)Boolean.valueOf(false));
            level.setBlock(pos, state, 2);
            return;
        }
        if (level.isClientSide()) {
            return;
        }
        ItemStack inputOutput = blockEntity2.itemContainer.getStackInSlot(0);
        ItemStack aux1 = blockEntity2.itemContainer.getStackInSlot(1);
        ItemStack aux2 = blockEntity2.itemContainer.getStackInSlot(2);
        ItemStack solution3 = blockEntity2.itemContainer.getStackInSlot(3);
        ItemStack solution4 = blockEntity2.itemContainer.getStackInSlot(4);
        ItemStack solution5 = blockEntity2.itemContainer.getStackInSlot(5);
        ItemStack fuel = blockEntity2.itemContainer.getStackInSlot(6);
        if (blockEntity2.fuel < 400 && fuel.is(ItemRegistry.TOXIN)) {
            int stackcount = blockEntity2.itemContainer.extractItem(6, ((Item)ItemRegistry.TOXIN.get()).getDefaultMaxStackSize(), false).getCount();
            blockEntity2.itemContainer.setStackInSlot(6, new ItemStack(ItemRegistry.GLASS_VIAL, stackcount));
            blockEntity2.addFuel(50 * stackcount);
            level.sendBlockUpdated(pos, state, state, 2);
        }
        if (blockEntity2.fuel >= 400 && blockEntity2.isForging) {
            if (blockEntity2.forgeProgress < 3000) {
                blockEntity2.forgeProgress = Mth.clamp((int)(blockEntity2.forgeProgress + 1), (int)0, (int)3000);
            } else {
                int i;
                Optional<RecipeHolder<AlchemicalForgeRecipe>> optionalRecipe = blockEntity2.findRecipe();
                NonNullList solutionItems = NonNullList.createWithCapacity((int)3);
                solutionItems.add((Object)solution3);
                solutionItems.add((Object)solution4);
                solutionItems.add((Object)solution5);
                ArrayList<ItemStack> auxiliaryItems = new ArrayList<ItemStack>(2);
                auxiliaryItems.add(aux1);
                auxiliaryItems.add(aux2);
                ItemStack newResultItem = new ItemStack(ItemRegistry.TOXIC_PASTE);
                if (optionalRecipe.isPresent()) {
                    newResultItem = ((AlchemicalForgeRecipe)optionalRecipe.get().value()).assemble(new AlchemicalForgeRecipeInput(inputOutput, (NonNullList<ItemStack>)solutionItems, auxiliaryItems), (HolderLookup.Provider)level.registryAccess());
                }
                for (i = 1; i < 6; ++i) {
                    blockEntity2.itemContainer.setStackInSlot(i, ItemStack.EMPTY);
                }
                for (i = 0; i < solutionItems.size(); ++i) {
                    if (((ItemStack)solutionItems.get(i)).isEmpty()) continue;
                    blockEntity2.itemContainer.setStackInSlot(i + 3, new ItemStack((ItemLike)ItemRegistry.GLASS_VIAL.get()));
                }
                blockEntity2.itemContainer.setStackInSlot(0, newResultItem);
                blockEntity2.resetAlchemicalForge();
            }
            level.sendBlockUpdated(pos, blockEntity2.getBlockState(), blockEntity2.getBlockState(), 2);
        }
        if (blockEntity2.isForging) {
            state = (BlockState)state.setValue((Property)AlchemicalForgeBlock.LIT, (Comparable)Boolean.valueOf(true));
            level.setBlock(pos, state, 3);
        } else {
            state = (BlockState)state.setValue((Property)AlchemicalForgeBlock.LIT, (Comparable)Boolean.valueOf(false));
            level.setBlock(pos, state, 3);
        }
    }

    public Optional<RecipeHolder<AlchemicalForgeRecipe>> findRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        if (this.itemContainer.getStackInSlot(0).isEmpty()) {
            return Optional.empty();
        }
        ItemStack inputItem = this.itemContainer.getStackInSlot(0);
        NonNullList solutionItems = NonNullList.createWithCapacity((int)3);
        solutionItems.add((Object)this.itemContainer.getStackInSlot(3));
        solutionItems.add((Object)this.itemContainer.getStackInSlot(4));
        solutionItems.add((Object)this.itemContainer.getStackInSlot(5));
        ArrayList<ItemStack> auxiliaryItems = new ArrayList<ItemStack>(2);
        auxiliaryItems.add(this.itemContainer.getStackInSlot(1));
        auxiliaryItems.add(this.itemContainer.getStackInSlot(2));
        AlchemicalForgeRecipeInput input = new AlchemicalForgeRecipeInput(inputItem, (NonNullList<ItemStack>)solutionItems, auxiliaryItems);
        return this.level.getRecipeManager().getRecipeFor(RecipeRegistry.ALCHEMICAL_FORGE_RECIPE.get(), (RecipeInput)input, this.level);
    }

    public void startAlchemicalForge() {
        if (this.level == null) {
            return;
        }
        this.forgeProgress = 0;
        this.isForging = true;
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }

    public void resetAlchemicalForge() {
        this.fuel -= 400;
        this.forgeProgress = 0;
        this.isForging = false;
    }

    public ItemStackHandler getItemContainer() {
        return this.itemContainer;
    }

    public void addFuel(int amount) {
        if (this.fuel + amount > 400) {
            this.fuel = 400;
            return;
        }
        this.fuel += amount;
    }

    public boolean hasFuel() {
        return this.fuel > 0;
    }

    public float getFuelPercentage() {
        return Mth.clamp((float)((float)this.data.get(0) / 400.0f), (float)0.0f, (float)1.0f);
    }

    public float getProgress() {
        return Mth.clamp((float)((float)this.data.get(1) / 3000.0f), (float)0.0f, (float)1.0f);
    }

    public boolean canForge() {
        boolean hasSolution = false;
        for (int i = 3; i < 6; ++i) {
            if (this.itemContainer.getStackInSlot(i).isEmpty()) continue;
            hasSolution = true;
            break;
        }
        return hasSolution && !this.itemContainer.getStackInSlot(0).isEmpty() && this.fuel >= 400;
    }

    private boolean isProgressing() {
        return this.forgeProgress > 0;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        NonNullList list = NonNullList.create();
        for (int i = 0; i < 7; ++i) {
            list.add(i, (Object)this.itemContainer.getStackInSlot(i).copy());
        }
        ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)list, (HolderLookup.Provider)registries);
        tag.putInt("Fuel", this.fuel);
        tag.putInt("ProgressTime", this.forgeProgress);
        tag.putBoolean("IsForging", this.isForging);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        NonNullList list = NonNullList.withSize((int)7, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)list, (HolderLookup.Provider)registries);
        for (int i = 0; i < 7; ++i) {
            this.itemContainer.setStackInSlot(i, (ItemStack)list.get(i));
        }
        this.fuel = tag.getInt("Fuel");
        this.forgeProgress = tag.getInt("ProgressTime");
        this.isForging = tag.getBoolean("IsForging");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        super.onDataPacket(connection, packet, registries);
    }

    public int getSlots() {
        return 7;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.itemContainer.getStackInSlot(slot).copy();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack itemStack = stack.copy();
        return this.itemContainer.insertItem(slot, itemStack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack returnItem;
        ItemStack targetStack = this.itemContainer.getStackInSlot(slot).copy();
        if (targetStack.getCount() > amount) {
            returnItem = targetStack.copy();
            returnItem.setCount(amount);
            targetStack.setCount(targetStack.getCount() - amount);
        } else {
            returnItem = targetStack.copy();
            this.itemContainer.setStackInSlot(slot, ItemStack.EMPTY);
        }
        return returnItem;
    }

    public int getSlotLimit(int slot) {
        return this.itemContainer.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 0) {
            return true;
        }
        return stack.getBurnTime(this.recipeType) > 0;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.toxony.alchemical_forge");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new AlchemicalForgeMenu(id, playerInventory, this, this.data, ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.worldPosition));
    }
}

